/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props.common;

import com.google.common.collect.Maps;
import com.mia.props.common.TileFake;
import com.mia.props.common.TileProps;
import com.mia.props.common.entities.TileBaseSwitchable;
import com.mia.props.common.entities.TileBed;
import com.mia.props.common.entities.TileChair;
import com.mia.props.common.entities.TileContainer;
import com.mia.props.common.entities.TileDecobench;
import com.mia.props.common.entities.TileDoor;
import com.mia.props.common.entities.TileFaucet;
import com.mia.props.common.entities.TileLinkedModel;
import com.mia.props.common.entities.TileMountable;
import com.mia.props.common.entities.TileParticleEmitter;
import com.mia.props.common.entities.TileParticleEmitterSwitchable;
import com.mia.props.common.entities.TileRecordPlayer;
import com.mia.props.common.entities.TileShowerHandles;
import com.mia.props.common.entities.TileShowerHead;
import com.mia.props.common.entities.TileSwitchableLamp;
import com.mia.props.common.entities.TileVariableRendering;
import java.util.Map;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum TileTypeMap {
    Props(TileProps.class, "TileBirdFountain"),
    BaseSwitchable(TileBaseSwitchable.class, new String[0]),
    Bed(TileBed.class, new String[0]),
    Chair(TileChair.class, new String[0]),
    Container(TileContainer.class, new String[0]),
    Decobench(TileDecobench.class, new String[0]),
    Mountable(TileMountable.class, new String[0]),
    ShowerHandles(TileShowerHandles.class, new String[0]),
    ShowerHead(TileShowerHead.class, new String[0]),
    SwitchableLamp(TileSwitchableLamp.class, new String[0]),
    ParticleEmitter(TileParticleEmitter.class, "TileChandelier", "TileChemistrySet", "TileCrystalChandelier", "TileCandleStick", "TileCandleWall"),
    ParticleEmitterSwitchable(TileParticleEmitterSwitchable.class, new String[0]),
    Faucet(TileFaucet.class, "TileKitchenFaucetInward", "TileKitchenFaucetOutward", "TileSinkFaucetInward", "TileSinkFaucetOutward", "TileTubFaucet"),
    VariableRendering(TileVariableRendering.class, new String[0]),
    RecordPlayer(TileRecordPlayer.class, new String[0]),
    Door(TileDoor.class, new String[0]),
    LinkedModel(TileLinkedModel.class, new String[0]);

    public static int tileEntityMapVersion;
    public static Map<String, String> lookupTable;
    private Class<? extends TileProps> clazz;
    private String[] altnames;

    private TileTypeMap(Class<? extends TileProps> clazz, String ... altnames) {
        this.clazz = clazz;
        this.altnames = altnames;
    }

    public Class<? extends TileProps> getTileClass() {
        return this.clazz;
    }

    public static TileTypeMap getTileType(Class<? extends TileProps> clazz) {
        for (TileTypeMap type : TileTypeMap.values()) {
            if (type.clazz != clazz) continue;
            return type;
        }
        return Props;
    }

    public static void register() {
        for (TileTypeMap type : TileTypeMap.values()) {
            String namespace_orig = "minecraft:";
            String namespace_target = "props:";
            String targetname = "props:" + type.clazz.getCanonicalName().toLowerCase();
            lookupTable.put("minecraft:" + type.clazz.getSimpleName().toLowerCase(), targetname);
            lookupTable.put("minecraft:" + type.clazz.getCanonicalName().toLowerCase(), targetname);
            lookupTable.put("minecraft:" + type.clazz.getCanonicalName().replace(".common.", ".").toLowerCase(), targetname);
            for (String s : type.altnames) {
                lookupTable.put("minecraft:com.mia.props.common.entities." + s.toLowerCase(), targetname);
                lookupTable.put("minecraft:com.mia.props.entities." + s.toLowerCase(), targetname);
            }
            lookupTable.put("props:" + type.clazz.getSimpleName().toLowerCase(), targetname);
            lookupTable.put("props:" + type.clazz.getCanonicalName().toLowerCase(), targetname);
            lookupTable.put("props:" + type.clazz.getCanonicalName().replace(".common.", ".").toLowerCase(), targetname);
            for (String s : type.altnames) {
                lookupTable.put("props:com.mia.props.common.entities." + s.toLowerCase(), targetname);
                lookupTable.put("props:com.mia.props.entities." + s.toLowerCase(), targetname);
            }
            GameRegistry.registerTileEntity(type.clazz, (String)targetname);
        }
        lookupTable.put("minecraft:tilefake", "props:" + TileFake.class.getCanonicalName().toLowerCase());
        GameRegistry.registerTileEntity(TileFake.class, (String)("props:" + TileFake.class.getCanonicalName().toLowerCase()));
    }

    static {
        tileEntityMapVersion = 1;
        lookupTable = Maps.newHashMap();
    }
}

