/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;
import pl.asie.foamfix.FoamFix;
import pl.asie.foamfix.ProxyCommon;
import pl.asie.foamfix.client.Deduplicator;
import pl.asie.foamfix.client.FoamFixDynamicItemModels;
import pl.asie.foamfix.client.FoamFixModelDeduplicate;
import pl.asie.foamfix.client.FoamFixModelRegistryDuplicateWipe;
import pl.asie.foamfix.client.ModelLoaderCleanup;
import pl.asie.foamfix.shared.FoamFixShared;

public class ProxyClient
extends ProxyCommon {
    public static Deduplicator deduplicator = new Deduplicator();
    public static final IBakedModel DUMMY_MODEL = new IBakedModel(){
        private final ItemOverrideList itemOverrideList = ItemOverrideList.field_188022_a;

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return Minecraft.func_71410_x().func_147117_R().getTextureExtry(TextureMap.field_174945_f.toString());
        }

        public ItemOverrideList func_188617_f() {
            return this.itemOverrideList;
        }
    };
    private ModelLoaderCleanup cleanup;

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new FoamFixModelDeduplicate());
        if (!FoamFixShared.config.geDeduplicate) {
            deduplicator = null;
        }
        if (FoamFixShared.config.clDynamicItemModels) {
            FoamFixDynamicItemModels.register();
        }
        if (FoamFixShared.config.clModelLoaderCleanup) {
            this.cleanup = new ModelLoaderCleanup();
            MinecraftForge.EVENT_BUS.register((Object)this.cleanup);
        }
        this.updateFasterAnimationFlag();
    }

    @Override
    public void updateFasterAnimationFlag() {
        if (FoamFixShared.config.txFasterAnimation) {
            boolean copyImageSupported;
            ContextCapabilities caps = GLContext.getCapabilities();
            boolean bl = copyImageSupported = caps.OpenGL43 || caps.GL_ARB_copy_image;
            if (!copyImageSupported) {
                FoamFix.logger.warn("Fast animated textures require OpenGL 4.3 or ARB_copy_image extension, which were not detected. Using original slow path.");
                FoamFix.shouldFasterAnimation = false;
            } else {
                FoamFix.logger.info("Using fast animated textures.");
                FoamFix.shouldFasterAnimation = true;
            }
        }
    }

    @Override
    public void init() {
        super.init();
        if (FoamFixShared.config.clCleanRedundantModelRegistry) {
            MinecraftForge.EVENT_BUS.register((Object)new FoamFixModelRegistryDuplicateWipe());
        }
        if (this.cleanup != null) {
            this.cleanup.tick();
        }
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    public void refreshResources() {
        Minecraft.func_71410_x().func_175603_A();
    }
}

