/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.Gson;
import gnu.trove.set.hash.TCustomHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentKeybind;
import net.minecraft.util.text.TextComponentScore;
import net.minecraft.util.text.TextComponentSelector;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.animation.AnimationItemOverrideList;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.logging.log4j.Logger;
import pl.asie.foamfix.client.FoamyItemLayerModel;
import pl.asie.foamfix.client.IDeduplicatingStorage;
import pl.asie.foamfix.shared.FoamFixShared;
import pl.asie.foamfix.util.DeduplicatingStorageTrove;
import pl.asie.foamfix.util.HashingStrategies;
import pl.asie.foamfix.util.MethodHandleHelper;

public class Deduplicator {
    private static final Set<Class> BLACKLIST_CLASS = new TCustomHashSet(HashingStrategies.IDENTITY);
    private static final Set<Class> TRIM_ARRAYS_CLASSES = new TCustomHashSet(HashingStrategies.IDENTITY);
    private static final Map<Class, Set<MethodHandle[]>> CLASS_FIELDS = new IdentityHashMap<Class, Set<MethodHandle[]>>();
    private static final Map<Class, MethodHandle> COLLECTION_CONSTRUCTORS = new IdentityHashMap<Class, MethodHandle>();
    private static final Style STYLE_EMPTY = new Style();
    private static final MethodHandle FIELD_UNPACKED_DATA_GETTER = MethodHandleHelper.findFieldGetter(UnpackedBakedQuad.class, "unpackedData");
    private static final MethodHandle FIELD_UNPACKED_DATA_SETTER = MethodHandleHelper.findFieldSetter(UnpackedBakedQuad.class, "unpackedData");
    private static final MethodHandle IPAM_MW_TRANSFORMS_GETTER = MethodHandleHelper.findFieldGetter(PerspectiveMapWrapper.class, "transforms");
    private static final MethodHandle IPAM_MW_TRANSFORMS_SETTER = MethodHandleHelper.findFieldSetter(PerspectiveMapWrapper.class, "transforms");
    private static final MethodHandle BIM_TRANSFORMS_GETTER = MethodHandleHelper.findFieldGetter("net.minecraftforge.client.model.BakedItemModel", "transforms");
    private static final MethodHandle BIM_TRANSFORMS_SETTER = MethodHandleHelper.findFieldSetter("net.minecraftforge.client.model.BakedItemModel", "transforms");
    private static final MethodHandle IOL_OVERRIDES_GETTER = MethodHandleHelper.findFieldGetter(ItemOverrideList.class, "overrides", "field_188023_b");
    private static final MethodHandle IOL_OVERRIDES_SETTER = MethodHandleHelper.findFieldSetter(ItemOverrideList.class, "overrides", "field_188023_b");
    public int successfulTrims = 0;
    public int successfuls = 0;
    public int maxRecursion = 0;
    private final Map<Object, Optional> JAVA_OPTIONALS = new HashMap<Object, Optional>();
    private final Map<Object, com.google.common.base.Optional> GUAVA_OPTIONALS = new HashMap<Object, com.google.common.base.Optional>();
    private final IDeduplicatingStorage<float[]> FLOATA_STORAGE = new DeduplicatingStorageTrove<float[]>(HashingStrategies.FLOAT_ARRAY);
    private final IDeduplicatingStorage<float[][]> FLOATAA_STORAGE = new DeduplicatingStorageTrove<float[][]>(HashingStrategies.FLOAT_ARRAY_ARRAY);
    private final IDeduplicatingStorage OBJECT_STORAGE = new DeduplicatingStorageTrove<Object>(HashingStrategies.GENERIC);
    private final IDeduplicatingStorage<ItemCameraTransforms> ICT_STORAGE = new DeduplicatingStorageTrove<ItemCameraTransforms>(HashingStrategies.ITEM_CAMERA_TRANSFORMS);
    private final Set<Object> deduplicatedObjects = new TCustomHashSet(HashingStrategies.IDENTITY);

    private static void addClassFromName(Set<Class> set, String className) {
        try {
            set.add(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private boolean shouldCheckClass(Class c) {
        if (BLACKLIST_CLASS.contains(c)) {
            return false;
        }
        if (c.isPrimitive() || c.isEnum() || c.isArray() && !this.shouldCheckClass(c.getComponentType())) {
            BLACKLIST_CLASS.add(c);
            return false;
        }
        return true;
    }

    public void addObject(Object o) {
        this.OBJECT_STORAGE.deduplicate(o);
    }

    public void addObjects(Collection coll) {
        for (Object o : coll) {
            this.OBJECT_STORAGE.deduplicate(o);
        }
    }

    public Object deduplicate0(Object o) {
        Object n = o;
        int size = 0;
        if (o instanceof float[]) {
            size = 24 + ((float[])o).length * 4;
            n = this.FLOATA_STORAGE.deduplicate((float[])o);
        } else if (o instanceof float[][]) {
            size = 16 + ((float[][])o).length * 4;
            float[][] arr = this.FLOATAA_STORAGE.deduplicate((float[][])o);
            if (arr != o) {
                n = arr;
                this.successfuls += arr.length;
            } else {
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = (float[])this.deduplicate0(arr[i]);
                }
            }
        } else if (o instanceof float[][][]) {
            float[][][] arr = (float[][][])o;
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (float[][])this.deduplicate0(arr[i]);
            }
        } else if (o instanceof ImmutableList || o instanceof ImmutableSet || o instanceof ImmutableMap) {
            n = this.OBJECT_STORAGE.deduplicate(o);
        } else {
            Class<?> c = o.getClass();
            if (ResourceLocation.class == c || ModelResourceLocation.class == c) {
                size = 16;
                n = this.OBJECT_STORAGE.deduplicate(o);
            } else if (Style.class == c && FoamFixShared.isCoremod) {
                n = this.deduplicateStyleIfCoremodPresent((Style)o);
            } else if (TRSRTransformation.class == c) {
                size = 257;
                n = this.OBJECT_STORAGE.deduplicate(o);
            } else if (ItemCameraTransforms.class == c) {
                size = 80;
                n = this.ICT_STORAGE.deduplicate((ItemCameraTransforms)o);
            } else {
                return null;
            }
        }
        if (n != o) {
            ++this.successfuls;
            FoamFixShared.ramSaved += size;
        }
        return n;
    }

    private Style deduplicateStyleIfCoremodPresent(Style s) {
        while (s.field_150248_c == null && s.field_150245_d == null && s.field_150244_g == null && s.field_150243_f == null && s.field_150246_e == null && s.field_150251_h == null && s.field_150252_i == null && s.field_150247_b == null && s.field_179990_j == null) {
            s = s.field_150249_a;
            if (s != null) continue;
            return STYLE_EMPTY;
        }
        return s;
    }

    private boolean trimArray(Object o) {
        if (o instanceof ArrayList) {
            ((ArrayList)o).trimToSize();
            ++this.successfulTrims;
            return true;
        }
        return false;
    }

    public Object deduplicateObject(Object o, int recursion) {
        block83: {
            boolean canTrim;
            Class<Object> c;
            block84: {
                if (o == null || recursion > this.maxRecursion) {
                    return o;
                }
                c = o.getClass();
                if (!this.shouldCheckClass(c)) {
                    return o;
                }
                if (!this.deduplicatedObjects.add(o)) {
                    return o;
                }
                boolean bl = canTrim = o instanceof Predicate || TRIM_ARRAYS_CLASSES.contains(c);
                if (canTrim && c == SimpleBakedModel.class) {
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        List l = ((SimpleBakedModel)o).func_188616_a(null, facing, 0L);
                        this.trimArray(l);
                    }
                }
                if (o instanceof IBakedModel) {
                    Object to;
                    if (o instanceof PerspectiveMapWrapper) {
                        try {
                            to = IPAM_MW_TRANSFORMS_GETTER.invoke(o);
                            Object toD = this.deduplicate0(to);
                            if (toD != null && to != toD) {
                                IPAM_MW_TRANSFORMS_SETTER.invoke(o, toD);
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    } else if ("net.minecraftforge.client.model.BakedItemModel".equals(c.getName())) {
                        try {
                            to = BIM_TRANSFORMS_GETTER.invoke(o);
                            Object toD = this.deduplicate0(to);
                            if (toD != null && to != toD) {
                                BIM_TRANSFORMS_SETTER.invoke(o, toD);
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
                if (!(o instanceof BakedQuad)) break block84;
                if (c == BakedQuad.class && FoamFixShared.config.expUnpackBakedQuads) {
                    BakedQuad quad = (BakedQuad)o;
                    UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(quad.getFormat());
                    quad.pipe((IVertexConsumer)builder);
                    o = builder.build();
                    c = UnpackedBakedQuad.class;
                }
                if (c != UnpackedBakedQuad.class) break block83;
                try {
                    float[][][] array = FIELD_UNPACKED_DATA_GETTER.invokeExact((UnpackedBakedQuad)o);
                    this.deduplicate0(array);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                break block83;
            }
            if (o instanceof ResourceLocation || o instanceof TRSRTransformation || c == Style.class) {
                return this.deduplicate0(o);
            }
            if (c == ItemCameraTransforms.class) {
                Object d = this.deduplicate0(o);
                if (d != o) {
                    return d;
                }
                return o;
            }
            if (o instanceof Item || o instanceof Block || o instanceof World || o instanceof Entity || o instanceof Logger || o instanceof IRegistry) {
                BLACKLIST_CLASS.add(c);
                return o;
            }
            if (o instanceof ItemOverrideList && o != ItemOverrideList.field_188022_a) {
                try {
                    List list = IOL_OVERRIDES_GETTER.invokeExact((ItemOverrideList)o);
                    if (!list.isEmpty()) break block83;
                    if (c == ItemOverrideList.class) {
                        ++this.successfuls;
                        return ItemOverrideList.field_188022_a;
                    }
                    if (c == AnimationItemOverrideList.class) {
                        IOL_OVERRIDES_SETTER.invokeExact((ItemOverrideList)o, (List)ImmutableList.of());
                        ++this.successfuls;
                    }
                }
                catch (Throwable list) {}
            } else {
                boolean deduplicated;
                Object opt;
                if (o instanceof Optional) {
                    opt = (Optional)o;
                    if (((Optional)opt).isPresent()) {
                        if (this.JAVA_OPTIONALS.containsKey(((Optional)opt).get())) {
                            ++this.successfuls;
                            return this.JAVA_OPTIONALS.get(((Optional)opt).get());
                        }
                        Object b = this.deduplicateObject(((Optional)opt).get(), recursion + 1);
                        if (b != null && b != ((Optional)opt).get()) {
                            Optional<Object> opt2 = Optional.of(b);
                            this.JAVA_OPTIONALS.put(b, opt2);
                            this.JAVA_OPTIONALS.put(((Optional)opt).get(), opt2);
                            return opt2;
                        }
                        this.JAVA_OPTIONALS.put(((Optional)opt).get(), (Optional)opt);
                        return opt;
                    }
                    return opt;
                }
                if (o instanceof com.google.common.base.Optional) {
                    opt = (com.google.common.base.Optional)o;
                    if (opt.isPresent()) {
                        if (this.GUAVA_OPTIONALS.containsKey(opt.get())) {
                            ++this.successfuls;
                            return this.GUAVA_OPTIONALS.get(opt.get());
                        }
                        Object b = this.deduplicateObject(opt.get(), recursion + 1);
                        if (b != null && b != opt.get()) {
                            com.google.common.base.Optional opt2 = com.google.common.base.Optional.of((Object)b);
                            this.GUAVA_OPTIONALS.put(b, opt2);
                            this.GUAVA_OPTIONALS.put(opt.get(), opt2);
                            return opt2;
                        }
                        this.GUAVA_OPTIONALS.put(opt.get(), (com.google.common.base.Optional)opt);
                        return opt;
                    }
                    return opt;
                }
                if (o instanceof Multimap) {
                    if (o instanceof ImmutableMultimap) {
                        for (Object value : ((ImmutableMultimap)o).values()) {
                            this.deduplicateObject(value, recursion + 1);
                        }
                    } else {
                        for (Object key : ((Multimap)o).keySet()) {
                            ArrayList l = Lists.newArrayList((Iterable)((Multimap)o).values());
                            for (int i = 0; i < l.size(); ++i) {
                                l.set(i, this.deduplicateObject(l.get(i), recursion + 1));
                            }
                            ((Multimap)o).replaceValues(key, (Iterable)l);
                        }
                    }
                } else if (o instanceof Map) {
                    if (o instanceof ImmutableMap) {
                        ImmutableMap im = (ImmutableMap)o;
                        HashMap newMap = new HashMap();
                        deduplicated = false;
                        UnmodifiableIterator i = im.keySet().iterator();
                        while (i.hasNext()) {
                            Object key;
                            Object a = im.get(key = i.next());
                            Object b = this.deduplicateObject(a, recursion + 1);
                            newMap.put(key, b != null ? b : a);
                            if (b == null || b == a) continue;
                            deduplicated = true;
                        }
                        if (deduplicated) {
                            if (o instanceof ImmutableSortedMap) {
                                return ImmutableSortedMap.copyOf(newMap);
                            }
                            if (o instanceof ImmutableBiMap) {
                                return ImmutableBiMap.copyOf(newMap);
                            }
                            return ImmutableMap.copyOf(newMap);
                        }
                    } else {
                        for (Object key : ((Map)o).keySet()) {
                            Object value = ((Map)o).get(key);
                            Object valueD = this.deduplicateObject(value, recursion + 1);
                            if (valueD == null || value == valueD) continue;
                            ((Map)o).put(key, valueD);
                        }
                    }
                } else if (o instanceof List) {
                    if (o instanceof ImmutableList) {
                        ImmutableList il = (ImmutableList)o;
                        ArrayList<Object> newList = new ArrayList<Object>();
                        deduplicated = false;
                        for (int i = 0; i < il.size(); ++i) {
                            Object a = il.get(i);
                            Object b = this.deduplicateObject(a, recursion + 1);
                            newList.add(b != null ? b : a);
                            if (b == null || b == a) continue;
                            deduplicated = true;
                        }
                        if (deduplicated) {
                            return ImmutableList.copyOf(newList);
                        }
                    } else {
                        List l = (List)o;
                        for (int i = 0; i < l.size(); ++i) {
                            l.set(i, this.deduplicateObject(l.get(i), recursion + 1));
                        }
                    }
                } else if (o instanceof Collection) {
                    MethodHandle constructor;
                    if (!COLLECTION_CONSTRUCTORS.containsKey(c)) {
                        try {
                            COLLECTION_CONSTRUCTORS.put(c, MethodHandles.publicLookup().findConstructor(c, MethodType.methodType(Void.TYPE)));
                        }
                        catch (Exception e) {
                            COLLECTION_CONSTRUCTORS.put(c, null);
                        }
                    }
                    if ((constructor = COLLECTION_CONSTRUCTORS.get(c)) != null) {
                        try {
                            Collection nc = constructor.invoke();
                            for (Object o1 : (Collection)o) {
                                nc.add(this.deduplicateObject(o1, recursion + 1));
                            }
                            return nc;
                        }
                        catch (Throwable nc) {
                            // empty catch block
                        }
                    }
                    for (Object o1 : (Collection)o) {
                        this.deduplicateObject(o1, recursion + 1);
                    }
                } else if (c.isArray()) {
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        Object entry = Array.get(o, i);
                        Object entryD = this.deduplicateObject(entry, recursion + 1);
                        if (entryD == null || entry == entryD) continue;
                        Array.set(o, i, entryD);
                    }
                } else {
                    if (!CLASS_FIELDS.containsKey(c)) {
                        ImmutableSet.Builder fsBuilder = ImmutableSet.builder();
                        Class<Object> cc = c;
                        do {
                            for (Field f : cc.getDeclaredFields()) {
                                if ((f.getModifiers() & 8) != 0 || !this.shouldCheckClass(f.getType())) continue;
                                try {
                                    f.setAccessible(true);
                                    fsBuilder.add((Object)new MethodHandle[]{MethodHandles.lookup().unreflectGetter(f), MethodHandles.lookup().unreflectSetter(f)});
                                }
                                catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                }
                            }
                        } while ((cc = cc.getSuperclass()) != Object.class);
                        CLASS_FIELDS.put(c, (Set<MethodHandle[]>)fsBuilder.build());
                    }
                    for (MethodHandle[] mh : CLASS_FIELDS.get(c)) {
                        try {
                            Object value = mh[0].invoke(o);
                            Object valueD = this.deduplicateObject(value, recursion + 1);
                            if (canTrim) {
                                this.trimArray(valueD);
                            }
                            if (valueD == null || value == valueD) continue;
                            mh[1].invoke(o, valueD);
                        }
                        catch (IllegalAccessException value) {
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }
        }
        return o;
    }

    static {
        TRIM_ARRAYS_CLASSES.add(TextComponentKeybind.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentScore.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentSelector.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentString.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentTranslation.class);
        TRIM_ARRAYS_CLASSES.add(VertexFormat.class);
        TRIM_ARRAYS_CLASSES.add(ModelBlock.class);
        TRIM_ARRAYS_CLASSES.add(ItemOverrideList.class);
        TRIM_ARRAYS_CLASSES.add(FoamyItemLayerModel.DynamicItemModel.class);
        TRIM_ARRAYS_CLASSES.add(SimpleBakedModel.class);
        TRIM_ARRAYS_CLASSES.add(WeightedBakedModel.class);
        BLACKLIST_CLASS.add(Object.class);
        BLACKLIST_CLASS.add(Class.class);
        BLACKLIST_CLASS.add(String.class);
        BLACKLIST_CLASS.add(Integer.class);
        BLACKLIST_CLASS.add(Long.class);
        BLACKLIST_CLASS.add(Byte.class);
        BLACKLIST_CLASS.add(Boolean.class);
        BLACKLIST_CLASS.add(Float.class);
        BLACKLIST_CLASS.add(Double.class);
        BLACKLIST_CLASS.add(Short.class);
        BLACKLIST_CLASS.add(TextureAtlasSprite.class);
        BLACKLIST_CLASS.add(ItemStack.class);
        BLACKLIST_CLASS.add(Gson.class);
        BLACKLIST_CLASS.add(ModelLoader.class);
        BLACKLIST_CLASS.add(Class.class);
        BLACKLIST_CLASS.add(BlockPart.class);
        BLACKLIST_CLASS.add(Minecraft.class);
        BLACKLIST_CLASS.add(BlockModelShapes.class);
        BLACKLIST_CLASS.add(ModelManager.class);
        BLACKLIST_CLASS.add(Logger.class);
        BLACKLIST_CLASS.add(Joiner.class);
        BLACKLIST_CLASS.add(Tessellator.class);
        BLACKLIST_CLASS.add(Cache.class);
        BLACKLIST_CLASS.add(LoadingCache.class);
        BLACKLIST_CLASS.add(VertexFormatElement.class);
        Deduplicator.addClassFromName(BLACKLIST_CLASS, "net.minecraft.client.renderer.VertexBuffer");
        Deduplicator.addClassFromName(BLACKLIST_CLASS, "net.minecraft.client.renderer.BufferBuilder");
    }
}

