/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client;

import java.lang.reflect.Field;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.MultipartBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import pl.asie.foamfix.FoamFix;
import pl.asie.foamfix.ProxyClient;
import pl.asie.foamfix.client.Deduplicator;
import pl.asie.foamfix.client.FoamyMultipartBakedModel;
import pl.asie.foamfix.shared.FoamFixShared;

public class FoamFixModelDeduplicate {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onModelBake(ModelBakeEvent event) {
        if (FoamFixShared.config.geDeduplicate) {
            ProgressManager.ProgressBar bakeBar = ProgressManager.push((String)"FoamFix: deduplicating", (int)(event.getModelRegistry().func_148742_b().size() + 2));
            if (ProxyClient.deduplicator == null) {
                ProxyClient.deduplicator = new Deduplicator();
            }
            ProxyClient.deduplicator.maxRecursion = FoamFixShared.config.clDeduplicateRecursionLevel;
            FoamFix.logger.info("Deduplicating models...");
            ProxyClient.deduplicator.addObjects(ForgeRegistries.BLOCKS.getKeys());
            ProxyClient.deduplicator.addObjects(ForgeRegistries.ITEMS.getKeys());
            try {
                bakeBar.step("Vertex formats");
                for (Field field : DefaultVertexFormats.class.getDeclaredFields()) {
                    if (field.getType() != VertexFormat.class) continue;
                    field.setAccessible(true);
                    ProxyClient.deduplicator.deduplicateObject(field.get(null), 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (ModelResourceLocation loc : event.getModelRegistry().func_148742_b()) {
                IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)loc);
                String string = loc.toString();
                bakeBar.step(String.format("[%s]", string));
                if (model instanceof MultipartBakedModel) {
                    ++ProxyClient.deduplicator.successfuls;
                    model = new FoamyMultipartBakedModel((MultipartBakedModel)model);
                }
                try {
                    ProxyClient.deduplicator.addObject(loc);
                    event.getModelRegistry().func_82595_a((Object)loc, (Object)((IBakedModel)ProxyClient.deduplicator.deduplicateObject(model, 0)));
                }
                catch (Exception exception) {}
            }
            try {
                bakeBar.step("Stats");
                for (Field field : StatList.class.getDeclaredFields()) {
                    if (field.getType() != StatBase[].class) continue;
                    field.setAccessible(true);
                    for (StatBase statBase : (StatBase[])field.get(null)) {
                        ProxyClient.deduplicator.deduplicateObject(statBase, 0);
                    }
                }
                for (StatBase statBase : StatList.field_75940_b) {
                    ProxyClient.deduplicator.deduplicateObject(statBase, 0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProgressManager.pop((ProgressManager.ProgressBar)bakeBar);
            FoamFix.logger.info("Deduplicated " + ProxyClient.deduplicator.successfuls + " (+ " + ProxyClient.deduplicator.successfulTrims + ") objects.");
        }
        ProxyClient.deduplicator = null;
        FoamFix.updateRamSaved();
    }
}

