/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.IXUItem;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.NullModel;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.backend.model.UV;
import com.rwtema.extrautils2.compatibility.CompatHelper112;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.NullHelper;
import com.rwtema.extrautils2.utils.helpers.QuadHelper;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class PassthruModelItem
extends NullModel {
    public static WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>> quads2dcache = new WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>>(){

        @Override
        public ImmutableList<BakedQuad> get(Object key) {
            ImmutableList bakedQuads = (ImmutableList)super.get(key);
            if (bakedQuads == null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)key;
                if (sprite == null) {
                    sprite = Textures.MISSING_SPRITE;
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.SOUTH, -1, 0.0f, 0.0f, 0.5f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.5f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.5f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.5f, sprite.func_94212_f(), sprite.func_94210_h(), sprite));
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.NORTH, -1, 0.0f, 0.0f, 0.5f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.5f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.5f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.5f, sprite.func_94209_e(), sprite.func_94206_g(), sprite));
                bakedQuads = builder.build();
                this.put(sprite, bakedQuads);
            }
            return bakedQuads;
        }
    };
    public static WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>> pseudoQuads2dCache = new WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>>(){

        @Override
        public ImmutableList<BakedQuad> get(Object key) {
            ImmutableList bakedQuads = (ImmutableList)super.get(key);
            if (bakedQuads == null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)key;
                if (sprite == null) {
                    sprite = Textures.MISSING_SPRITE;
                }
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.SOUTH, -1, 0.0f, 0.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94210_h(), sprite));
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), EnumFacing.NORTH, -1, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g(), sprite));
                bakedQuads = builder.build();
                this.put(sprite, bakedQuads);
            }
            return bakedQuads;
        }
    };
    public static WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>> quads3dcache = new WeakHashMap<TextureAtlasSprite, ImmutableList<BakedQuad>>(){

        @Override
        public ImmutableList<BakedQuad> get(Object key) {
            ImmutableList bakedQuads = (ImmutableList)super.get(key);
            if (bakedQuads == null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)key;
                if (sprite == null) {
                    sprite = Textures.MISSING_SPRITE;
                }
                bakedQuads = ItemLayerModel.getQuadsForSprite((int)-1, (TextureAtlasSprite)sprite, (VertexFormat)DefaultVertexFormats.field_176599_b, CompatHelper112.optionalOf(TRSRTransformation.identity()));
                this.put(sprite, bakedQuads);
            }
            return bakedQuads;
        }
    };
    public static TIntObjectHashMap<WeakHashMap<BakedQuad, BakedQuad>> tintedQuads = new TIntObjectHashMap<WeakHashMap<BakedQuad, BakedQuad>>(){

        public WeakHashMap<BakedQuad, BakedQuad> get(final int key) {
            WeakHashMap weakHashMap = (WeakHashMap)super.get(key);
            if (weakHashMap != null) {
                return weakHashMap;
            }
            weakHashMap = new WeakHashMap<BakedQuad, BakedQuad>(){

                @Override
                public BakedQuad get(Object quadKey) {
                    BakedQuad quadTint = (BakedQuad)super.get(quadKey);
                    if (quadTint != null) {
                        return quadTint;
                    }
                    BakedQuad quad = (BakedQuad)quadKey;
                    quadTint = new BakedQuad(quad.func_178209_a(), key, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
                    this.put(quad, quadTint);
                    return quadTint;
                }
            };
            this.put(key, weakHashMap);
            return weakHashMap;
        }
    };
    protected final IXUItem item;
    protected Supplier<ModelLayer> modelFactory;
    protected ItemOverrideList overrideList = new ItemOverrideList((List)ImmutableList.of()){

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            try {
                ModelLayer model = PassthruModelItem.this.modelFactory.get();
                PassthruModelItem.this.item.addQuads(model, stack);
                return model;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Getting model for itemstack");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being processed");
                crashreportcategory.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)stack.func_77973_b()));
                crashreportcategory.func_71507_a("Item data", (Object)stack.func_77960_j());
                crashreportcategory.func_189529_a("Item name", () -> ((ItemStack)stack).func_82833_r());
                throw new ReportedException(crashreport);
            }
        }
    };

    public PassthruModelItem(IXUItem item) {
        this(item, item.renderAsTool() ? Transforms.itemToolsTransforms : Transforms.itemTransforms);
    }

    public PassthruModelItem(IXUItem item, EnumMap<ItemCameraTransforms.TransformType, Matrix4f> transforms) {
        this(item, () -> new ModelLayer(transforms));
    }

    public PassthruModelItem(IXUItem item, Supplier<ModelLayer> model) {
        this.item = item;
        this.modelFactory = model;
    }

    public static boolean isTransparent(int[] pixels, int uMax, int vMax, int u, int v) {
        return (pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF) == 0;
    }

    public static Collection<? extends BakedQuad> trySplitQuad(BakedQuad quad, TextureAtlasSprite newsprite) {
        TextureAtlasSprite sprite = quad.func_187508_a();
        if (NullHelper.nullable(sprite) == null) {
            return ImmutableList.of((Object)new BakedQuadRetextured(quad, newsprite));
        }
        int uMax = sprite.func_94211_a();
        int vMax = sprite.func_94216_b();
        VertexFormat format = quad.getFormat();
        int[] pixels = sprite.func_147965_a(0)[0];
        int offset_position = format.func_177343_g().indexOf(DefaultVertexFormats.field_181713_m);
        int offset_color = format.func_177343_g().indexOf(DefaultVertexFormats.field_181714_n);
        int offset_tex = format.func_177343_g().indexOf(DefaultVertexFormats.field_181715_o);
        if (offset_position == -1 || offset_color == -1 || offset_tex == -1) {
            return ImmutableList.of((Object)new BakedQuadRetextured(quad, newsprite));
        }
        offset_position = format.func_181720_d(offset_position) / 4;
        offset_color = format.func_181720_d(offset_color) / 4;
        offset_tex = format.func_181720_d(offset_tex) / 4;
        int[] vertexData = quad.func_178209_a();
        UV[] vecs = new UV[4];
        float uh = 1.0f / (sprite.func_94212_f() - sprite.func_94209_e());
        float vh = 1.0f / (sprite.func_94210_h() - sprite.func_94206_g());
        for (int i = 0; i < 4; ++i) {
            int nextOffset = format.func_181719_f() * i;
            vecs[i] = new UV(Float.intBitsToFloat(vertexData[offset_position + nextOffset]), Float.intBitsToFloat(vertexData[offset_position + 1 + nextOffset]), Float.intBitsToFloat(vertexData[offset_position + 2 + nextOffset]), MathHelper.func_76131_a((float)((Float.intBitsToFloat(vertexData[offset_tex + nextOffset]) - sprite.func_94209_e()) * uh), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)((Float.intBitsToFloat(vertexData[offset_tex + 1 + nextOffset]) - sprite.func_94206_g()) * vh), (float)0.0f, (float)1.0f));
        }
        float umin = Float.POSITIVE_INFINITY;
        float vmin = Float.POSITIVE_INFINITY;
        float umax = Float.NEGATIVE_INFINITY;
        float vmax = Float.NEGATIVE_INFINITY;
        for (UV vec : vecs) {
            umin = Math.min(umin, vec.u);
            vmin = Math.min(vmin, vec.v);
            umax = Math.max(umax, vec.u);
            vmax = Math.max(vmax, vec.v);
        }
        int u_lower = MathHelper.func_76141_d((float)(umin * 16.0f));
        int u_upper = MathHelper.func_76123_f((float)(umax * 16.0f));
        int v_lower = MathHelper.func_76141_d((float)(vmin * 16.0f));
        int v_upper = MathHelper.func_76123_f((float)(vmax * 16.0f));
        if ((double)((float)u_upper - umax * 16.0f) < 0.001) {
            umax = (float)u_upper / 16.0f;
        }
        if ((double)((float)v_upper - vmax * 16.0f) < 0.001) {
            vmax = (float)v_upper / 16.0f;
        }
        if (u_lower == u_upper || v_lower == v_upper) {
            return ImmutableList.of((Object)new BakedQuadRetextured(quad, newsprite));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = Math.max(u_upper - u_lower, v_upper - v_lower);
        int u_m = MathHelper.func_76123_f((float)(Math.max(Math.abs(vecs[1].u - vecs[0].u), Math.abs(vecs[1].v - vecs[0].v)) * 16.0f));
        int v_m = MathHelper.func_76123_f((float)(Math.max(Math.abs(vecs[2].u - vecs[3].u), Math.abs(vecs[2].v - vecs[3].v)) * 16.0f));
        for (int du = 0; du < u_m; ++du) {
            for (int dv = 0; dv < v_m; ++dv) {
                int color;
                int alpha;
                int center_v;
                float u0 = (float)du / (float)u_m;
                float v0 = (float)dv / (float)i;
                float u1 = (float)(du + 1) / (float)u_m;
                float v1 = (float)(dv + 1) / (float)v_m;
                UV[] uvs = new UV[]{UV.interpolateQuad(vecs, u0, v0), UV.interpolateQuad(vecs, u1, v0), UV.interpolateQuad(vecs, u1, v1), UV.interpolateQuad(vecs, u0, v1)};
                UV center_uv = UV.interpolateQuad(uvs, 0.5f, 0.5f);
                int center_u = MathHelper.func_76125_a((int)MathHelper.func_76125_a((int)Math.round(center_uv.u * 16.0f - 0.05f), (int)u_lower, (int)u_upper), (int)0, (int)(uMax - 1));
                int i1 = center_u + (center_v = MathHelper.func_76125_a((int)MathHelper.func_76125_a((int)Math.round(center_uv.v * 16.0f - 0.05f), (int)v_lower, (int)v_upper), (int)0, (int)(vMax - 1))) * uMax;
                if (i1 < 0 || i1 >= pixels.length || (alpha = (color = pixels[i1]) >> 24 & 0xFF) <= 4) continue;
                int b = ColorHelper.brightness(color) * 120 / 256 + 136;
                int new_color = ColorHelper.color(b, b, b, alpha);
                builder.add((Object)QuadHelper.buildQuad(DefaultVertexFormats.field_176599_b, TRSRTransformation.identity(), quad.func_178210_d(), quad.func_178211_c(), uvs[0], uvs[1], uvs[2], uvs[3], new_color, new_color, new_color, new_color, newsprite));
            }
        }
        return builder.build();
    }

    public static List<BakedQuad> buildFrontQuads(TextureAtlasSprite sprite, TextureAtlasSprite override) {
        int uMax = sprite.func_94211_a();
        int vMax = sprite.func_94216_b();
        VertexFormat format = DefaultVertexFormats.field_176599_b;
        ImmutableList.Builder builder = ImmutableList.builder();
        int[] pixels = sprite.func_147965_a(0)[0];
        for (int v = 0; v < vMax; ++v) {
            for (int u = 0; u < uMax; ++u) {
                int color = pixels[u + (vMax - 1 - v) * uMax];
                int alpha = color >> 24 & 0xFF;
                if (alpha == 0) continue;
                float u0 = (float)u / (float)uMax;
                float u1 = ((float)u + 1.0f) / (float)uMax;
                float v0 = (float)v / (float)vMax;
                float v1 = ((float)v + 1.0f) / (float)vMax;
                float ou0 = override.func_94214_a((double)(16.0f * u0));
                float ou1 = override.func_94214_a((double)(16.0f * u1));
                float ov0 = override.func_94207_b((double)(16.0f * v0));
                float ov1 = override.func_94207_b((double)(16.0f * v1));
                int b = 255;
                if (u != 0 && v != 0 && u != uMax - 1 && v != vMax - 1) {
                    block2: for (int du = -1; du <= 1; ++du) {
                        for (int dv = -1; dv <= 1; ++dv) {
                            if ((pixels[u + du + (vMax - 1 - v + dv) * uMax] >> 24 & 0xFF) != 0) continue;
                            if (du == 0 || dv == 0) {
                                b = 120;
                                break block2;
                            }
                            b = 200;
                        }
                    }
                }
                b = (ColorHelper.brightness(color) * 40 + b * 216) / 256;
                color = ColorHelper.color(b, b, b, alpha);
                builder.add((Object)QuadHelper.buildQuad(format, TRSRTransformation.identity(), EnumFacing.NORTH, -1, u0, v0, 0.46875f, ou0, ov1, u1, v0, 0.46875f, ou1, ov1, u1, v1, 0.46875f, ou1, ov0, u0, v1, 0.46875f, ou0, ov0, color, sprite));
                builder.add((Object)QuadHelper.buildQuad(format, TRSRTransformation.identity(), EnumFacing.SOUTH, -1, u0, v0, 0.53125f, ou0, ov1, u0, v1, 0.53125f, ou0, ov0, u1, v1, 0.53125f, ou1, ov0, u1, v0, 0.53125f, ou1, ov1, color, sprite));
            }
        }
        return builder.build();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    @Override
    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.item.getBaseTexture();
    }

    public static class ModelLayer
    extends MutableModel {
        static ItemCameraTransforms.TransformType[] types = new ItemCameraTransforms.TransformType[]{ItemCameraTransforms.TransformType.GUI, ItemCameraTransforms.TransformType.NONE};
        public MutableModel lowPolyVersion;

        public ModelLayer(EnumMap<ItemCameraTransforms.TransformType, Matrix4f> itemTransforms) {
            super(itemTransforms);
            this.isGui3D = false;
            this.ambientOcclusion = false;
            this.lowPolyVersion = new MutableModel(itemTransforms);
            for (ItemCameraTransforms.TransformType type : types) {
                this.transformMap.put(type, Pair.of((Object)this.lowPolyVersion, (Object)((Pair)this.transformMap.get(type)).getRight()));
            }
        }

        public void addBoxModel(BoxModel boxModel) {
            for (Box box : boxModel) {
                for (EnumFacing facing : EnumFacing.values()) {
                    List<BakedQuad> quads = box.getQuads(facing);
                    if (quads == null) continue;
                    this.addAllQuads(quads);
                }
                List<BakedQuad> quads = box.getQuads(null);
                if (quads == null) continue;
                this.addAllQuads(quads);
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.lowPolyVersion.clear();
        }

        public void addSprite(TextureAtlasSprite sprite) {
            this.generalQuads.addAll((Collection)quads3dcache.get(sprite));
            this.lowPolyVersion.generalQuads.addAll((Collection)quads2dcache.get(sprite));
        }

        public void addSprite(TextureAtlasSprite sprite, boolean draw3d) {
            if (this.tex == null) {
                this.tex = sprite;
            }
            this.generalQuads.addAll((Collection)(draw3d ? quads3dcache : quads2dcache).get(sprite));
            this.lowPolyVersion.generalQuads.addAll((Collection)quads2dcache.get(sprite));
        }

        public void addTintedSprite(TextureAtlasSprite sprite, boolean draw3d, int tint) {
            if (tint == -1) {
                this.addSprite(sprite, draw3d);
            } else {
                for (BakedQuad bakedQuad : (draw3d ? quads3dcache : quads2dcache).get(sprite)) {
                    this.generalQuads.add(((WeakHashMap)tintedQuads.get(tint)).get(bakedQuad));
                }
                for (BakedQuad bakedQuad : quads2dcache.get(sprite)) {
                    this.lowPolyVersion.generalQuads.add((BakedQuad)((WeakHashMap)tintedQuads.get(tint)).get(bakedQuad));
                }
            }
        }

        public void addQuad(BakedQuad quad) {
            this.generalQuads.add(quad);
            this.lowPolyVersion.generalQuads.add(quad);
        }

        public void addAllQuads(Collection<BakedQuad> quads) {
            this.generalQuads.addAll(quads);
            this.lowPolyVersion.generalQuads.addAll(quads);
        }
    }
}

