/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.ItemStackHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRedOrchid
extends XUBlockStatic
implements IPlantable,
IGrowable {
    public static final PropertyInteger GROWTH_STATE = PropertyInteger.func_177719_a((String)"growth", (int)0, (int)6);
    static float[] size_w = new float[]{0.0625f, 0.0625f, 0.125f, 0.1875f, 0.1875f, 0.25f, 0.3125f};
    static float[] size_h = new float[]{0.3125f, 0.5f, 0.5625f, 0.6875f, 0.75f, 0.8125f, 1.0f};
    public final IBlockState FULLY_GROWN_STATE;
    EnumPlantType redstone = EnumPlantType.getPlantType((String)"Redstone");
    HashSet<IBlockState> validStates = null;

    public BlockRedOrchid() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.FULLY_GROWN_STATE = this.func_176223_P().func_177226_a((IProperty)GROWTH_STATE, (Comparable)Integer.valueOf(6));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i = (Integer)state.func_177229_b((IProperty)GROWTH_STATE);
        if (i >= 6 || rand.nextInt(3) != 0) {
            return;
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)GROWTH_STATE, (Comparable)Integer.valueOf(i + 1)), 2);
        if (i + 1 == 6 && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150450_ax) {
            worldIn.func_175656_a(pos.func_177977_b(), Blocks.field_150439_ay.func_176223_P());
        }
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)GROWTH_STATE);
        if ((i += MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5)) >= 6) {
            i = 6;
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150450_ax) {
                worldIn.func_175656_a(pos.func_177977_b(), Blocks.field_150439_ay.func_176223_P());
            }
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)GROWTH_STATE, (Comparable)Integer.valueOf(i)), 2);
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator((XUBlock)this, new IProperty[]{GROWTH_STATE});
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        int value = (Integer)state.func_177229_b((IProperty)GROWTH_STATE);
        BoxModel boxes = BoxModel.crossBoxModel().setTexture("plants/redorchid_" + value);
        boxes.addBoxI(0, 0, 0, 16, 0, 16, "plants/redorchid_base_" + value).setInvisible(61);
        for (Box box : boxes) {
            box.noCollide = true;
            box.setLayer(BlockRenderLayer.CUTOUT);
        }
        boxes.overrideBounds = new Box(0.5f - size_w[value], 0.0f, 0.5f - size_w[value], 0.5f + size_w[value], size_h[value], 0.5f + size_w[value]);
        return boxes;
    }

    public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)GROWTH_STATE) < 6;
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return true;
    }

    @Override
    public void neighborChangedBase(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        if (!this.validLocation(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return;
        }
        super.neighborChangedBase(state, worldIn, pos, neighborBlock);
        if (state == this.FULLY_GROWN_STATE && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150450_ax) {
            worldIn.func_175656_a(pos.func_177977_b(), Blocks.field_150439_ay.func_176223_P());
        }
    }

    @Override
    public boolean canReplaceBase(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side, ItemStack stack) {
        return this.validLocation(worldIn, pos) && super.canReplaceBase(worldIn, pos, side, stack);
    }

    @Override
    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        List<ItemStack> drops = super.getDrops(world, pos, state, fortune);
        if (state == this.FULLY_GROWN_STATE) {
            this.addAdditionalDrops(fortune, drops, world instanceof World ? ((World)world).field_73012_v : RANDOM);
        }
        return drops;
    }

    protected List<ItemStack> addAdditionalDrops(int fortune, List<ItemStack> drops, Random random) {
        int n = 1 + random.nextInt(1 + fortune);
        for (int i = 0; i < n; ++i) {
            drops.add(new ItemStack(Items.field_151137_ax, 1));
        }
        int k = random.nextInt(3 + fortune) - random.nextInt(10);
        if (k > 0) {
            for (int i = 0; i < k; ++i) {
                drops.add(new ItemStack((Block)this, 1));
            }
        }
        return drops;
    }

    public boolean validLocation(World world, BlockPos pos) {
        if (this.validStates == null) {
            this.validStates = new HashSet();
            this.validStates.add(Blocks.field_150450_ax.func_176223_P());
            this.validStates.add(Blocks.field_150439_ay.func_176223_P());
            ItemStackHelper.addBlockStates("oreRedstone", this.validStates);
        }
        return this.validStates.contains(world.func_180495_p(pos.func_177977_b()));
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return this.redstone;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        if (world == null || pos == null) {
            return this.func_176223_P();
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public MutableModel createInventoryMutableModel() {
        return new PassthruModelItem.ModelLayer(Transforms.itemTransforms);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        super.registerTextures();
        Textures.register("plants/redorchid_seeds");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInventoryQuads(MutableModel result, ItemStack stack) {
        PassthruModelItem.ModelLayer layer = (PassthruModelItem.ModelLayer)result;
        layer.clear();
        layer.addSprite((TextureAtlasSprite)Textures.sprites.get((Object)"plants/redorchid_seeds"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)GROWTH_STATE) != 6) {
            return;
        }
        AxisAlignedBB bb = this.func_180640_a(state, worldIn, pos);
        for (int i = 0; i < 2; ++i) {
            double x = MathHelper.func_82716_a((Random)rand, (double)bb.field_72340_a, (double)bb.field_72336_d);
            double y = MathHelper.func_82716_a((Random)rand, (double)bb.field_72338_b, (double)bb.field_72337_e);
            double z = MathHelper.func_82716_a((Random)rand, (double)bb.field_72339_c, (double)bb.field_72334_f);
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState == this.FULLY_GROWN_STATE ? 15 : 0;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return state == this.FULLY_GROWN_STATE;
    }

    public boolean func_149744_f(IBlockState state) {
        return state == this.FULLY_GROWN_STATE;
    }

    @Override
    public boolean onBlockActivatedBase(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (state != this.FULLY_GROWN_STATE) {
            return false;
        }
        worldIn.func_175656_a(pos, this.func_176223_P());
        if (worldIn.field_72995_K) {
            return true;
        }
        List<ItemStack> drops = this.addAdditionalDrops(EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185308_t, (EntityLivingBase)playerIn), Lists.newArrayList(), worldIn.field_73012_v);
        for (ItemStack drop : drops) {
            BlockRedOrchid.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
        }
        return true;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(Lang.translatePrefix("Plant on redstone ore."));
    }
}

