/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power;

import com.mojang.authlib.GameProfile;
import com.rwtema.extrautils2.backend.save.SaveModule;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.utils.LogHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import gnu.trove.set.hash.TIntHashSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PowerSettings
extends SaveModule {
    public static PowerSettings instance = new PowerSettings();

    public PowerSettings() {
        super("PowerAlliances");
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        LogHelper.oneTimeInfo("Loaded Power Settings");
        for (NBTTagCompound freqEntry : NBTHelper.iterateNBTTagList(nbt.func_150295_c("PlayerFreq", 10))) {
            int a = freqEntry.func_74762_e("Freq");
            GameProfile profile = NBTHelper.profileFromNBT(freqEntry.func_74775_l("Profile"));
            if (a == 0 || profile == null) continue;
            int[] b = freqEntry.func_74759_k("Allies");
            PowerManager.instance.frequncies.put(a, (Object)profile);
            if (b == null || b.length <= 0) continue;
            PowerManager.instance.alliances.put(a, (Object)new TIntHashSet(b));
        }
        try {
            PowerManager.instance.unloadedChunkManager.deserializeNBT(nbt.func_150295_c("UnloadedChunkData", 10));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            PowerManager.instance.unloadedChunkManager.freqs.clear();
        }
        PowerManager.instance.lockedFrequencies.addAll(nbt.func_74759_k("LockedFreqs"));
        PowerManager.instance.reassignValues();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList playerFreq = new NBTTagList();
        PowerManager.instance.frequncies.forEachEntry((a, b) -> {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Freq", a);
            tag.func_74782_a("Profile", (NBTBase)NBTHelper.proifleToNBT(b));
            TIntHashSet set = (TIntHashSet)PowerManager.instance.alliances.get(a);
            if (set != null && !set.isEmpty()) {
                tag.func_74783_a("Allies", set.toArray());
            }
            playerFreq.func_74742_a((NBTBase)tag);
            return true;
        });
        nbt.func_74782_a("PlayerFreq", (NBTBase)playerFreq);
        try {
            nbt.func_74782_a("UnloadedChunkData", (NBTBase)PowerManager.instance.unloadedChunkManager.serializeNBT());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            nbt.func_82580_o("UnloadedChunkData");
        }
        nbt.func_74783_a("LockedFreqs", PowerManager.instance.lockedFrequencies.toArray());
    }

    @Override
    public void reset() {
        PowerManager.instance.frequncies.clear();
        PowerManager.instance.alliances.clear();
        PowerManager.instance.unloadedChunkManager.freqs.clear();
        PowerManager.instance.lockedFrequencies.clear();
    }
}

