/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.model.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import me.ichun.mods.ichunutil.common.core.util.ObfHelper;
import me.ichun.mods.ichunutil.common.module.tabula.project.components.CubeInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelCreeper;
import net.minecraft.client.model.ModelHorse;
import net.minecraft.client.model.ModelIronGolem;
import net.minecraft.client.model.ModelOcelot;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRabbit;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelSpider;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.model.ModelWolf;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ModelHelper {
    public static Random rand = new Random();
    public static HashMap<Class<? extends ModelBase>, ModelRenderer[]> armMappings = new HashMap();
    public static HashMap<Class<? extends Render>, ArrayList<ModelRenderer>> classToModelRendererMap = new HashMap();

    public static ArrayList<ModelRenderer> separateChildren(ArrayList<ModelRenderer> modelList) {
        for (int i = 0; i < modelList.size(); ++i) {
            ModelRenderer renderer = modelList.get(i);
            if (renderer.field_78805_m == null) continue;
            ArrayList<ModelRenderer> children = new ArrayList<ModelRenderer>();
            while (!renderer.field_78805_m.isEmpty()) {
                children.add((ModelRenderer)renderer.field_78805_m.get(renderer.field_78805_m.size() - 1));
                renderer.field_78805_m.remove(renderer.field_78805_m.size() - 1);
            }
            ModelHelper.separateChildren(children);
            modelList.addAll(children);
        }
        return modelList;
    }

    public static ArrayList<ModelRenderer> getModelCubesCopy(ArrayList<ModelRenderer> modelList, ModelBase base, Entity ent) {
        if (Minecraft.func_71410_x().func_175598_ae().field_78724_e != null && Minecraft.func_71410_x().func_175598_ae().field_78734_h != null && ent != null) {
            for (int i = 0; i < modelList.size(); ++i) {
                ModelRenderer cube = modelList.get(i);
                if (!cube.field_78812_q) continue;
                GLAllocation.func_74523_b((int)cube.field_78811_r);
                cube.field_78812_q = false;
            }
            Minecraft.func_71410_x().func_175598_ae().func_78713_a(ent).func_76986_a(ent, 0.0, -500.0, 0.0, 0.0f, 1.0f);
            ArrayList<ModelRenderer> modelListCopy = new ArrayList<ModelRenderer>(modelList);
            ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
            for (int i = modelListCopy.size() - 1; i >= 0; --i) {
                ModelRenderer cube = modelListCopy.get(i);
                if (cube.field_78812_q) continue;
                modelListCopy.remove(i);
            }
            for (ModelRenderer cube : modelListCopy) {
                list.add(ModelHelper.buildCopy(cube, base, 0, true, false));
            }
            return list;
        }
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        for (int i = 0; i < modelList.size(); ++i) {
            ModelRenderer cube = modelList.get(i);
            list.add(ModelHelper.buildCopy(cube, base, 0, true, false));
        }
        return list;
    }

    public static CubeInfo createCubeInfoFromModelBox(ModelRenderer rend, ModelBox box, String name) {
        TextureOffset textureoffset;
        CubeInfo info = new CubeInfo(name);
        info.dimensions[0] = (int)Math.abs(box.field_78248_d - box.field_78252_a);
        info.dimensions[1] = (int)Math.abs(box.field_78249_e - box.field_78250_b);
        info.dimensions[2] = (int)Math.abs(box.field_78246_f - box.field_78251_c);
        info.position[0] = rend.field_78800_c;
        info.position[1] = rend.field_78797_d;
        info.position[2] = rend.field_78798_e;
        info.offset[0] = box.field_78252_a;
        info.offset[1] = box.field_78250_b;
        info.offset[2] = box.field_78251_c;
        info.rotation[0] = Math.toDegrees(rend.field_78795_f);
        info.rotation[1] = Math.toDegrees(rend.field_78796_g);
        info.rotation[2] = Math.toDegrees(rend.field_78808_h);
        info.scale[2] = 1.0;
        info.scale[1] = 1.0;
        info.scale[0] = 1.0;
        PositionTextureVertex[] vertices = box.field_78254_i[1].field_78239_a;
        info.txMirror = (vertices[info.txMirror ? 1 : 2].field_78243_a.field_72448_b - vertices[info.txMirror ? 3 : 0].field_78243_a.field_72448_b - (double)info.dimensions[1]) / 2.0 < 0.0;
        info.txOffset[0] = (int)(vertices[info.txMirror ? 2 : 1].field_78241_b * rend.field_78801_a);
        info.txOffset[1] = (int)(vertices[info.txMirror ? 2 : 1].field_78242_c * rend.field_78799_b) - info.dimensions[2];
        float f = vertices[info.txMirror ? 2 : 1].field_78242_c;
        int n = info.txMirror ? 1 : 2;
        if (f > vertices[n].field_78242_c) {
            info.txMirror = !info.txMirror;
            info.txOffset[0] = (int)(vertices[info.txMirror ? 2 : 1].field_78241_b * rend.field_78801_a);
            info.txOffset[1] = (int)(vertices[info.txMirror ? 2 : 1].field_78242_c * rend.field_78799_b) - info.dimensions[2];
        }
        if (box.field_78247_g != null && (textureoffset = rend.field_78810_s.func_78084_a(box.field_78247_g)) != null) {
            info.txOffset[0] = textureoffset.field_78783_a;
            info.txOffset[1] = textureoffset.field_78782_b;
        }
        info.mcScale = (vertices[info.txMirror ? 1 : 2].field_78243_a.field_72448_b - vertices[info.txMirror ? 3 : 0].field_78243_a.field_72448_b - (double)info.dimensions[1]) / 2.0;
        return info;
    }

    public static ModelRenderer buildCopy(ModelRenderer original, ModelBase copyBase, int depth, boolean hasFullModelBox, boolean isEmpty) {
        int txOffsetX = original.field_78803_o;
        int txOffsetY = original.field_78813_p;
        ModelRenderer cubeCopy = new ModelRenderer(copyBase, txOffsetX, txOffsetY);
        cubeCopy.field_78799_b = original.field_78799_b;
        cubeCopy.field_78801_a = original.field_78801_a;
        for (int j = 0; j < original.field_78804_l.size(); ++j) {
            ModelBox box = (ModelBox)original.field_78804_l.get(j);
            CubeInfo info = ModelHelper.createCubeInfoFromModelBox(original, box, box.field_78247_g != null ? box.field_78247_g.substring(box.field_78247_g.lastIndexOf(".") + 1) : "");
            cubeCopy.field_78809_i = info.txMirror;
            cubeCopy.field_78803_o = info.txOffset[0];
            cubeCopy.field_78813_p = info.txOffset[1];
            if (isEmpty) {
                info.dimensions[2] = 0;
                info.dimensions[1] = 0;
                info.dimensions[0] = 0;
                info.offset[1] = info.offset[2] = (double)0;
                info.offset[0] = info.offset[2];
            }
            if (hasFullModelBox) {
                cubeCopy.func_78790_a((float)info.offset[0], (float)info.offset[1], (float)info.offset[2], info.dimensions[0], info.dimensions[1], info.dimensions[2], (float)info.mcScale);
                continue;
            }
            ModelBox randBox = (ModelBox)original.field_78804_l.get(rand.nextInt(original.field_78804_l.size()));
            float x = randBox.field_78252_a + (randBox.field_78248_d - randBox.field_78252_a > 0.0f ? (float)rand.nextInt((int)(randBox.field_78248_d - randBox.field_78252_a) > 0 ? (int)(randBox.field_78248_d - randBox.field_78252_a) : 1) : 0.0f);
            float y = randBox.field_78250_b + (randBox.field_78249_e - randBox.field_78250_b > 0.0f ? (float)rand.nextInt((int)(randBox.field_78249_e - randBox.field_78250_b) > 0 ? (int)(randBox.field_78249_e - randBox.field_78250_b) : 1) : 0.0f);
            float z = randBox.field_78251_c + (randBox.field_78246_f - randBox.field_78251_c > 0.0f ? (float)rand.nextInt((int)(randBox.field_78246_f - randBox.field_78251_c) > 0 ? (int)(randBox.field_78246_f - randBox.field_78251_c) : 1) : 0.0f);
            cubeCopy.func_78790_a(x, y, z, info.dimensions[0], info.dimensions[1], info.dimensions[2], (float)info.mcScale);
        }
        cubeCopy.field_78809_i = original.field_78809_i;
        if (original.field_78805_m != null && depth < 20) {
            for (int i = 0; i < original.field_78805_m.size(); ++i) {
                ModelRenderer child = (ModelRenderer)original.field_78805_m.get(i);
                cubeCopy.func_78792_a(ModelHelper.buildCopy(child, copyBase, depth + 1, hasFullModelBox, isEmpty));
            }
        }
        cubeCopy.func_78793_a(original.field_78800_c, original.field_78797_d, original.field_78798_e);
        cubeCopy.field_78795_f = original.field_78795_f;
        cubeCopy.field_78796_g = original.field_78796_g;
        cubeCopy.field_78808_h = original.field_78808_h;
        return cubeCopy;
    }

    public static ArrayList<ModelRenderer> getModelCubes(ModelBase parent) {
        return new ArrayList<ModelRenderer>(ModelHelper.getModelCubesWithNames(parent).values());
    }

    public static HashMap<String, ModelRenderer> getModelCubesWithNames(ModelBase parent) {
        HashMap<String, ModelRenderer> list = new HashMap<String, ModelRenderer>();
        HashMap<String, ModelRenderer[]> list1 = new HashMap<String, ModelRenderer[]>();
        if (parent != null) {
            for (Class clz = parent.getClass(); clz != ModelBase.class && ModelBase.class.isAssignableFrom(clz); clz = clz.getSuperclass()) {
                try {
                    Field[] fieldArray;
                    for (Field f : fieldArray = clz.getDeclaredFields()) {
                        ModelRenderer[] rend;
                        f.setAccessible(true);
                        if (f.getType() == ModelRenderer.class || ModelRenderer.class.isAssignableFrom(f.getType())) {
                            rend = (ModelRenderer[])f.get(parent);
                            if (rend == null) continue;
                            String name = f.getName();
                            if (rend.field_78802_n != null) {
                                name = rend.field_78802_n;
                                while (list.containsKey(name)) {
                                    name = name + "_";
                                }
                            }
                            list.put(name, (ModelRenderer)rend);
                            continue;
                        }
                        if (f.getType() != ModelRenderer[].class && !ModelRenderer[].class.isAssignableFrom(f.getType()) || (rend = (ModelRenderer[])f.get(parent)) == null) continue;
                        list1.put(f.getName(), rend);
                    }
                    continue;
                }
                catch (Exception exception) {
                    throw new ReflectionHelper.UnableToAccessFieldException(new String[0], exception);
                }
            }
        }
        for (Map.Entry entry : list1.entrySet()) {
            int count = 1;
            for (ModelRenderer cube : (ModelRenderer[])entry.getValue()) {
                if (cube == null || list.containsValue(cube)) continue;
                list.put((String)entry.getKey() + count, cube);
                ++count;
            }
        }
        ArrayList<ModelRenderer> children = new ArrayList<ModelRenderer>();
        for (Map.Entry e : list.entrySet()) {
            ModelRenderer cube = (ModelRenderer)e.getValue();
            for (ModelRenderer child : ModelHelper.getChildren(cube, true, 0)) {
                if (children.contains(child)) continue;
                children.add(child);
            }
        }
        for (ModelRenderer child : children) {
            Iterator<Map.Entry<String, ModelRenderer>> ite = list.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, ModelRenderer> e = ite.next();
                if (e.getValue() != child) continue;
                ite.remove();
            }
        }
        return list;
    }

    public static ArrayList<ModelRenderer> getMultiModelCubes(ArrayList<ModelBase> parent) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        for (ModelBase base : parent) {
            list.addAll(ModelHelper.getModelCubes(base));
        }
        return list;
    }

    public static ArrayList<ModelRenderer> getChildren(ModelRenderer parent, boolean recursive, int depth) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        if (parent.field_78805_m != null && depth < 20) {
            for (int i = 0; i < parent.field_78805_m.size(); ++i) {
                ModelRenderer child = (ModelRenderer)parent.field_78805_m.get(i);
                if (recursive) {
                    ArrayList<ModelRenderer> children = ModelHelper.getChildren(child, recursive, depth + 1);
                    for (ModelRenderer child1 : children) {
                        if (list.contains(child1)) continue;
                        list.add(child1);
                    }
                }
                if (list.contains(child)) continue;
                list.add(child);
            }
        }
        return list;
    }

    public static ModelBase getPossibleModel(Render rend) {
        ArrayList models = new ArrayList();
        if (rend != null) {
            try {
                for (Class<?> clz = rend.getClass(); clz != Render.class; clz = clz.getSuperclass()) {
                    Field[] fields;
                    ArrayList<ModelBase> priorityLevel = new ArrayList<ModelBase>();
                    for (Field f : fields = clz.getDeclaredFields()) {
                        ModelBase[] modelBases;
                        f.setAccessible(true);
                        if (ModelBase.class.isAssignableFrom(f.getType())) {
                            ModelBase base = (ModelBase)f.get(rend);
                            if (base == null) continue;
                            priorityLevel.add(base);
                            continue;
                        }
                        if (!ModelBase[].class.isAssignableFrom(f.getType()) || (modelBases = (ModelBase[])f.get(rend)) == null) continue;
                        priorityLevel.addAll(Arrays.asList(modelBases));
                    }
                    models.add(priorityLevel);
                    if (clz != RenderLivingBase.class) continue;
                    ArrayList<ModelBase> topPriority = new ArrayList<ModelBase>();
                    for (Field f : fields) {
                        ModelBase base;
                        f.setAccessible(true);
                        if (!ModelBase.class.isAssignableFrom(f.getType()) || !f.getName().equalsIgnoreCase(ObfHelper.mainModel[0]) && !f.getName().equalsIgnoreCase(ObfHelper.mainModel[1]) || (base = (ModelBase)f.get(rend)) == null) continue;
                        topPriority.add(base);
                    }
                    models.add(topPriority);
                }
            }
            catch (Exception e) {
                throw new ReflectionHelper.UnableToAccessFieldException(new String[0], e);
            }
        }
        ModelBase base1 = null;
        int priorityLevel = -1;
        int size = -1;
        int currentPriority = 0;
        for (ArrayList arrayList : models) {
            for (ModelBase base : arrayList) {
                ArrayList<ModelRenderer> mrs = ModelHelper.getModelCubes(base);
                if (mrs.size() <= size && (mrs.size() != size || currentPriority <= priorityLevel)) continue;
                size = mrs.size();
                base1 = base;
                priorityLevel = currentPriority;
            }
            ++currentPriority;
        }
        return base1;
    }

    public static boolean areModelsEqual(ModelBase model1, ModelBase model2) {
        if (model1.getClass() == model2.getClass() && model1.field_78089_u == model2.field_78089_u && model1.field_78090_t == model2.field_78090_t) {
            ArrayList<ModelRenderer> parts1 = ModelHelper.getModelCubes(model1);
            ArrayList<ModelRenderer> parts2 = ModelHelper.getModelCubes(model2);
            if (parts1.size() == parts2.size()) {
                for (int i = parts1.size() - 1; i >= 0; --i) {
                    ModelRenderer rend1 = parts1.get(i);
                    boolean remove = true;
                    for (int k = rend1.field_78804_l.size() - 1; k >= 0; --k) {
                        ModelBox box1 = (ModelBox)rend1.field_78804_l.get(k);
                        CubeInfo cube1 = ModelHelper.createCubeInfoFromModelBox(rend1, box1, box1.field_78247_g != null ? box1.field_78247_g : "");
                        boolean found = false;
                        for (int j = parts2.size() - 1; j >= 0; --j) {
                            ModelRenderer rend2 = parts2.get(j);
                            if (rend1.field_78804_l.size() == rend2.field_78804_l.size() && (rend1.field_78805_m == null && rend2.field_78805_m == null || rend1.field_78805_m != null && rend2.field_78805_m != null && rend1.field_78805_m.size() == rend2.field_78805_m.size())) {
                                for (int l = rend2.field_78804_l.size(); l >= 0; --l) {
                                    ModelBox box2 = (ModelBox)rend2.field_78804_l.get(l);
                                    CubeInfo cube2 = ModelHelper.createCubeInfoFromModelBox(rend2, box2, box2.field_78247_g != null ? box2.field_78247_g : "");
                                    for (int m = 0; m < 3 && cube1.dimensions[m] == cube2.dimensions[m] && cube1.offset[m] == cube2.offset[m]; ++m) {
                                        if (m != 2) continue;
                                        found = true;
                                    }
                                    if (found) break;
                                }
                            }
                            if (found) break;
                        }
                        if (found) continue;
                        remove = false;
                    }
                    if (!remove) continue;
                    parts1.remove(i);
                }
                return parts1.isEmpty();
            }
        }
        return false;
    }

    public static int getModelHeight(ModelRenderer model) {
        int height = 0;
        for (int i = 0; i < model.field_78804_l.size(); ++i) {
            ModelBox box = (ModelBox)model.field_78804_l.get(i);
            if ((int)Math.abs(box.field_78249_e - box.field_78250_b) <= height) continue;
            height = (int)Math.abs(box.field_78249_e - box.field_78250_b);
        }
        return height;
    }

    public static ArrayList<ModelRenderer> getModelCubes(Entity entity) {
        return ModelHelper.getModelCubes(Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity));
    }

    public static ArrayList<ModelRenderer> getModelCubes(Render rend) {
        ArrayList<ModelRenderer> map = classToModelRendererMap.get(rend.getClass());
        if (map == null) {
            map = ModelHelper.getModelCubes(ModelHelper.getPossibleModel(rend));
            classToModelRendererMap.put(rend.getClass(), map);
        }
        return map;
    }

    public static ModelRenderer[] getPotentialArms(ModelBase parent) {
        ModelRenderer[] arms = new ModelRenderer[2];
        if (parent != null) {
            Class<?> clz = parent.getClass();
            if (clz == ModelHorse.class) {
                ModelHorse dummy = new ModelHorse();
                ModelRenderer leg = new ModelRenderer((ModelBase)dummy, 60, 29);
                leg.func_78789_a(-1.1f, -1.0f, -2.1f, 3, 8, 4);
                leg.func_78793_a(-4.0f, 9.0f, -8.0f);
                ModelRenderer shin = new ModelRenderer((ModelBase)dummy, 60, 41);
                shin.func_78789_a(-1.1f, 0.0f, -1.6f, 3, 5, 3);
                shin.func_78793_a(0.0f, 7.0f, 0.0f);
                leg.func_78792_a(shin);
                ModelRenderer hoof = new ModelRenderer((ModelBase)dummy, 60, 51);
                hoof.func_78789_a(-1.6f, 5.1f, -2.1f, 4, 3, 4);
                hoof.func_78793_a(0.0f, 0.0f, 0.0f);
                shin.func_78792_a(hoof);
                ModelRenderer[] legs = new ModelRenderer[]{leg, leg};
                armMappings.put(ModelHorse.class, legs);
                return legs;
            }
            if (clz == ModelPlayer.class) {
                arms[0] = ((ModelPlayer)parent).field_178723_h;
                arms[1] = ((ModelPlayer)parent).field_178724_i;
                armMappings.put(ModelPlayer.class, arms);
                return arms;
            }
            while (clz != ModelBase.class && ModelBase.class.isAssignableFrom(clz)) {
                try {
                    Field[] fields;
                    for (Field f : fields = clz.getDeclaredFields()) {
                        ModelRenderer arm;
                        f.setAccessible(true);
                        if (f.getType() == ModelRenderer.class) {
                            if ((clz == ModelBiped.class && (f.getName().equalsIgnoreCase("field_178723_h") || f.getName().equalsIgnoreCase("bipedRightArm") || f.getName().equalsIgnoreCase("h")) || clz == ModelQuadruped.class && (f.getName().equalsIgnoreCase("field_78147_e") || f.getName().equalsIgnoreCase("leg3") || f.getName().equalsIgnoreCase("e")) || clz == ModelCreeper.class && (f.getName().equalsIgnoreCase("field_78129_f") || f.getName().equalsIgnoreCase("leg3") || f.getName().equalsIgnoreCase("f")) || clz == ModelIronGolem.class && (f.getName().equalsIgnoreCase("field_78177_c") || f.getName().equalsIgnoreCase("ironGolemRightArm") || f.getName().equalsIgnoreCase("c")) || clz == ModelSpider.class && (f.getName().equalsIgnoreCase("field_78210_j") || f.getName().equalsIgnoreCase("spiderLeg7") || f.getName().equalsIgnoreCase("j")) || clz == ModelWolf.class && (f.getName().equalsIgnoreCase("field_78182_e") || f.getName().equalsIgnoreCase("wolfLeg3") || f.getName().equalsIgnoreCase("e")) || clz == ModelOcelot.class && (f.getName().equalsIgnoreCase("field_78157_d") || f.getName().equalsIgnoreCase("ocelotFrontRightLeg") || f.getName().equalsIgnoreCase("d")) || clz == ModelRabbit.class && (f.getName().equalsIgnoreCase("field_178693_g") || f.getName().equalsIgnoreCase("rabbitRightArm") || f.getName().equalsIgnoreCase("g")) || clz != ModelBiped.class && clz != ModelQuadruped.class && clz != ModelCreeper.class && clz != ModelIronGolem.class && clz != ModelSpider.class && clz != ModelWolf.class && clz != ModelOcelot.class && clz != ModelRabbit.class && f.getName().toLowerCase().contains("right") && (f.getName().toLowerCase().contains("arm") || f.getName().toLowerCase().contains("hand"))) && (arm = (ModelRenderer)f.get(parent)) != null && arms[0] == null) {
                                arms[0] = arm;
                                armMappings.put(parent.getClass(), arms);
                            }
                            if ((clz != ModelBiped.class || !f.getName().equalsIgnoreCase("field_178724_i") && !f.getName().equalsIgnoreCase("bipedLeftArm") && !f.getName().equalsIgnoreCase("i")) && (clz != ModelQuadruped.class || !f.getName().equalsIgnoreCase("field_78144_f") && !f.getName().equalsIgnoreCase("leg4") && !f.getName().equalsIgnoreCase("f")) && (clz != ModelCreeper.class || !f.getName().equalsIgnoreCase("field_78130_g") && !f.getName().equalsIgnoreCase("leg4") && !f.getName().equalsIgnoreCase("g")) && (clz != ModelIronGolem.class || !f.getName().equalsIgnoreCase("field_78174_d") && !f.getName().equalsIgnoreCase("ironGolemLeftArm") && !f.getName().equalsIgnoreCase("d")) && (clz != ModelSpider.class || !f.getName().equalsIgnoreCase("field_78211_k") && !f.getName().equalsIgnoreCase("spiderLeg8") && !f.getName().equalsIgnoreCase("k")) && (clz != ModelWolf.class || !f.getName().equalsIgnoreCase("field_78179_f") && !f.getName().equalsIgnoreCase("wolfLeg4") && !f.getName().equalsIgnoreCase("f")) && (clz != ModelOcelot.class || !f.getName().equalsIgnoreCase("field_78160_c") && !f.getName().equalsIgnoreCase("ocelotFrontLeftLeg") && !f.getName().equalsIgnoreCase("c")) && (clz != ModelRabbit.class || !f.getName().equalsIgnoreCase("field_178692_f") && !f.getName().equalsIgnoreCase("rabbitLeftArm") && !f.getName().equalsIgnoreCase("f")) && (clz == ModelBiped.class || clz == ModelQuadruped.class || clz == ModelCreeper.class || clz == ModelIronGolem.class || clz == ModelSpider.class || clz == ModelWolf.class || clz == ModelOcelot.class || clz == ModelRabbit.class || !f.getName().toLowerCase().contains("left") || !f.getName().toLowerCase().contains("arm") && !f.getName().toLowerCase().contains("hand")) || (arm = (ModelRenderer)f.get(parent)) == null || arms[1] != null) continue;
                            arms[1] = arm;
                            armMappings.put(parent.getClass(), arms);
                            continue;
                        }
                        if (f.getType() != ModelRenderer[].class || clz != ModelSquid.class || !f.getName().equalsIgnoreCase("squidTentacles") && !f.getName().equalsIgnoreCase("b") && !f.getName().equalsIgnoreCase("field_78201_b")) continue;
                        arms[0] = arms[1] = (arm = ((ModelRenderer[])f.get(parent))[0]);
                        armMappings.put(ModelSquid.class, arms);
                        return arms;
                    }
                    clz = clz.getSuperclass();
                }
                catch (Exception e) {
                    throw new ReflectionHelper.UnableToAccessFieldException(new String[0], e);
                }
            }
            return arms;
        }
        return arms;
    }
}

