/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import me.ichun.mods.ichunutil.client.core.event.EventHandlerClient;
import me.ichun.mods.ichunutil.common.core.Logger;
import me.ichun.mods.ichunutil.common.core.ProxyCommon;
import me.ichun.mods.ichunutil.common.core.config.ConfigBase;
import me.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import me.ichun.mods.ichunutil.common.core.config.annotations.ConfigProp;
import me.ichun.mods.ichunutil.common.core.config.annotations.IntBool;
import me.ichun.mods.ichunutil.common.core.config.annotations.IntMinMax;
import me.ichun.mods.ichunutil.common.core.event.EventHandlerServer;
import me.ichun.mods.ichunutil.common.core.network.PacketChannel;
import me.ichun.mods.ichunutil.common.core.util.ObfHelper;
import me.ichun.mods.ichunutil.common.module.update.UpdateChecker;
import me.ichun.mods.ichunutil.common.module.worldportals.common.WorldPortals;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="ichunutil", name="iChunUtil", version="7.1.3", guiFactory="me.ichun.mods.ichunutil.common.core.config.GenericModGuiFactory", dependencies="required-after:forge@[12.23.2.2151,99999.24.0.0)", acceptableRemoteVersions="[7.1.0,7.2.0)", acceptedMinecraftVersions="[1.12,1.13)")
public class iChunUtil {
    public static final String VERSION_OF_MC = "1.12.2";
    public static final String MC_VERSION_RANGE = "[1.12,1.13)";
    public static final int VERSION_MAJOR = 7;
    public static final int VERSION_MINOR = 1;
    public static final String VERSION = "7.1.3";
    public static final String MOD_NAME = "iChunUtil";
    public static final String MOD_ID = "ichunutil";
    public static final int REQ_FORGE_MAJOR = 12;
    public static final int REQ_FORGE_MINOR = 23;
    public static final int REQ_FORGE_REVISION = 2;
    public static final int REQ_FORGE_BUILD = 2151;
    public static final Logger LOGGER = Logger.createLogger("iChunUtil");
    public static final String GUI_CONFIG_FACTORY = "me.ichun.mods.ichunutil.common.core.config.GenericModGuiFactory";
    @Mod.Instance(value="ichunutil")
    public static iChunUtil instance;
    @SidedProxy(clientSide="me.ichun.mods.ichunutil.client.core.ProxyClient", serverSide="me.ichun.mods.ichunutil.common.core.ProxyCommon")
    public static ProxyCommon proxy;
    public static Config config;
    public static PacketChannel channel;
    public static EventHandlerServer eventHandlerServer;
    public static EventHandlerClient eventHandlerClient;
    public static Block blockCompactPorkchop;
    public static List<ItemStack> oreDictBlockCompactRawPorkchop;
    private static boolean hasPostInit;
    private static boolean hasMorphMod;
    public static boolean userIsPatron;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        ObfHelper.detectObfuscation();
        config = ConfigHandler.registerConfig(new Config(event.getSuggestedConfigurationFile()));
        proxy.preInit();
        UpdateChecker.registerMod(new UpdateChecker.ModVersionInfo(MOD_NAME, VERSION_OF_MC, VERSION, false));
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        hasPostInit = true;
        hasMorphMod = Loader.isModLoaded((String)"morph");
        proxy.postInit();
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        UpdateChecker.serverStarted();
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        eventHandlerServer.shuttingDownServer();
        WorldPortals.onServerStopping();
    }

    public static boolean hasPostInit() {
        return hasPostInit;
    }

    public static boolean hasMorphMod() {
        return hasMorphMod;
    }

    public class Config
    extends ConfigBase {
        @ConfigProp(category="clientOnly", side=Side.CLIENT, changeable=false)
        @IntBool
        public int enableStencils;
        @ConfigProp(module="compactPorkchop", category="block", useSession=true)
        @IntBool
        public int enableCompactPorkchop;
        @ConfigProp(module="eula")
        public String eulaAcknowledged;
        @ConfigProp(module="patreon", side=Side.CLIENT, hidden=true)
        @IntBool
        public int showPatronReward;
        @ConfigProp(module="patreon", side=Side.CLIENT, hidden=true)
        @IntMinMax(min=1, max=6)
        public int patronRewardType;
        @ConfigProp(module="versionCheck")
        @IntMinMax(min=0, max=2)
        public int versionNotificationTypes;
        @ConfigProp(module="versionCheck", side=Side.CLIENT)
        @IntMinMax(min=0, max=2)
        public int versionNotificationFrequency;
        @ConfigProp(module="versionCheck", side=Side.CLIENT)
        @IntMinMax(min=0, max=35)
        public int versionSave;
        @ConfigProp(module="headTracking", side=Side.CLIENT, hidden=true)
        @IntBool
        public int aggressiveHeadTracking;
        @ConfigProp(module="worldPortals", side=Side.CLIENT, hidden=true)
        @IntMinMax(min=0, max=10)
        public int maxRecursion;
        @ConfigProp(module="worldPortals", side=Side.CLIENT, hidden=true)
        @IntMinMax(min=1, max=255)
        public int stencilValue;
        @ConfigProp(module="worldPortals", side=Side.CLIENT, hidden=true)
        @IntMinMax(min=0, max=16)
        public int renderDistanceChunks;
        @ConfigProp(module="worldPortals", side=Side.CLIENT, hidden=true)
        @IntMinMax(min=1, max=100)
        public int maxRendersPerTick;

        public Config(File file) {
            super(file);
            this.enableStencils = 1;
            this.enableCompactPorkchop = 1;
            this.eulaAcknowledged = "";
            this.showPatronReward = 1;
            this.patronRewardType = 1;
            this.versionNotificationTypes = 0;
            this.versionNotificationFrequency = 2;
            this.versionSave = 0;
            this.aggressiveHeadTracking = 0;
            this.maxRecursion = 2;
            this.stencilValue = 47;
            this.renderDistanceChunks = 0;
            this.maxRendersPerTick = 10;
        }

        @Override
        public String getModId() {
            return iChunUtil.MOD_ID;
        }

        @Override
        public String getModName() {
            return iChunUtil.MOD_NAME;
        }

        @Override
        public void onConfigChange(Field field, Object original) {
            if (field.getName().equals("showPatronReward") || field.getName().equals("patronRewardType")) {
                iChunUtil.eventHandlerClient.patronUpdateServerAsPatron = true;
            }
        }
    }
}

