/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BiblioSimpleBlock;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityDiscRack;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;

public class BlockDiscRack
extends BiblioSimpleBlock {
    public static final BlockDiscRack instance = new BlockDiscRack();
    public static final String name = "DiscRack";

    public BlockDiscRack() {
        super(Material.field_151575_d, SoundType.field_185848_a, name);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile != null && tile instanceof TileEntityDiscRack) {
            ItemStack playerStack = player.func_184586_b(EnumHand.MAIN_HAND);
            TileEntityDiscRack rackTile = (TileEntityDiscRack)tile;
            if (rackTile != null) {
                EnumFacing angle = rackTile.getAngle();
                EnumVertPosition vertAngle = rackTile.getVertPosition();
                boolean isRotated = rackTile.getWallRotation();
                int discSlot = BlockDiscRack.getDiscSlot(hitX, hitY, hitZ, angle, vertAngle, isRotated);
                if (playerStack != ItemStack.field_190927_a) {
                    String discName = playerStack.func_77977_a().toLowerCase();
                    if ((playerStack.func_77973_b() instanceof ItemRecord || Config.testDiscValidity(discName)) && rackTile.addStackToInventoryFromWorld(playerStack, discSlot, player)) {
                        return true;
                    }
                } else if (player.func_70093_af() && rackTile.removeStackFromInventoryFromWorld(discSlot, player, this)) {
                    return true;
                }
            }
            player.openGui((Object)BiblioCraft.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDiscRack();
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f)));
        switch (tile.getVertPosition()) {
            case FLOOR: {
                break;
            }
            case WALL: {
                boolean isRotated = false;
                if (tile instanceof TileEntityDiscRack) {
                    TileEntityDiscRack discrack = (TileEntityDiscRack)tile;
                    isRotated = discrack.getWallRotation();
                }
                if (isRotated) {
                    transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(1.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 1.0f, 1.0f)));
                    break;
                }
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 1.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 1.0f, 1.0f)));
                break;
            }
            case CEILING: {
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 1.0f, -1.0f), new Quat4f(1.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(1.0f, 0.0f, 0.0f, 1.0f)));
            }
        }
        return transform;
    }

    public static int getDiscSlot(float hitX, float hitY, float hitZ, EnumFacing angle, EnumVertPosition vertAngle, boolean wallRotated) {
        int discSlot = 0;
        block0 : switch (vertAngle) {
            case FLOOR: {
                switch (angle) {
                    case SOUTH: {
                        discSlot = BlockDiscRack.getDiscSlotPos(hitX);
                        break block0;
                    }
                    case WEST: {
                        discSlot = BlockDiscRack.getDiscSlotNeg(hitZ);
                        break block0;
                    }
                    case NORTH: {
                        discSlot = BlockDiscRack.getDiscSlotNeg(hitX);
                        break block0;
                    }
                    case EAST: {
                        discSlot = BlockDiscRack.getDiscSlotPos(hitZ);
                        break block0;
                    }
                }
                break;
            }
            case WALL: {
                if (!wallRotated) {
                    discSlot = BlockDiscRack.getDiscSlotPos(hitY);
                    break;
                }
                switch (angle) {
                    case SOUTH: {
                        discSlot = BlockDiscRack.getDiscSlotPos(hitZ);
                        break block0;
                    }
                    case WEST: {
                        discSlot = BlockDiscRack.getDiscSlotNeg(hitX);
                        break block0;
                    }
                    case NORTH: {
                        discSlot = BlockDiscRack.getDiscSlotNeg(hitZ);
                        break block0;
                    }
                    case EAST: {
                        discSlot = BlockDiscRack.getDiscSlotPos(hitX);
                        break block0;
                    }
                }
                break;
            }
            case CEILING: {
                switch (angle) {
                    case SOUTH: {
                        discSlot = BlockDiscRack.getDiscSlotNeg(hitX);
                        break block0;
                    }
                    case WEST: {
                        discSlot = BlockDiscRack.getDiscSlotPos(hitZ);
                        break block0;
                    }
                    case NORTH: {
                        discSlot = BlockDiscRack.getDiscSlotPos(hitX);
                        break block0;
                    }
                    case EAST: {
                        discSlot = BlockDiscRack.getDiscSlotNeg(hitZ);
                        break block0;
                    }
                }
            }
        }
        return discSlot;
    }

    public static int getDiscSlotPos(float hit) {
        if (hit >= 0.87f) {
            return 8;
        }
        if (hit < 0.87f && hit >= 0.766f) {
            return 7;
        }
        if (hit < 0.766f && hit >= 0.662f) {
            return 6;
        }
        if (hit < 0.662f && hit >= 0.558f) {
            return 5;
        }
        if (hit < 0.558f && hit >= 0.454f) {
            return 4;
        }
        if (hit < 0.454f && hit >= 0.35f) {
            return 3;
        }
        if (hit < 0.35f && hit >= 0.246f) {
            return 2;
        }
        if (hit < 0.246f && hit >= 0.142f) {
            return 1;
        }
        if (hit < 0.142f) {
            return 0;
        }
        return 0;
    }

    public static int getDiscSlotNeg(float hit) {
        if (hit >= 0.87f) {
            return 0;
        }
        if (hit < 0.87f && hit >= 0.766f) {
            return 1;
        }
        if (hit < 0.766f && hit >= 0.662f) {
            return 2;
        }
        if (hit < 0.662f && hit >= 0.558f) {
            return 3;
        }
        if (hit < 0.558f && hit >= 0.454f) {
            return 4;
        }
        if (hit < 0.454f && hit >= 0.35f) {
            return 5;
        }
        if (hit < 0.35f && hit >= 0.246f) {
            return 6;
        }
        if (hit < 0.246f && hit >= 0.142f) {
            return 7;
        }
        if (hit < 0.142f) {
            return 8;
        }
        return 0;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
        int pitch = MathHelper.func_76128_c((double)((double)(player.field_70125_A * 3.0f / 180.0f) + 0.5)) & 3;
        ++pitch;
        if ((pitch %= 4) == 0) {
            biblioTile.setVertPosition(EnumVertPosition.CEILING);
        } else if (pitch == 1) {
            biblioTile.setVertPosition(EnumVertPosition.WALL);
        } else {
            biblioTile.setVertPosition(EnumVertPosition.FLOOR);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        AxisAlignedBB output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityDiscRack) {
            TileEntityDiscRack rackTile = (TileEntityDiscRack)tile;
            EnumFacing rackAngle = rackTile.getAngle();
            EnumVertPosition vertRackAngle = rackTile.getVertPosition();
            boolean rotated = rackTile.getWallRotation();
            switch (rackAngle) {
                case SOUTH: {
                    switch (vertRackAngle) {
                        case FLOOR: {
                            output = this.getBlockBounds(0.0f, 0.0f, 0.25f, 1.0f, 0.35f, 0.75f);
                            break;
                        }
                        case WALL: {
                            if (!rotated) {
                                output = this.getBlockBounds(0.65f, 0.0f, 0.25f, 1.0f, 1.0f, 0.75f);
                                break;
                            }
                            output = this.getBlockBounds(0.65f, 0.25f, 0.0f, 1.0f, 0.75f, 1.0f);
                            break;
                        }
                        case CEILING: {
                            output = this.getBlockBounds(0.0f, 0.65f, 0.25f, 1.0f, 1.0f, 0.75f);
                        }
                    }
                    break;
                }
                case WEST: {
                    switch (vertRackAngle) {
                        case FLOOR: {
                            output = this.getBlockBounds(0.25f, 0.0f, 0.0f, 0.75f, 0.35f, 1.0f);
                            break;
                        }
                        case WALL: {
                            if (!rotated) {
                                output = this.getBlockBounds(0.25f, 0.0f, 0.65f, 0.75f, 1.0f, 1.0f);
                                break;
                            }
                            output = this.getBlockBounds(0.0f, 0.25f, 0.65f, 1.0f, 0.75f, 1.0f);
                            break;
                        }
                        case CEILING: {
                            output = this.getBlockBounds(0.25f, 0.65f, 0.0f, 0.75f, 1.0f, 1.0f);
                        }
                    }
                    break;
                }
                case NORTH: {
                    switch (vertRackAngle) {
                        case FLOOR: {
                            output = this.getBlockBounds(0.0f, 0.0f, 0.25f, 1.0f, 0.35f, 0.75f);
                            break;
                        }
                        case WALL: {
                            if (!rotated) {
                                output = this.getBlockBounds(0.0f, 0.0f, 0.25f, 0.35f, 1.0f, 0.75f);
                                break;
                            }
                            output = this.getBlockBounds(0.0f, 0.25f, 0.0f, 0.35f, 0.75f, 1.0f);
                            break;
                        }
                        case CEILING: {
                            output = this.getBlockBounds(0.0f, 0.65f, 0.25f, 1.0f, 1.0f, 0.75f);
                        }
                    }
                    break;
                }
                case EAST: {
                    switch (vertRackAngle) {
                        case FLOOR: {
                            output = this.getBlockBounds(0.25f, 0.0f, 0.0f, 0.75f, 0.35f, 1.0f);
                            break;
                        }
                        case WALL: {
                            if (!rotated) {
                                output = this.getBlockBounds(0.25f, 0.0f, 0.0f, 0.75f, 1.0f, 0.35f);
                                break;
                            }
                            output = this.getBlockBounds(0.0f, 0.25f, 0.0f, 1.0f, 0.75f, 0.35f);
                            break;
                        }
                        case CEILING: {
                            output = this.getBlockBounds(0.25f, 0.65f, 0.0f, 0.75f, 1.0f, 1.0f);
                        }
                    }
                    break;
                }
            }
        }
        return output;
    }
}

