/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import jds.bibliocraft.blocks.BiblioBlock;
import jds.bibliocraft.helpers.EnumShiftPosition;
import jds.bibliocraft.helpers.EnumVertPosition;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public abstract class BiblioTileEntity
extends TileEntity
implements IInventory,
IItemHandler {
    private EnumFacing angle = EnumFacing.NORTH;
    private EnumShiftPosition shift = EnumShiftPosition.NO_SHIFT;
    private EnumVertPosition vertPosition = EnumVertPosition.WALL;
    public NonNullList<ItemStack> inventory;
    private String customTexture = "none";
    private boolean isRetexturable;
    private boolean isLocked = false;
    private String lockee = "";
    private int renderBoxAdditionalSize = 1;

    public BiblioTileEntity(int inventorySize, boolean canRetexture) {
        this.inventory = NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
        this.isRetexturable = canRetexture;
    }

    public boolean addStackToInventoryFromWorld(ItemStack stack, int slot, EntityPlayer player) {
        if (slot == -1) {
            return false;
        }
        boolean returnValue = false;
        ItemStack currentStack = this.func_70301_a(slot);
        if (stack != ItemStack.field_190927_a && currentStack == ItemStack.field_190927_a) {
            this.func_70299_a(slot, stack);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            returnValue = true;
        } else if (stack != ItemStack.field_190927_a && currentStack != ItemStack.field_190927_a) {
            ItemStack leftStack = stack.func_77946_l();
            ItemStack rightStack = currentStack.func_77946_l();
            leftStack.func_190920_e(1);
            rightStack.func_190920_e(1);
            if (this.getIsItemStacksEqual(leftStack, rightStack)) {
                int total = stack.func_190916_E() + currentStack.func_190916_E();
                if (total > stack.func_77976_d() && currentStack.func_190916_E() != currentStack.func_77976_d()) {
                    currentStack.func_190920_e(stack.func_77976_d());
                    stack.func_190920_e(total - stack.func_77976_d());
                    this.func_70299_a(slot, currentStack);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                    returnValue = true;
                } else if (total <= stack.func_77976_d()) {
                    currentStack.func_190920_e(total);
                    this.func_70299_a(slot, currentStack);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    returnValue = true;
                }
            }
            if (returnValue) {
                this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            }
        }
        return returnValue;
    }

    public boolean getIsItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        boolean output = false;
        if (stack1 != ItemStack.field_190927_a && stack2 != ItemStack.field_190927_a && stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i()) {
            NBTTagCompound tag1 = stack1.func_77978_p();
            NBTTagCompound tag2 = stack2.func_77978_p();
            output = tag1 == null && tag2 == null ? true : tag1.equals((Object)tag2);
        }
        return output;
    }

    public boolean addStackToInventoryFromWorldSingleStackSize(ItemStack stack, int slot, EntityPlayer player) {
        boolean returnValue = false;
        ItemStack currentStack = this.func_70301_a(slot);
        if (stack != ItemStack.field_190927_a && currentStack == ItemStack.field_190927_a) {
            if (stack.func_190916_E() > 1) {
                ItemStack newStack = stack.func_77946_l();
                newStack.func_190920_e(1);
                stack.func_190920_e(stack.func_190916_E() - 1);
                this.func_70299_a(slot, newStack);
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
            } else {
                this.func_70299_a(slot, stack);
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            returnValue = true;
        }
        if (returnValue) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        }
        return returnValue;
    }

    public boolean removeStackFromInventoryFromWorld(int slot, EntityPlayer player, BiblioBlock block) {
        boolean returnValue = false;
        ItemStack stack = this.func_70301_a(slot);
        if (stack != ItemStack.field_190927_a) {
            BlockPos newPos = this.func_174877_v();
            if (player != null) {
                newPos = block.getDropPositionOffset(this.func_174877_v(), player);
            }
            block.dropStackInSlot(this.field_145850_b, this.func_174877_v(), slot, newPos);
            this.func_70299_a(slot, ItemStack.field_190927_a);
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            returnValue = true;
        }
        return returnValue;
    }

    public abstract void setInventorySlotContentsAdditionalCommands(int var1, ItemStack var2);

    public abstract void loadCustomNBTData(NBTTagCompound var1);

    public abstract NBTTagCompound writeCustomNBTData(NBTTagCompound var1);

    public void setAngle(EnumFacing facing) {
        this.angle = facing;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public void setShiftPosition(EnumShiftPosition position) {
        this.shift = position;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public void setVertPosition(EnumVertPosition position) {
        this.vertPosition = position;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public EnumFacing getAngle() {
        return this.angle;
    }

    public EnumShiftPosition getShiftPosition() {
        return this.shift;
    }

    public EnumVertPosition getVertPosition() {
        return this.vertPosition;
    }

    public boolean canRetextureBlock() {
        return this.isRetexturable;
    }

    public String getCustomTextureString() {
        return this.customTexture;
    }

    public void setCustomTexureString(String tex) {
        this.customTexture = tex;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public String getLockee() {
        return this.lockee;
    }

    public void setLockee(String lockeeperson) {
        this.lockee = lockeeperson;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int slot) {
        ItemStack output = ItemStack.field_190927_a;
        if (slot >= 0 && slot < this.inventory.size()) {
            output = (ItemStack)this.inventory.get(slot);
        }
        return output;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.inventory.size()) {
            this.inventory.set(slot, (Object)stack);
            if (stack != ItemStack.field_190927_a && stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            this.setInventorySlotContentsAdditionalCommands(slot, stack);
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        }
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        Item stackSizeTest = stack.func_77973_b();
        if (stack != ItemStack.field_190927_a) {
            if (stack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((stack = stack.func_77979_a(amount)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != ItemStack.field_190927_a) {
            this.func_70299_a(slot, ItemStack.field_190927_a);
        }
        return stack;
    }

    public abstract int func_70297_j_();

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        bb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + this.renderBoxAdditionalSize), (double)(this.field_174879_c.func_177956_o() + this.renderBoxAdditionalSize), (double)(this.field_174879_c.func_177952_p() + this.renderBoxAdditionalSize));
        return bb;
    }

    public void setRenderBoxAdditionalSize(int size) {
        this.renderBoxAdditionalSize = size;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.loadNBTData(nbt);
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        NBTTagCompound nbtData = packet.func_148857_g();
        this.loadNBTData(nbtData);
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    private void loadNBTData(NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c("Inventory", 10);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.size()) continue;
            this.inventory.set((int)slot, (Object)new ItemStack(tag));
        }
        this.isLocked = nbt.func_74767_n("locked");
        this.lockee = nbt.func_74779_i("lockee");
        this.angle = this.getFacingFromAngleID(nbt.func_74762_e("angle"));
        this.shift = EnumShiftPosition.getEnumFromID(nbt.func_74762_e("shift"));
        this.vertPosition = EnumVertPosition.getEnumFromID(nbt.func_74762_e("position"));
        this.loadCustomNBTData(nbt);
        if (this.isRetexturable) {
            this.customTexture = nbt.func_74779_i("customTexture");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt = this.writeNBTData(nbt);
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound dataTag = new NBTTagCompound();
        dataTag = this.writeNBTData(dataTag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, dataTag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tags = super.func_189517_E_();
        return this.writeNBTData(tags);
    }

    private NBTTagCompound writeNBTData(NBTTagCompound nbt) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack == ItemStack.field_190927_a) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Inventory", (NBTBase)itemList);
        nbt.func_74757_a("locked", this.isLocked);
        nbt.func_74778_a("lockee", this.lockee);
        nbt.func_74768_a("angle", this.getAngleIDFromFacing(this.angle));
        nbt.func_74768_a("shift", this.shift.getID());
        nbt.func_74768_a("position", this.vertPosition.getID());
        nbt = this.writeCustomNBTData(nbt);
        if (this.isRetexturable) {
            nbt.func_74778_a("customTexture", this.customTexture);
        }
        return nbt;
    }

    private int getAngleIDFromFacing(EnumFacing facing) {
        int angleID = 0;
        switch (facing) {
            case WEST: {
                angleID = 1;
                break;
            }
            case NORTH: {
                angleID = 2;
                break;
            }
            case EAST: {
                angleID = 3;
                break;
            }
            case DOWN: {
                angleID = 4;
                break;
            }
            case UP: {
                angleID = 5;
                break;
            }
            default: {
                angleID = 0;
            }
        }
        return angleID;
    }

    public int getAngleID() {
        return this.getAngleIDFromFacing(this.getAngle());
    }

    private EnumFacing getFacingFromAngleID(int angle) {
        EnumFacing face = EnumFacing.SOUTH;
        switch (angle) {
            case 1: {
                face = EnumFacing.WEST;
                break;
            }
            case 2: {
                face = EnumFacing.NORTH;
                break;
            }
            case 3: {
                face = EnumFacing.EAST;
                break;
            }
            case 4: {
                face = EnumFacing.DOWN;
                break;
            }
            case 5: {
                face = EnumFacing.UP;
            }
        }
        return face;
    }

    public void updateSurroundingBlocks(Block blocktype) {
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), blocktype, true);
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), blocktype, true);
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1), blocktype, true);
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1), blocktype, true);
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()), blocktype, true);
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()), blocktype, true);
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), blocktype, true);
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), blocktype, true);
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), blocktype, true);
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 2), blocktype, true);
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 2), blocktype, true);
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 2, this.field_174879_c.func_177952_p()), blocktype, true);
        this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p()), blocktype, true);
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return true;
    }

    public boolean func_191420_l() {
        boolean output = true;
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (this.inventory.get(i) == ItemStack.field_190927_a) continue;
            output = false;
            break;
        }
        return output;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public int getSlots() {
        return this.inventory.size();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack returnStack = stack;
        if (slot < this.inventory.size()) {
            ItemStack currentSlot = this.func_70301_a(slot);
            if (currentSlot != ItemStack.field_190927_a) {
                if (stack.func_77973_b() == currentSlot.func_77973_b() && currentSlot.func_190916_E() < currentSlot.func_77976_d() && !simulate) {
                    int count = currentSlot.func_190916_E() + stack.func_190916_E();
                    if (count > stack.func_77976_d()) {
                        currentSlot.func_190920_e(currentSlot.func_77976_d());
                        this.func_70299_a(slot, currentSlot);
                        returnStack = stack.func_77946_l();
                        returnStack.func_190920_e(count - currentSlot.func_77976_d());
                    } else {
                        stack.func_190920_e(count);
                        this.func_70299_a(slot, stack);
                        returnStack = ItemStack.field_190927_a;
                    }
                }
            } else if (!simulate) {
                this.func_70299_a(slot, stack);
                returnStack = ItemStack.field_190927_a;
            }
        }
        return returnStack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack slottedStack;
        ItemStack result = ItemStack.field_190927_a;
        if (slot < this.inventory.size() && (slottedStack = this.func_70301_a(slot)) != ItemStack.field_190927_a && !simulate) {
            result = slottedStack.func_77946_l();
            if (amount >= slottedStack.func_190916_E()) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else {
                result.func_190920_e(amount);
                slottedStack.func_190920_e(slottedStack.func_190916_E() - amount);
                this.func_70299_a(slot, slottedStack);
            }
        }
        return result;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }
}

