/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.common;

import com.progwml6.natura.Natura;
import com.progwml6.natura.common.block.BlockGrassStairs;
import com.progwml6.natura.common.block.base.BlockNaturaStairsBase;
import com.progwml6.natura.library.Util;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.block.EnumBlockSlab;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.item.ItemBlockSlab;

public abstract class NaturaPulse {
    protected static boolean isEntitiesLoaded() {
        return Natura.pulseManager.isPulseLoaded("NaturaEntities");
    }

    protected static boolean isWorldLoaded() {
        return Natura.pulseManager.isPulseLoaded("NaturaWorld");
    }

    protected static boolean isOverworldLoaded() {
        return Natura.pulseManager.isPulseLoaded("NaturaOverworld");
    }

    protected static boolean isNetherLoaded() {
        return Natura.pulseManager.isPulseLoaded("NaturaNether");
    }

    protected static boolean isDecorativeLoaded() {
        return Natura.pulseManager.isPulseLoaded("NaturaDecorative");
    }

    protected static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        String prefixedName = Util.prefix(name);
        block.func_149663_c(prefixedName);
        NaturaPulse.register(registry, block, name);
        return block;
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockNaturaStairsBase registerBlockStairsFrom(IForgeRegistry<Block> registry, EnumBlock<E> block, E value, String name) {
        return NaturaPulse.registerBlock(registry, new BlockNaturaStairsBase(block.func_176223_P().func_177226_a((IProperty)block.prop, value)), name);
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockGrassStairs registerBlockGrassStairsFrom(IForgeRegistry<Block> registry, EnumBlock<E> block, E value, String name) {
        return NaturaPulse.registerBlock(registry, new BlockGrassStairs(block.func_176223_P().func_177226_a((IProperty)block.prop, value)), name);
    }

    protected static <T extends Block> T registerItemBlock(IForgeRegistry<Item> registry, T block, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        ItemBlockMeta itemBlock = new ItemBlockMeta(block);
        String prefixedName = Util.prefix(name);
        itemBlock.func_77655_b(prefixedName);
        NaturaPulse.register(registry, itemBlock, name);
        return block;
    }

    protected static <T extends EnumBlock<?>> T registerEnumItemBlock(IForgeRegistry<Item> registry, T block, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        ItemBlockMeta itemBlock = new ItemBlockMeta(block);
        String prefixedName = Util.prefix(name);
        itemBlock.func_77655_b(prefixedName);
        NaturaPulse.register(registry, itemBlock, name);
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends Block> T registerItemBlockProp(IForgeRegistry<Item> registry, ItemBlock itemBlock, String name, IProperty<?> property) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        String prefixedName = Util.prefix(name);
        itemBlock.func_77655_b(prefixedName);
        NaturaPulse.register(registry, itemBlock, name);
        ItemBlockMeta.setMappingProperty((Block)itemBlock.func_179223_d(), property);
        return (T)itemBlock.func_179223_d();
    }

    protected static <T extends EnumBlockSlab<?>> T registerEnumItemBlockSlab(IForgeRegistry<Item> registry, T block, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        ItemBlockSlab itemBlock = new ItemBlockSlab(block);
        String prefixedName = Util.prefix(name);
        itemBlock.func_77655_b(prefixedName);
        NaturaPulse.register(registry, itemBlock, name);
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends Item> T registerItem(IForgeRegistry<Item> registry, T item, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Item: %s", name));
        }
        item.func_77655_b(Util.prefix(name));
        item.setRegistryName(Util.getResource(name));
        registry.register(item);
        return item;
    }

    protected static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T thing, String name) {
        thing.setRegistryName(Util.getResource(name));
        registry.register(thing);
        return thing;
    }

    protected static void registerTE(Class<? extends TileEntity> teClazz, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! TE: %s", name));
        }
        GameRegistry.registerTileEntity(teClazz, (String)Util.prefix(name));
    }
}

