/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.entities;

import com.google.common.eventbus.Subscribe;
import com.progwml6.natura.Natura;
import com.progwml6.natura.common.CommonProxy;
import com.progwml6.natura.common.NaturaPulse;
import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.entities.entity.monster.EntityBabyHeatscarSpider;
import com.progwml6.natura.entities.entity.monster.EntityHeatscarSpider;
import com.progwml6.natura.entities.entity.monster.EntityNitroCreeper;
import com.progwml6.natura.entities.entity.passive.EntityImp;
import com.progwml6.natura.library.Util;
import com.progwml6.natura.shared.NaturaCommons;
import java.util.Set;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="NaturaEntities", description="The entites added by Natura")
public class NaturaEntities
extends NaturaPulse {
    public static final String PulseId = "NaturaEntities";
    static final Logger log = Util.getLogger("NaturaEntities");
    @SidedProxy(clientSide="com.progwml6.natura.entities.EntitiesClientProxy", serverSide="com.progwml6.natura.common.CommonProxy")
    public static CommonProxy proxy;

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("imp"), EntityImp.class, (String)"imp", (int)2, (Object)Natura.instance, (int)32, (int)5, (boolean)true, (int)15898421, (int)3022608);
        LootTableList.func_186375_a((ResourceLocation)EntityImp.LOOT_TABLE);
        if (Config.enableHeatscarSpider) {
            EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("heatscarspider"), EntityHeatscarSpider.class, (String)"heatscarspider", (int)0, (Object)Natura.instance, (int)32, (int)5, (boolean)true, (int)15093008, (int)5747133);
            EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("babyheatscarspider"), EntityBabyHeatscarSpider.class, (String)"babyheatscarspider", (int)1, (Object)Natura.instance, (int)32, (int)5, (boolean)true, (int)15093008, (int)5747133);
            LootTableList.func_186375_a((ResourceLocation)EntityHeatscarSpider.LOOT_TABLE);
        }
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("nitrocreeper"), EntityNitroCreeper.class, (String)"nitrocreeper", (int)3, (Object)Natura.instance, (int)64, (int)5, (boolean)true, (int)16203372, (int)10178564);
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
        this.registerSmelting();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        Set biomeList = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
        Biome[] biomes = biomeList.toArray(new Biome[biomeList.size()]);
        EntityRegistry.addSpawn(EntityImp.class, (int)10, (int)8, (int)12, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomes);
        if (Config.enableHeatscarSpider) {
            EntityRegistry.addSpawn(EntityHeatscarSpider.class, (int)10, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
            EntityRegistry.addSpawn(EntityBabyHeatscarSpider.class, (int)10, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
        }
        EntityRegistry.addSpawn(EntityNitroCreeper.class, (int)8, (int)4, (int)6, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
        proxy.postInit();
    }

    private void registerSmelting() {
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        if (NaturaEntities.isEntitiesLoaded()) {
            furnaceRecipes.func_151394_a(NaturaCommons.impmeatRaw.func_77946_l(), NaturaCommons.impmeatCooked.func_77946_l(), 0.2f);
        }
    }
}

