/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.plugin.waila;

import com.progwml6.natura.Natura;
import com.progwml6.natura.common.block.BlockNaturaDoor;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.nether.block.leaves.BlockNetherLeaves;
import com.progwml6.natura.nether.block.logs.BlockNetherLog2;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.overworld.block.crops.BlockOverworldCrops;
import com.progwml6.natura.shared.NaturaCommons;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.cbcore.LangUtil;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HUDHandlerNatura
implements IWailaDataProvider {
    static Method getCrop;
    static Method getDoor;
    static Block overworldLog;
    static Block overworldLog2;
    static Block redwoodLog;
    static Block overworldLeaves;
    static Block overworldLeaves2;
    static Block redwoodLeaves;
    static Block overworldSapling;
    static Block overworldSapling2;
    static Block redwoodSapling;
    static Block barley;
    static Block cotton;
    static Block eucalyptusDoor;
    static Block hopseedDoor;
    static Block sakuraDoor;
    static Block redwoodDoor;
    static Block redwoodBarkDoor;
    static Block netherLog;
    static Block netherLog2;
    static Block netherLeaves;
    static Block netherLeaves2;
    static Block netherSapling;
    static Block netherSapling2;
    static Block ghostwoodDoor;
    static Block bloodwoodDoor;

    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (Natura.pulseManager.isPulseLoaded("NaturaOverworld")) {
            if (block == overworldLog || block == overworldLog2 || block == redwoodLog) {
                return new ItemStack(block, 1, accessor.getMetadata() % 4);
            }
            if (block == overworldLeaves || block == overworldLeaves2 || block == redwoodLeaves) {
                return new ItemStack(block, 1, accessor.getMetadata() % 4);
            }
            if (block == overworldSapling || block == overworldSapling2 || block == redwoodSapling) {
                return new ItemStack(block, 1, accessor.getMetadata() % 8);
            }
            if (block == barley) {
                return NaturaCommons.barley.func_77946_l();
            }
            if (block == cotton) {
                return NaturaCommons.cotton.func_77946_l();
            }
            if (block == eucalyptusDoor) {
                return NaturaOverworld.eucalyptus_door.func_77946_l();
            }
            if (block == hopseedDoor) {
                return NaturaOverworld.hopseed_door.func_77946_l();
            }
            if (block == sakuraDoor) {
                return NaturaOverworld.sakura_door.func_77946_l();
            }
            if (block == redwoodDoor) {
                return NaturaOverworld.redwood_door.func_77946_l();
            }
            if (block == redwoodBarkDoor) {
                return NaturaOverworld.redwood_bark_door.func_77946_l();
            }
        }
        if (Natura.pulseManager.isPulseLoaded("NaturaNether")) {
            if (block == netherLog) {
                return new ItemStack(block, 1, accessor.getMetadata() % 4);
            }
            if (block == netherLog2) {
                return new ItemStack(block, 1, ((Integer)accessor.getBlockState().func_177229_b((IProperty)BlockNetherLog2.META)).intValue());
            }
            if (block == netherLeaves) {
                return new ItemStack(block, 1, ((BlockNetherLeaves.LeavesType)((Object)accessor.getBlockState().func_177229_b(BlockNetherLeaves.TYPE))).getWailaLeavesMeta());
            }
            if (block == netherLeaves2) {
                return new ItemStack(block, 1, accessor.getMetadata() % 4);
            }
            if (block == netherSapling || block == netherSapling2) {
                return new ItemStack(block, 1, accessor.getMetadata() % 8);
            }
            if (block == ghostwoodDoor) {
                return NaturaNether.ghostwood_door.func_77946_l();
            }
            if (block == bloodwoodDoor) {
                return NaturaNether.bloodwood_door.func_77946_l();
            }
        }
        return null;
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        if (config.getConfig("general.showcrop") && BlockOverworldCrops.class.isInstance(block)) {
            float growthValue = (float)accessor.getMetadata() / (float)((BlockOverworldCrops)block).getMaxAge() * 100.0f;
            if ((double)growthValue < 100.0) {
                currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG((String)"hud.msg.growth", (Object[])new Object[0]), Float.valueOf(growthValue)));
            } else {
                currenttip.add(String.format("%s : %s", LangUtil.translateG((String)"hud.msg.growth", (Object[])new Object[0]), LangUtil.translateG((String)"hud.msg.mature", (Object[])new Object[0])));
            }
            return currenttip;
        }
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null) {
            te.func_189515_b(tag);
        }
        return tag;
    }

    public static void register(IWailaRegistrar registrar) {
        HUDHandlerNatura provider = new HUDHandlerNatura();
        registrar.registerStackProvider((IWailaDataProvider)provider, overworldLog.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, overworldLog2.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, redwoodLog.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, overworldLeaves.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, overworldLeaves2.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, redwoodLeaves.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, overworldSapling.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, overworldSapling2.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, redwoodSapling.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, barley.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, cotton.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, eucalyptusDoor.getClass());
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockOverworldCrops.class);
        registrar.registerBodyProvider((IWailaDataProvider)provider, BlockNaturaDoor.class);
        registrar.registerNBTProvider((IWailaDataProvider)provider, cotton.getClass());
        registrar.registerNBTProvider((IWailaDataProvider)provider, barley.getClass());
        registrar.registerNBTProvider((IWailaDataProvider)provider, eucalyptusDoor.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, netherLog.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, netherLog2.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, netherLeaves.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, netherLeaves2.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, netherSapling.getClass());
        registrar.registerStackProvider((IWailaDataProvider)provider, netherSapling2.getClass());
    }

    static {
        overworldLog = NaturaOverworld.overworldLog;
        overworldLog2 = NaturaOverworld.overworldLog2;
        redwoodLog = NaturaOverworld.redwoodLog;
        overworldLeaves = NaturaOverworld.overworldLeaves;
        overworldLeaves2 = NaturaOverworld.overworldLeaves2;
        redwoodLeaves = NaturaOverworld.redwoodLeaves;
        overworldSapling = NaturaOverworld.overworldSapling;
        overworldSapling2 = NaturaOverworld.overworldSapling2;
        redwoodSapling = NaturaOverworld.redwoodSapling;
        barley = NaturaOverworld.barleyCrop;
        cotton = NaturaOverworld.cottonCrop;
        eucalyptusDoor = NaturaOverworld.eucalyptusDoor;
        hopseedDoor = NaturaOverworld.hopseedDoor;
        sakuraDoor = NaturaOverworld.sakuraDoor;
        redwoodDoor = NaturaOverworld.redwoodDoor;
        redwoodBarkDoor = NaturaOverworld.redwoodBarkDoor;
        netherLog = NaturaNether.netherLog;
        netherLog2 = NaturaNether.netherLog2;
        netherLeaves = NaturaNether.netherLeaves;
        netherLeaves2 = NaturaNether.netherLeaves2;
        netherSapling = NaturaNether.netherSapling;
        netherSapling2 = NaturaNether.netherSapling2;
        ghostwoodDoor = NaturaNether.ghostwoodDoor;
        bloodwoodDoor = NaturaNether.bloodwoodDoor;
    }
}

