/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl;

import com.feed_the_beast.ftbl.FTBLibConfig;
import com.feed_the_beast.ftbl.api.EnumReloadType;
import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.EventHandler;
import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.RegisterConfigValueProvidersEvent;
import com.feed_the_beast.ftbl.api.RegisterOptionalServerModsEvent;
import com.feed_the_beast.ftbl.api.ServerReloadEvent;
import com.feed_the_beast.ftbl.api.player.ForgePlayerLoggedOutEvent;
import com.feed_the_beast.ftbl.api.team.ForgeTeamCreatedEvent;
import com.feed_the_beast.ftbl.api.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftbl.api.team.RegisterTeamGuiActionsEvent;
import com.feed_the_beast.ftbl.api.universe.ForgeUniverseLoadedEvent;
import com.feed_the_beast.ftbl.api.universe.ForgeUniverseSavedEvent;
import com.feed_the_beast.ftbl.api_impl.FTBLibTeamGuiActions;
import com.feed_the_beast.ftbl.api_impl.ForgePlayer;
import com.feed_the_beast.ftbl.api_impl.ForgePlayerFake;
import com.feed_the_beast.ftbl.api_impl.ForgeTeam;
import com.feed_the_beast.ftbl.api_impl.SharedServerData;
import com.feed_the_beast.ftbl.api_impl.Universe;
import com.feed_the_beast.ftbl.lib.config.ConfigBlockState;
import com.feed_the_beast.ftbl.lib.config.ConfigBoolean;
import com.feed_the_beast.ftbl.lib.config.ConfigColor;
import com.feed_the_beast.ftbl.lib.config.ConfigDouble;
import com.feed_the_beast.ftbl.lib.config.ConfigInt;
import com.feed_the_beast.ftbl.lib.config.ConfigItemStack;
import com.feed_the_beast.ftbl.lib.config.ConfigList;
import com.feed_the_beast.ftbl.lib.config.ConfigNull;
import com.feed_the_beast.ftbl.lib.config.ConfigString;
import com.feed_the_beast.ftbl.lib.config.ConfigStringEnum;
import com.feed_the_beast.ftbl.lib.config.ConfigTextComponent;
import com.feed_the_beast.ftbl.lib.config.ConfigTristate;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.FileUtils;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.NBTUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@EventHandler
public class FTBLibEventHandler {
    public static final ResourceLocation RELOAD_CONFIG = FTBLibFinals.get("config");

    @SubscribeEvent
    public static void registerOptionalServerMods(RegisterOptionalServerModsEvent event) {
        event.register("ftbl");
    }

    @SubscribeEvent
    public static void registerConfigValueProviders(RegisterConfigValueProvidersEvent event) {
        event.register("null", () -> ConfigNull.INSTANCE);
        event.register("list", () -> new ConfigList("null"));
        event.register("bool", ConfigBoolean::new);
        event.register("tristate", ConfigTristate::new);
        event.register("int", ConfigInt::new);
        event.register("double", ConfigDouble::new);
        event.register("string", ConfigString::new);
        event.register("color", ConfigColor::new);
        event.register("enum", ConfigStringEnum::new);
        event.register("blockstate", ConfigBlockState::new);
        event.register("item_stack", ConfigItemStack::new);
        event.register("text_component", ConfigTextComponent::new);
    }

    @SubscribeEvent
    public static void registerTeamGuiActions(RegisterTeamGuiActionsEvent event) {
        event.register(FTBLibTeamGuiActions.CONFIG);
        event.register(FTBLibTeamGuiActions.INFO);
        event.register(FTBLibTeamGuiActions.MEMBERS);
        event.register(FTBLibTeamGuiActions.ALLIES);
        event.register(FTBLibTeamGuiActions.MODERATORS);
        event.register(FTBLibTeamGuiActions.ENEMIES);
        event.register(FTBLibTeamGuiActions.LEAVE);
        event.register(FTBLibTeamGuiActions.TRANSFER_OWNERSHIP);
    }

    @SubscribeEvent
    public static void onWorldLoaded(WorldEvent.Load event) {
        NBTTagCompound nbt;
        File[] files;
        MinecraftServer server = event.getWorld().func_73046_m();
        if (event.getWorld().field_73011_w.getDimension() != 0 || server == null) {
            return;
        }
        SharedServerData.INSTANCE.reset();
        CommonUtils.folderWorld = new File(FMLCommonHandler.instance().getSavesDirectory(), server.func_71270_I());
        Universe.INSTANCE = new Universe((WorldServer)event.getWorld());
        File folder = new File(CommonUtils.folderWorld, "data/ftb_lib/");
        NBTTagCompound data = new NBTTagCompound();
        JsonObject jsonWorldData = new JsonObject();
        try {
            NBTTagCompound universeData;
            JsonElement worldData = JsonUtils.fromJson(new File(CommonUtils.folderWorld, "world_data.json"));
            if (worldData.isJsonObject()) {
                jsonWorldData = worldData.getAsJsonObject();
            }
            data = (universeData = NBTUtils.readTag(new File(folder, "universe.dat"))) == null ? new NBTTagCompound() : universeData.func_74775_l("Data");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SharedServerData.INSTANCE.func_152753_a((JsonElement)jsonWorldData);
        new ForgeUniverseLoadedEvent.Pre(Universe.INSTANCE, data).post();
        HashMap<UUID, NBTTagCompound> playerNBT = new HashMap<UUID, NBTTagCompound>();
        HashMap<String, NBTTagCompound> teamNBT = new HashMap<String, NBTTagCompound>();
        try {
            files = new File(folder, "players").listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    UUID uuid;
                    if (!f.getName().endsWith(".dat") || (nbt = NBTUtils.readTag(f)) == null) continue;
                    String uuidString = nbt.func_74779_i("UUID");
                    if (uuidString.isEmpty()) {
                        uuidString = FileUtils.getRawFileName(f);
                        FileUtils.delete(f);
                    }
                    if ((uuid = StringUtils.fromString(uuidString)) == null) continue;
                    playerNBT.put(uuid, nbt);
                    ForgePlayer player = new ForgePlayer(uuid, nbt.func_74779_i("Name"));
                    player.firstLogin = false;
                    Universe.INSTANCE.players.put(uuid, player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            files = new File(folder, "teams").listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    if (!f.getName().endsWith(".dat") || (nbt = NBTUtils.readTag(f)) == null) continue;
                    String s = FileUtils.getRawFileName(f);
                    teamNBT.put(s, nbt);
                    Universe.INSTANCE.teams.put(s, new ForgeTeam(s));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (ForgePlayer player : Universe.INSTANCE.players.values()) {
            NBTTagCompound nbt2 = (NBTTagCompound)playerNBT.get(player.getId());
            player.hideTeamNotification.setBoolean(nbt2.func_74767_n("HideTeamNotification"));
            player.lastTimeSeen = nbt2.func_74763_f("LastTimeSeen");
            player.setTeamId(nbt2.func_74779_i("TeamID"));
            player.dataStorage.deserializeNBT(nbt2.func_74775_l("Data"));
        }
        Universe.INSTANCE.players.put(ForgePlayerFake.SERVER.getId(), ForgePlayerFake.SERVER);
        Iterator<ForgeTeam> teamIterator = Universe.INSTANCE.teams.values().iterator();
        while (teamIterator.hasNext()) {
            ForgePlayer player;
            int i;
            ForgeTeam team = teamIterator.next();
            NBTTagCompound nbt3 = (NBTTagCompound)teamNBT.get(team.func_176610_l());
            team.owner = Universe.INSTANCE.getPlayer(nbt3.func_74779_i("Owner"));
            if (team.owner == null) {
                teamIterator.remove();
                continue;
            }
            team.color.setValueFromString(nbt3.func_74779_i("Color"), false);
            team.fakePlayerStatus.setValueFromString(nbt3.func_74779_i("FakePlayerStatus"), false);
            team.title.setString(nbt3.func_74779_i("Title"));
            team.desc.setString(nbt3.func_74779_i("Desc"));
            team.freeToJoin.setBoolean(nbt3.func_74767_n("FreeToJoin"));
            team.players.clear();
            if (nbt3.func_74764_b("Players")) {
                NBTTagCompound nbt1 = nbt3.func_74775_l("Players");
                for (String s : nbt1.func_150296_c()) {
                    EnumTeamStatus status;
                    ForgePlayer player2 = Universe.INSTANCE.getPlayer(s);
                    if (player2 == null || !(status = EnumTeamStatus.NAME_MAP.get(nbt1.func_74779_i(s))).canBeSet()) continue;
                    team.setStatus(player2, status);
                }
            }
            NBTTagList list = nbt3.func_150295_c("RequestingInvite", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                player = Universe.INSTANCE.getPlayer(list.func_150307_f(i));
                if (player == null || team.isMember(player)) continue;
                team.setRequestingInvite(player, true);
            }
            list = nbt3.func_150295_c("Invited", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                player = Universe.INSTANCE.getPlayer(list.func_150307_f(i));
                if (player == null || team.isMember(player)) continue;
                team.setStatus(player, EnumTeamStatus.INVITED);
            }
            team.dataStorage.deserializeNBT(nbt3.func_74775_l("Data"));
        }
        new ForgeUniverseLoadedEvent.Post(Universe.INSTANCE, data).post();
        new ForgeUniverseLoadedEvent.Finished(Universe.INSTANCE).post();
        FTBLibAPI.API.reloadServer((ICommandSender)server, EnumReloadType.CREATED, ServerReloadEvent.ALL);
    }

    @SubscribeEvent
    public static void onWorldUnloaded(WorldEvent.Unload event) {
        MinecraftServer server = event.getWorld().func_73046_m();
        if (event.getWorld().field_73011_w.getDimension() != 0 || server == null) {
            return;
        }
        if (Universe.INSTANCE != null) {
            Universe.INSTANCE.onClosed();
        }
        Universe.INSTANCE = null;
    }

    @SubscribeEvent
    public static void onWorldSaved(WorldEvent.Save event) {
        MinecraftServer server = event.getWorld().func_73046_m();
        if (event.getWorld().field_73011_w.getDimension() != 0 || server == null) {
            return;
        }
        try {
            NBTTagCompound nbt;
            JsonUtils.toJson(SharedServerData.INSTANCE.func_151003_a(), new File(CommonUtils.folderWorld, "world_data.json"));
            File folder = new File(CommonUtils.folderWorld, "data/ftb_lib");
            NBTTagCompound mainNbt = new NBTTagCompound();
            NBTTagCompound data = new NBTTagCompound();
            new ForgeUniverseSavedEvent(Universe.INSTANCE, data).post();
            mainNbt.func_74782_a("Data", (NBTBase)data);
            NBTUtils.writeTag(new File(folder, "universe.dat"), mainNbt);
            for (ForgePlayer player : Universe.INSTANCE.players.values()) {
                if (player.isFake()) continue;
                nbt = new NBTTagCompound();
                nbt.func_74757_a("HideTeamNotification", player.hideTeamNotification.getBoolean());
                nbt.func_74772_a("LastTimeSeen", player.lastTimeSeen);
                nbt.func_74778_a("TeamID", player.team != null && player.team.isValid() ? player.team.func_176610_l() : "");
                nbt.func_74782_a("Data", (NBTBase)player.dataStorage.serializeNBT());
                nbt.func_74778_a("Name", player.func_176610_l());
                nbt.func_74778_a("UUID", StringUtils.fromUUID(player.getId()));
                NBTUtils.writeTag(new File(folder, "players/" + player.func_176610_l().toLowerCase() + ".dat"), nbt);
            }
            for (ForgeTeam team : Universe.INSTANCE.teams.values()) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("Owner", team.owner.func_176610_l());
                nbt.func_74778_a("Color", team.color.getString());
                nbt.func_74778_a("FakePlayerStatus", team.fakePlayerStatus.getString());
                nbt.func_74778_a("Title", team.title.getString());
                nbt.func_74778_a("Desc", team.desc.getString());
                nbt.func_74757_a("FreeToJoin", team.freeToJoin.getBoolean());
                NBTTagCompound nbt1 = new NBTTagCompound();
                if (!team.players.isEmpty()) {
                    for (Map.Entry<IForgePlayer, EnumTeamStatus> entry : team.players.entrySet()) {
                        nbt1.func_74778_a(entry.getKey().func_176610_l(), entry.getValue().func_176610_l());
                    }
                }
                nbt.func_74782_a("Players", (NBTBase)nbt1);
                NBTTagList list = new NBTTagList();
                for (IForgePlayer player : team.requestingInvite) {
                    list.func_74742_a((NBTBase)new NBTTagString(player.func_176610_l()));
                }
                nbt.func_74782_a("RequestingInvite", (NBTBase)list);
                nbt.func_74782_a("Data", (NBTBase)team.dataStorage.serializeNBT());
                NBTUtils.writeTag(new File(folder, "teams/" + team.func_176610_l() + ".dat"), nbt);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        boolean firstLogin;
        if (!(event.player instanceof EntityPlayerMP) || event.player instanceof FakePlayer) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (!player.field_71133_b.func_184103_al().func_152607_e(player.func_146103_bH())) {
            return;
        }
        ForgePlayer p = Universe.INSTANCE.getPlayer(player.func_146103_bH());
        boolean bl = firstLogin = p == null;
        if (firstLogin) {
            p = new ForgePlayer(player.func_110124_au(), player.func_70005_c_());
            Universe.INSTANCE.players.put(p.getId(), p);
        } else if (!p.func_176610_l().equals(player.func_70005_c_())) {
            p.setUsername(player.func_70005_c_());
        }
        p.onLoggedIn(player, firstLogin);
        if (firstLogin && (FTBLibConfig.teams.autocreate_teams || !player.field_71133_b.func_71262_S())) {
            String id = p.func_176610_l().toLowerCase();
            if (Universe.INSTANCE.getTeam(id) != null) {
                id = StringUtils.fromUUID(p.getId());
            }
            if (Universe.INSTANCE.getTeam(id) == null) {
                ForgeTeam team = new ForgeTeam(id);
                Universe.INSTANCE.teams.put(team.func_176610_l(), team);
                p.setTeamId(team.func_176610_l());
                team.setStatus(p, EnumTeamStatus.OWNER);
                new ForgeTeamCreatedEvent(team).post();
                new ForgeTeamPlayerJoinedEvent(team, p).post();
            }
        }
        if (!p.hideTeamNotification() && p.getTeam() == null) {
            ITextComponent b1 = FTBLibLang.CLICK_HERE.textComponent((ICommandSender)player);
            b1.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftb team gui"));
            b1.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, FTBLibLang.MY_TEAM.textComponent((ICommandSender)player)));
            ITextComponent b2 = FTBLibLang.CLICK_HERE.textComponent((ICommandSender)player);
            b2.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftb my_settings ftbl.hide_team_notification toggle"));
            b2.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, FTBLibLang.TEAM_NOTIFICATION_HIDE.textComponent((ICommandSender)player)));
            FTBLibLang.TEAM_NOTIFICATION.sendMessage((ICommandSender)player, b1, b2);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ForgePlayer player;
        if (event.player instanceof EntityPlayerMP && FTBLibAPI.API.hasUniverse() && (player = Universe.INSTANCE.getPlayer(event.player.func_146103_bH())) != null) {
            player.lastTimeSeen = event.player.field_70170_p.func_82737_E();
            player.loggingOut = true;
            new ForgePlayerLoggedOutEvent(player).post();
            player.entityPlayer = null;
            player.playerNBT = null;
        }
    }

    @SubscribeEvent
    public static void registerReloadIds(ServerReloadEvent.RegisterIds event) {
        event.register(RELOAD_CONFIG);
    }

    @SubscribeEvent
    public static void onServerReload(ServerReloadEvent event) {
        if (event.reload(RELOAD_CONFIG)) {
            FTBLibConfig.sync();
        }
    }
}

