/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.api.ICustomName;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import com.feed_the_beast.ftbl.lib.util.LangKey;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbl.lib.util.misc.NameMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public enum EnumTeamStatus implements IStringSerializable,
ICustomName
{
    ENEMY(-10, "enemy", TextFormatting.RED, true),
    NONE(0, "none", TextFormatting.WHITE, true),
    INVITED(10, "invited", TextFormatting.DARK_AQUA, true),
    ALLY(30, "ally", TextFormatting.DARK_GREEN, true),
    MEMBER(50, "member", TextFormatting.BLUE, false),
    MOD(80, "mod", TextFormatting.BLUE, true),
    OWNER(100, "owner", TextFormatting.GOLD, false);

    public static final EnumTeamStatus[] VALUES;
    public static final NameMap<EnumTeamStatus> NAME_MAP;
    public static final NameMap<EnumTeamStatus> NAME_MAP_PERMS;
    public static final Collection<EnumTeamStatus> VALID_VALUES;
    private final String name;
    private final int status;
    private final TextFormatting color;
    private final LangKey langKey;
    private final boolean canBeSet;

    private EnumTeamStatus(int s, String n2, TextFormatting c, boolean cs) {
        this.name = n2;
        this.status = s;
        this.color = c;
        this.langKey = FTBLibFinals.lang("lang.team_status." + this.name, new Class[0]);
        this.canBeSet = cs;
    }

    public String func_176610_l() {
        return this.name;
    }

    @Override
    public ITextComponent getCustomDisplayName() {
        return StringUtils.color(this.langKey.textComponent(null), this.color);
    }

    public int getStatus() {
        return this.status;
    }

    public TextFormatting getColor() {
        return this.color;
    }

    public LangKey getLangKey() {
        return this.langKey;
    }

    public boolean canBeSet() {
        return this.canBeSet;
    }

    public boolean isNone() {
        return this == NONE;
    }

    public boolean isEqualOrGreaterThan(EnumTeamStatus s) {
        return this.status >= s.status;
    }

    public String toString() {
        return this.func_176610_l();
    }

    static {
        VALUES = EnumTeamStatus.values();
        NAME_MAP = NameMap.create(NONE, VALUES);
        NAME_MAP_PERMS = NameMap.create(ALLY, NONE, ALLY, MEMBER);
        VALID_VALUES = new LinkedHashSet<EnumTeamStatus>();
        for (EnumTeamStatus s : VALUES) {
            if (!s.canBeSet) continue;
            VALID_VALUES.add(s);
        }
    }
}

