/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.lib.config.ConfigGroup;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.util.misc.EnumPrivacyLevel;
import com.feed_the_beast.ftbl.lib.util.misc.NBTDataStorage;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.IStringSerializable;

public interface IForgePlayer
extends IStringSerializable {
    public UUID getId();

    default public GameProfile getProfile() {
        return new GameProfile(this.getId(), this.func_176610_l());
    }

    public EntityPlayerMP getPlayer();

    default public EntityPlayerMP getCommandPlayer() throws CommandException {
        if (!this.isOnline()) {
            throw FTBLibLang.PLAYER_NOT_FOUND.commandError(this.func_176610_l());
        }
        return this.getPlayer();
    }

    public NBTDataStorage getData();

    default public boolean equalsPlayer(@Nullable IForgePlayer player) {
        return player == this || player != null && this.getId().equals(player.getId());
    }

    public void setTeamId(String var1);

    @Nullable
    public IForgeTeam getTeam();

    default public boolean canInteract(@Nullable IForgePlayer owner, EnumPrivacyLevel level) {
        IForgeTeam team;
        if (level == EnumPrivacyLevel.PUBLIC || owner == null) {
            return true;
        }
        if (owner.equalsPlayer(this)) {
            return true;
        }
        if (level == EnumPrivacyLevel.PRIVATE) {
            return false;
        }
        return level == EnumPrivacyLevel.TEAM && (team = owner.getTeam()) != null && team.isAlly(this);
    }

    public boolean isOnline();

    public boolean isFake();

    public boolean isOP();

    public StatisticsManagerServer stats();

    public ConfigGroup getSettings();

    public NBTTagCompound getPlayerNBT();

    public void setPlayerNBT(NBTTagCompound var1);

    public boolean hideTeamNotification();

    public boolean isLoggingOut();

    public long getLastTimeSeen();
}

