/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.lib.config.ConfigGroup;
import com.feed_the_beast.ftbl.lib.util.misc.NBTDataStorage;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.server.permission.PermissionAPI;

public interface IForgeTeam
extends IStringSerializable {
    public boolean isValid();

    default public boolean equalsTeam(@Nullable IForgeTeam team) {
        return team == this || team != null && this.func_176610_l().equals(team.func_176610_l());
    }

    public NBTDataStorage getData();

    public IForgePlayer getOwner();

    public String getTitle();

    public String getDesc();

    public EnumTeamColor getColor();

    public EnumTeamStatus getFakePlayerStatus();

    default public EnumTeamStatus getHighestStatus(@Nullable IForgePlayer player) {
        if (player == null) {
            return EnumTeamStatus.NONE;
        }
        if (this.isOwner(player)) {
            return EnumTeamStatus.OWNER;
        }
        if (this.isModerator(player)) {
            return EnumTeamStatus.MOD;
        }
        if (this.isMember(player)) {
            return EnumTeamStatus.MEMBER;
        }
        if (this.isEnemy(player)) {
            return EnumTeamStatus.ENEMY;
        }
        if (this.isAlly(player)) {
            return EnumTeamStatus.ALLY;
        }
        if (this.isInvited(player)) {
            return EnumTeamStatus.INVITED;
        }
        return EnumTeamStatus.NONE;
    }

    default public boolean hasStatus(@Nullable IForgePlayer player, EnumTeamStatus status) {
        if (player == null) {
            return false;
        }
        if (player.isFake()) {
            return this.getFakePlayerStatus().isEqualOrGreaterThan(status);
        }
        switch (status) {
            case NONE: {
                return true;
            }
            case ENEMY: {
                return this.isEnemy(player);
            }
            case ALLY: {
                return this.isAlly(player);
            }
            case INVITED: {
                return this.isInvited(player);
            }
            case MEMBER: {
                return this.isMember(player);
            }
            case MOD: {
                return this.isModerator(player);
            }
            case OWNER: {
                return this.isOwner(player);
            }
        }
        return false;
    }

    public boolean setStatus(IForgePlayer var1, EnumTeamStatus var2);

    default public Collection<IForgePlayer> getPlayersWithStatus(Collection<IForgePlayer> collection, EnumTeamStatus status) {
        for (IForgePlayer iForgePlayer : FTBLibAPI.API.getUniverse().getPlayers()) {
            if (iForgePlayer.isFake() || !this.hasStatus(iForgePlayer, status)) continue;
            collection.add(iForgePlayer);
        }
        return collection;
    }

    default public List<IForgePlayer> getPlayersWithStatus(EnumTeamStatus status) {
        ArrayList<IForgePlayer> list = new ArrayList<IForgePlayer>();
        this.getPlayersWithStatus(list, status);
        return list;
    }

    public boolean addMember(IForgePlayer var1);

    public boolean removeMember(IForgePlayer var1);

    default public List<IForgePlayer> getMembers() {
        return this.getPlayersWithStatus(EnumTeamStatus.MEMBER);
    }

    default public boolean isMember(@Nullable IForgePlayer player) {
        return player != null && this.equalsTeam(player.getTeam());
    }

    public boolean isAlly(@Nullable IForgePlayer var1);

    public boolean isInvited(@Nullable IForgePlayer var1);

    public boolean setRequestingInvite(@Nullable IForgePlayer var1, boolean var2);

    public boolean isRequestingInvite(@Nullable IForgePlayer var1);

    public boolean isEnemy(@Nullable IForgePlayer var1);

    public boolean isModerator(@Nullable IForgePlayer var1);

    default public boolean isOwner(@Nullable IForgePlayer player) {
        return player != null && player.equalsPlayer(this.getOwner());
    }

    public ConfigGroup getSettings();

    default public boolean anyPlayerHasPermission(String permission, EnumTeamStatus status) {
        for (IForgePlayer player : this.getPlayersWithStatus(status)) {
            if (!PermissionAPI.hasPermission((GameProfile)player.getProfile(), (String)permission, null)) continue;
            return true;
        }
        return false;
    }
}

