/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api_impl;

import com.feed_the_beast.ftbl.FTBLibConfig;
import com.feed_the_beast.ftbl.FTBLibMod;
import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.EnumReloadType;
import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.ISharedClientData;
import com.feed_the_beast.ftbl.api.ISharedServerData;
import com.feed_the_beast.ftbl.api.ISidebarButtonGroup;
import com.feed_the_beast.ftbl.api.IUniverse;
import com.feed_the_beast.ftbl.api.ServerReloadEvent;
import com.feed_the_beast.ftbl.api.player.IContainerProvider;
import com.feed_the_beast.ftbl.api_impl.SharedClientData;
import com.feed_the_beast.ftbl.api_impl.SharedServerData;
import com.feed_the_beast.ftbl.api_impl.Universe;
import com.feed_the_beast.ftbl.client.FTBLibModClient;
import com.feed_the_beast.ftbl.lib.config.ConfigGroup;
import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.config.ConfigValueProvider;
import com.feed_the_beast.ftbl.lib.config.IConfigCallback;
import com.feed_the_beast.ftbl.lib.config.RankConfigValueInfo;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.net.MessageBase;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.ServerUtils;
import com.feed_the_beast.ftbl.lib.util.StringJoiner;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbl.lib.util.text_components.Notification;
import com.feed_the_beast.ftbl.net.MessageCloseGui;
import com.feed_the_beast.ftbl.net.MessageEditConfig;
import com.feed_the_beast.ftbl.net.MessageOpenGui;
import com.feed_the_beast.ftbl.net.MessageSyncData;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FTBLibAPI_Impl
extends FTBLibAPI {
    @Override
    public ISharedServerData getServerData() {
        return SharedServerData.INSTANCE;
    }

    @Override
    public ISharedClientData getClientData() {
        return SharedClientData.INSTANCE;
    }

    @Override
    public IUniverse getUniverse() {
        Objects.requireNonNull(Universe.INSTANCE);
        return Universe.INSTANCE;
    }

    @Override
    public boolean hasUniverse() {
        return Universe.INSTANCE != null;
    }

    @Override
    public void reloadServer(ICommandSender sender, EnumReloadType type, ResourceLocation id) {
        long ms = System.currentTimeMillis();
        Preconditions.checkState((boolean)this.hasUniverse(), (Object)"Can't reload yet!");
        HashSet<ResourceLocation> failed = new HashSet<ResourceLocation>();
        ServerReloadEvent event = new ServerReloadEvent(sender, type, id, failed);
        event.post();
        if (ServerUtils.hasOnlinePlayers()) {
            for (EntityPlayerMP player : ServerUtils.getPlayers()) {
                IForgePlayer p = FTBLibAPI.API.getUniverse().getPlayer((ICommandSender)player);
                new MessageSyncData(player, p).sendTo((EntityPlayer)player);
            }
        }
        String millis = System.currentTimeMillis() - ms + "ms";
        if (type == EnumReloadType.RELOAD_COMMAND) {
            for (EntityPlayerMP player : ServerUtils.getPlayers()) {
                Notification notification = Notification.of(FTBLibFinals.get("reload_server"), new ITextComponent[0]);
                notification.addLine(FTBLibLang.RELOAD_SERVER.textComponent((ICommandSender)player, millis));
                if (event.isClientReloadRequired()) {
                    notification.addLine(FTBLibLang.RELOAD_CLIENT.textComponent((ICommandSender)player, StringUtils.color((ITextComponent)new TextComponentString("F3 + T"), TextFormatting.GOLD)));
                }
                if (!failed.isEmpty()) {
                    notification.addLine(StringUtils.color(FTBLibLang.RELOAD_FAILED.textComponent((ICommandSender)player), TextFormatting.RED));
                    String ids = StringJoiner.with(", ").join(failed);
                    notification.addLine(StringUtils.color((ITextComponent)new TextComponentString(ids), TextFormatting.RED));
                    FTBLibFinals.LOGGER.warn(FTBLibLang.RELOAD_FAILED.translate() + " " + ids);
                }
                notification.setImportant(true);
                notification.setTimer(140);
                notification.send((EntityPlayer)player);
            }
        }
        FTBLibFinals.LOGGER.info("Reloaded server in " + millis);
    }

    @Override
    public void openGui(ResourceLocation guiId, EntityPlayerMP player, BlockPos pos, @Nullable NBTTagCompound data) {
        IContainerProvider containerProvider = FTBLibModCommon.GUI_CONTAINER_PROVIDERS.get(guiId);
        if (containerProvider == null) {
            return;
        }
        Container c = containerProvider.getContainer((EntityPlayer)player, pos, data);
        player.func_71117_bO();
        player.func_71128_l();
        if (c != null) {
            player.field_71070_bA = c;
        }
        player.field_71070_bA.field_75152_c = player.field_71139_cq;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        new MessageOpenGui(guiId, pos, data, player.field_71139_cq).sendTo((EntityPlayer)player);
    }

    @Override
    public void editServerConfig(EntityPlayerMP player, ConfigGroup group, IConfigCallback callback) {
        FTBLibModCommon.TEMP_SERVER_CONFIG.put(player.func_146103_bH().getId(), new FTBLibModCommon.EditingConfig(group, callback));
        new MessageEditConfig(group).sendTo((EntityPlayer)player);
    }

    @Override
    public ConfigValue getConfigValueFromId(String id) {
        ConfigValueProvider provider = FTBLibModCommon.CONFIG_VALUE_PROVIDERS.get(id);
        Objects.requireNonNull(provider, "Unknown Config ID: " + id);
        return (ConfigValue)provider.get();
    }

    @Override
    public Map<String, RankConfigValueInfo> getRankConfigRegistry() {
        return FTBLibModCommon.RANK_CONFIGS_MIRROR;
    }

    @Override
    public void handleMessage(MessageBase<?> message, MessageContext context, Side side) {
        if (side.isServer()) {
            context.getServerHandler().field_147369_b.field_71133_b.func_152344_a(() -> {
                message.onMessage((MessageBase)CommonUtils.cast(message), (EntityPlayer)context.getServerHandler().field_147369_b);
                if (FTBLibConfig.general.log_net) {
                    CommonUtils.DEV_LOGGER.info("Net TX: " + message.getClass().getName());
                }
            });
        } else {
            FTBLibMod.PROXY.handleClientMessage(message);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ISidebarButtonGroup> getSidebarButtonGroups() {
        return FTBLibModClient.SIDEBAR_BUTTON_GROUPS;
    }

    @Override
    public void sendCloseGuiPacket(EntityPlayerMP player) {
        new MessageCloseGui().sendTo((EntityPlayer)player);
    }
}

