/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api_impl;

import com.feed_the_beast.ftbl.FTBLibMod;
import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.player.ForgePlayerConfigEvent;
import com.feed_the_beast.ftbl.api.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftbl.lib.config.ConfigBoolean;
import com.feed_the_beast.ftbl.lib.config.ConfigGroup;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.NBTUtils;
import com.feed_the_beast.ftbl.lib.util.ServerUtils;
import com.feed_the_beast.ftbl.lib.util.misc.NBTDataStorage;
import com.feed_the_beast.ftbl.net.MessageSyncData;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.util.FakePlayer;

public class ForgePlayer
implements IForgePlayer,
Comparable<ForgePlayer> {
    private static FakePlayer playerForStats;
    private final UUID playerId;
    private String playerName;
    public boolean firstLogin;
    public final NBTDataStorage dataStorage;
    public IForgeTeam team = null;
    public final ConfigBoolean hideTeamNotification;
    public EntityPlayerMP entityPlayer;
    public NBTTagCompound playerNBT;
    private ConfigGroup cachedConfig;
    public boolean loggingOut;
    public long lastTimeSeen;

    public ForgePlayer(UUID id, String name) {
        this.playerId = id;
        this.playerName = name;
        this.firstLogin = true;
        this.dataStorage = FTBLibMod.PROXY.createDataStorage(this, FTBLibModCommon.DATA_PROVIDER_PLAYER);
        this.hideTeamNotification = new ConfigBoolean();
    }

    @Override
    public final void setTeamId(String id) {
        this.team = FTBLibAPI.API.getUniverse().getTeam(id);
    }

    @Override
    @Nullable
    public final IForgeTeam getTeam() {
        if (this.team != null && !this.team.isValid()) {
            this.team = null;
        }
        return this.team;
    }

    @Override
    public final GameProfile getProfile() {
        if (this.isOnline()) {
            return this.entityPlayer.func_146103_bH();
        }
        return new GameProfile(this.playerId, this.playerName);
    }

    @Override
    public final UUID getId() {
        return this.playerId;
    }

    public final String func_176610_l() {
        return this.playerName;
    }

    public final void setUsername(String n) {
        if (!this.playerName.equals(n)) {
            new File(CommonUtils.folderWorld, "data/ftb_lib/players/" + this.playerName.toLowerCase() + ".dat").delete();
            this.playerName = n;
        }
    }

    @Override
    public NBTDataStorage getData() {
        return this.dataStorage;
    }

    @Override
    public final int compareTo(ForgePlayer o) {
        return this.func_176610_l().compareToIgnoreCase(o.func_176610_l());
    }

    public final String toString() {
        return this.playerName;
    }

    public final int hashCode() {
        return this.playerId.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof IForgePlayer && this.equalsPlayer((IForgePlayer)o);
    }

    @Override
    public boolean isOnline() {
        return this.entityPlayer != null;
    }

    @Override
    public EntityPlayerMP getPlayer() {
        Objects.requireNonNull(this.entityPlayer, "EntityPlayer can't be null!");
        return this.entityPlayer;
    }

    @Override
    public boolean isFake() {
        return this.entityPlayer instanceof FakePlayer;
    }

    @Override
    public boolean isOP() {
        return ServerUtils.isOP(this.getProfile());
    }

    public void onLoggedIn(EntityPlayerMP ep, boolean firstLogin) {
        this.entityPlayer = ep;
        this.playerNBT = null;
        this.loggingOut = false;
        if (!this.isFake()) {
            new MessageSyncData(ep, this).sendTo((EntityPlayer)this.entityPlayer);
        }
        new ForgePlayerLoggedInEvent(this, firstLogin).post();
    }

    @Override
    public StatisticsManagerServer stats() {
        if (playerForStats == null) {
            playerForStats = new FakePlayer(ServerUtils.getOverworld(), new GameProfile(new UUID(0L, 0L), "_unknown"));
        }
        playerForStats.func_184221_a(this.getId());
        return ServerUtils.getServer().func_184103_al().func_152602_a((EntityPlayer)playerForStats);
    }

    @Override
    public ConfigGroup getSettings() {
        if (this.cachedConfig == null) {
            this.cachedConfig = new ConfigGroup(FTBLibLang.MY_SERVER_SETTINGS.textComponent(null));
            this.cachedConfig.setSupergroup("player_config");
            ForgePlayerConfigEvent event = new ForgePlayerConfigEvent(this, this.cachedConfig);
            event.post();
            String group = "ftbl";
            event.getConfig().setGroupName(group, (ITextComponent)new TextComponentString("FTBLib"));
            event.getConfig().add(group, "hide_team_notification", this.hideTeamNotification);
        }
        return this.cachedConfig;
    }

    @Override
    public NBTTagCompound getPlayerNBT() {
        if (this.isOnline()) {
            return this.getPlayer().serializeNBT();
        }
        if (this.playerNBT == null) {
            try {
                this.playerNBT = NBTUtils.readTag(new File(CommonUtils.folderWorld, "playerdata/" + this.getId() + ".dat"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.playerNBT;
    }

    @Override
    public void setPlayerNBT(NBTTagCompound nbt) {
    }

    @Override
    public boolean hideTeamNotification() {
        return this.hideTeamNotification.getBoolean() || this.isFake();
    }

    public void setLoggingOut(boolean v) {
        this.loggingOut = v;
    }

    @Override
    public boolean isLoggingOut() {
        return this.loggingOut;
    }

    @Override
    public long getLastTimeSeen() {
        return this.isOnline() ? CommonUtils.getWorldTime() : this.lastTimeSeen;
    }
}

