/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api_impl;

import com.feed_the_beast.ftbl.FTBLibMod;
import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.team.ForgeTeamConfigEvent;
import com.feed_the_beast.ftbl.api.team.ForgeTeamDeletedEvent;
import com.feed_the_beast.ftbl.api.team.ForgeTeamOwnerChangedEvent;
import com.feed_the_beast.ftbl.api.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftbl.api.team.ForgeTeamPlayerLeftEvent;
import com.feed_the_beast.ftbl.api_impl.Universe;
import com.feed_the_beast.ftbl.lib.config.ConfigBoolean;
import com.feed_the_beast.ftbl.lib.config.ConfigEnum;
import com.feed_the_beast.ftbl.lib.config.ConfigGroup;
import com.feed_the_beast.ftbl.lib.config.ConfigString;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.FileUtils;
import com.feed_the_beast.ftbl.lib.util.FinalIDObject;
import com.feed_the_beast.ftbl.lib.util.misc.NBTDataStorage;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public final class ForgeTeam
extends FinalIDObject
implements IForgeTeam {
    public boolean isValid = true;
    public final NBTDataStorage dataStorage;
    public final ConfigEnum<EnumTeamColor> color = new ConfigEnum<EnumTeamColor>(EnumTeamColor.NAME_MAP);
    public final ConfigEnum<EnumTeamStatus> fakePlayerStatus = new ConfigEnum<EnumTeamStatus>(EnumTeamStatus.NAME_MAP_PERMS);
    public IForgePlayer owner;
    public final ConfigString title = new ConfigString("");
    public final ConfigString desc = new ConfigString("");
    public final ConfigBoolean freeToJoin = new ConfigBoolean(false);
    public final Collection<IForgePlayer> requestingInvite = new HashSet<IForgePlayer>();
    public final Map<IForgePlayer, EnumTeamStatus> players = new HashMap<IForgePlayer, EnumTeamStatus>();
    private ConfigGroup cachedConfig;

    public ForgeTeam(String id) {
        super(id);
        this.dataStorage = FTBLibMod.PROXY.createDataStorage(this, FTBLibModCommon.DATA_PROVIDER_TEAM);
    }

    @Override
    public NBTDataStorage getData() {
        return this.dataStorage;
    }

    @Override
    public IForgePlayer getOwner() {
        return this.owner;
    }

    @Override
    public String getTitle() {
        return this.title.isEmpty() ? this.owner.func_176610_l() + (this.owner.func_176610_l().endsWith("s") ? "' Team" : "'s Team") : this.title.getString();
    }

    @Override
    public String getDesc() {
        return this.desc.getString();
    }

    @Override
    public EnumTeamColor getColor() {
        return this.color.getValue();
    }

    @Override
    public EnumTeamStatus getFakePlayerStatus() {
        return this.fakePlayerStatus.getValue();
    }

    public void setColor(EnumTeamColor col) {
        this.color.setValue(col);
    }

    private EnumTeamStatus getSetStatus(@Nullable IForgePlayer player) {
        if (player == null) {
            return EnumTeamStatus.NONE;
        }
        EnumTeamStatus status = this.players.get(player);
        return status == null ? EnumTeamStatus.NONE : status;
    }

    @Override
    public boolean setStatus(@Nullable IForgePlayer player, EnumTeamStatus status) {
        if (player == null) {
            return false;
        }
        if (status == EnumTeamStatus.OWNER) {
            if (!this.isMember(player)) {
                return false;
            }
            if (!player.equalsPlayer(this.owner)) {
                IForgePlayer oldOwner = this.owner;
                this.owner = player;
                this.players.remove(player);
                new ForgeTeamOwnerChangedEvent(this, oldOwner).post();
                return true;
            }
            return false;
        }
        if (!status.isNone() && status.canBeSet()) {
            return this.players.put(player, status) != status;
        }
        return this.players.remove(player) != status;
    }

    @Override
    public boolean addMember(IForgePlayer player) {
        if ((this.isOwner(player) || this.isInvited(player)) && !this.isMember(player)) {
            player.setTeamId(this.func_176610_l());
            this.players.remove(player);
            this.requestingInvite.remove(player);
            new ForgeTeamPlayerJoinedEvent(this, player).post();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeMember(IForgePlayer player) {
        if (!this.isMember(player)) {
            return false;
        }
        if (this.getMembers().size() == 1) {
            new ForgeTeamDeletedEvent(this).post();
            this.removePlayer0(player);
            Universe.INSTANCE.teams.remove(this.func_176610_l());
            FileUtils.delete(new File(CommonUtils.folderWorld, "data/ftb_lib/teams/" + this.func_176610_l() + ".dat"));
        } else if (this.isOwner(player)) {
            return false;
        }
        this.removePlayer0(player);
        return true;
    }

    private void removePlayer0(IForgePlayer player) {
        player.setTeamId("");
        this.setStatus(player, EnumTeamStatus.NONE);
        new ForgeTeamPlayerLeftEvent(this, player).post();
    }

    @Override
    public boolean isAlly(@Nullable IForgePlayer player) {
        return this.isMember(player) || this.getSetStatus(player).isEqualOrGreaterThan(EnumTeamStatus.ALLY);
    }

    @Override
    public boolean isInvited(@Nullable IForgePlayer player) {
        return this.isMember(player) || (this.freeToJoin.getBoolean() || this.getSetStatus(player).isEqualOrGreaterThan(EnumTeamStatus.INVITED)) && !this.isEnemy(player);
    }

    @Override
    public boolean setRequestingInvite(@Nullable IForgePlayer player, boolean value) {
        if (player != null) {
            if (value) {
                return this.requestingInvite.add(player);
            }
            return this.requestingInvite.remove(player);
        }
        return false;
    }

    @Override
    public boolean isRequestingInvite(@Nullable IForgePlayer player) {
        return player != null && !this.isMember(player) && this.requestingInvite.contains(player) && !this.isEnemy(player);
    }

    @Override
    public boolean isEnemy(@Nullable IForgePlayer player) {
        return this.getSetStatus(player) == EnumTeamStatus.ENEMY;
    }

    @Override
    public boolean isModerator(@Nullable IForgePlayer player) {
        return this.isOwner(player) || this.isMember(player) && this.getSetStatus(player).isEqualOrGreaterThan(EnumTeamStatus.MOD);
    }

    @Override
    public ConfigGroup getSettings() {
        if (this.cachedConfig == null) {
            this.cachedConfig = new ConfigGroup(GuiLang.SETTINGS.textComponent(null));
            this.cachedConfig.setSupergroup("team_config");
            ForgeTeamConfigEvent event = new ForgeTeamConfigEvent(this, this.cachedConfig);
            event.post();
            String group = "ftbl";
            event.getConfig().setGroupName(group, (ITextComponent)new TextComponentString("FTBLib"));
            event.getConfig().add(group, "free_to_join", this.freeToJoin);
            group = "ftbl.display";
            event.getConfig().add(group, "color", this.color);
            event.getConfig().add(group, "fake_player_status", this.fakePlayerStatus);
            event.getConfig().add(group, "title", this.title);
            event.getConfig().add(group, "desc", this.desc);
        }
        return this.cachedConfig;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }
}

