/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api_impl;

import com.feed_the_beast.ftbl.FTBLibConfig;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IUniverse;
import com.feed_the_beast.ftbl.api.universe.ForgeUniverseClosedEvent;
import com.feed_the_beast.ftbl.api_impl.ForgePlayer;
import com.feed_the_beast.ftbl.api_impl.ForgePlayerFake;
import com.feed_the_beast.ftbl.api_impl.ForgeTeam;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class Universe
implements IUniverse {
    public static Universe INSTANCE = null;
    private final WorldServer world;
    public final Map<UUID, ForgePlayer> players;
    public final Map<String, ForgeTeam> teams;

    public Universe(WorldServer w) {
        this.world = w;
        this.players = new HashMap<UUID, ForgePlayer>();
        this.teams = new HashMap<String, ForgeTeam>();
    }

    @Override
    public WorldServer getOverworld() {
        return this.world;
    }

    public Collection<ForgePlayer> getPlayers() {
        return this.players.values();
    }

    @Override
    @Nullable
    public ForgePlayer getPlayer(@Nullable UUID id) {
        return id == null || id.getLeastSignificantBits() == 0L && id.getMostSignificantBits() == 0L ? null : this.players.get(id);
    }

    @Override
    @Nullable
    public ForgePlayer getPlayer(CharSequence nameOrId) {
        String s = nameOrId.toString().toLowerCase();
        if (s.isEmpty()) {
            return null;
        }
        UUID id = StringUtils.fromString(s);
        if (id != null) {
            return this.getPlayer(id);
        }
        for (ForgePlayer p : this.players.values()) {
            if (!p.func_176610_l().toLowerCase().equals(s)) continue;
            return p;
        }
        for (ForgePlayer p : this.players.values()) {
            if (!p.func_176610_l().toLowerCase().contains(s)) continue;
            return p;
        }
        return null;
    }

    @Override
    public ForgePlayer getPlayer(ICommandSender sender) {
        if (sender == this.getServer()) {
            return ForgePlayerFake.SERVER;
        }
        Preconditions.checkArgument((boolean)(sender instanceof EntityPlayerMP));
        EntityPlayerMP player = (EntityPlayerMP)sender;
        ForgePlayer p = this.getPlayer(player.func_146103_bH());
        if (p == null && player instanceof FakePlayer) {
            p = new ForgePlayerFake((FakePlayer)player);
            this.players.put(p.getId(), p);
            p.onLoggedIn(player, false);
            return p;
        }
        return Objects.requireNonNull(p);
    }

    @Override
    @Nullable
    public ForgePlayer getPlayer(GameProfile profile) {
        ForgePlayer player = this.getPlayer(profile.getId());
        if (player == null && FTBLibConfig.general.merge_offline_mode_players.get(!this.getServer().func_71262_S()) && (player = this.getPlayer(profile.getName())) != null) {
            this.players.put(profile.getId(), player);
        }
        return player;
    }

    public Collection<ForgeTeam> getTeams() {
        return this.teams.values();
    }

    @Override
    @Nullable
    public ForgeTeam getTeam(String id) {
        return id.isEmpty() ? null : this.teams.get(id);
    }

    public void onClosed() {
        new ForgeUniverseClosedEvent(this).post();
        this.players.clear();
        this.teams.clear();
    }

    @Override
    public Collection<IForgePlayer> getOnlinePlayers() {
        Set<IForgePlayer> l = Collections.emptySet();
        for (IForgePlayer iForgePlayer : this.players.values()) {
            if (!iForgePlayer.isOnline()) continue;
            if (l.isEmpty()) {
                l = new HashSet<IForgePlayer>();
            }
            l.add(iForgePlayer);
        }
        return l;
    }
}

