/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client;

import com.feed_the_beast.ftbl.api.ClientATHelper;
import com.feed_the_beast.ftbl.api.CustomSidebarButtonTextEvent;
import com.feed_the_beast.ftbl.api.EventHandler;
import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.INotification;
import com.feed_the_beast.ftbl.api.ISidebarButton;
import com.feed_the_beast.ftbl.api.ISidebarButtonGroup;
import com.feed_the_beast.ftbl.api_impl.SharedClientData;
import com.feed_the_beast.ftbl.client.FTBLibClientConfig;
import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.icon.AtlasSpriteIcon;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.IconPresets;
import com.feed_the_beast.ftbl.lib.item.ODItems;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.chat.IChatListener;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

@EventHandler(value={Side.CLIENT})
public class FTBLibClientEventHandler {
    private static Temp currentNotification;
    private static final IChatListener CHAT_LISTENER;

    @SubscribeEvent
    public static void onConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        SharedClientData.INSTANCE.reset();
        currentNotification = null;
        Temp.MAP.clear();
        ClientATHelper.INSTANCE.getChatListeners().get(ChatType.GAME_INFO).clear();
        ClientATHelper.INSTANCE.getChatListeners().get(ChatType.GAME_INFO).add(CHAT_LISTENER);
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        Set<String> ores;
        if (FTBLibClientConfig.general.item_ore_names && !(ores = ODItems.getOreNames(null, event.getItemStack())).isEmpty()) {
            event.getToolTip().add(StringUtils.translate("ftbl_client.config.general.item_ore_names.item_tooltip"));
            for (String or : ores) {
                event.getToolTip().add("> " + or);
            }
        }
        if (FTBLibClientConfig.general.item_nbt && event.getItemStack().func_77942_o()) {
            event.getToolTip().add(TextFormatting.DARK_GRAY.toString() + TextFormatting.func_110646_a((String)event.getItemStack().func_77978_p().toString()));
        }
    }

    @SubscribeEvent
    public static void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!(event.getGui() instanceof InventoryEffectRenderer)) {
            return;
        }
        List<ISidebarButtonGroup> groups = FTBLibAPI.API.getSidebarButtonGroups();
        if (!groups.isEmpty()) {
            GuiButtonSidebarGroup renderer = new GuiButtonSidebarGroup();
            event.getButtonList().add(renderer);
            int y = 0;
            for (ISidebarButtonGroup group : groups) {
                int x = 0;
                boolean addedAny = false;
                for (ISidebarButton button : group.getButtons()) {
                    if (!button.isVisible()) continue;
                    GuiButtonSidebar b = new GuiButtonSidebar(x, y, button);
                    event.getButtonList().add(b);
                    renderer.buttons.add(b);
                    ++x;
                    addedAny = true;
                }
                if (!addedAny) continue;
                ++y;
            }
            renderer.updateButtonPositions();
        }
    }

    @SubscribeEvent
    public static void onGuiAction(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.getButton() instanceof GuiButtonSidebar) {
            GuiHelper.playClickSound();
            ((GuiButtonSidebar)event.getButton()).button.onClicked(GuiScreen.func_146272_n());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (ClientUtils.MC.field_71441_e == null) {
                currentNotification = null;
                Temp.MAP.clear();
            }
            if (currentNotification != null && FTBLibClientEventHandler.currentNotification.tick()) {
                currentNotification = null;
            }
            if (currentNotification == null && !Temp.MAP.isEmpty()) {
                currentNotification = new Temp((ITextComponent)Temp.MAP.values().iterator().next());
                Temp.MAP.remove(((Temp)FTBLibClientEventHandler.currentNotification).widget.id);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onGameOverlayRender(RenderGameOverlayEvent.Text event) {
        if (currentNotification != null && !FTBLibClientEventHandler.currentNotification.isImportant()) {
            currentNotification.render(event.getResolution(), event.getPartialTicks());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && currentNotification != null && FTBLibClientEventHandler.currentNotification.isImportant()) {
            currentNotification.render(new ScaledResolution(ClientUtils.MC), event.renderTickTime);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onWorldRender(RenderWorldLastEvent event) {
        ClientUtils.updateRenderInfo();
    }

    @SubscribeEvent
    public static void onBeforeTexturesStitched(TextureStitchEvent.Pre event) {
        block3: {
            ClientUtils.SPRITE_MAP.clear();
            try {
                for (Field field : GuiIcons.class.getDeclaredFields()) {
                    field.setAccessible(true);
                    Object o = field.get(null);
                    if (!(o instanceof AtlasSpriteIcon)) continue;
                    AtlasSpriteIcon a = (AtlasSpriteIcon)o;
                    event.getMap().func_174942_a(a.name);
                    IconPresets.MAP.put(a.name.toString(), a);
                }
            }
            catch (Exception ex) {
                if (!CommonUtils.DEV_ENV) break block3;
                ex.printStackTrace();
            }
        }
    }

    static {
        CHAT_LISTENER = (type, component) -> {
            if (type == ChatType.GAME_INFO) {
                if (component instanceof INotification || FTBLibClientConfig.general.replace_vanilla_status_messages) {
                    ResourceLocation id = component instanceof INotification ? ((INotification)component).getId() : INotification.VANILLA_STATUS;
                    Temp.MAP.remove(id);
                    if (currentNotification != null && ((Temp)FTBLibClientEventHandler.currentNotification).widget.id.equals((Object)id)) {
                        currentNotification = null;
                    }
                    Temp.MAP.put(id, component);
                } else {
                    ClientUtils.MC.field_71456_v.func_110326_a(component.func_150254_d(), false);
                }
            }
        };
    }

    private static class GuiButtonSidebarGroup
    extends GuiButton {
        public final List<GuiButtonSidebar> buttons = new ArrayList<GuiButtonSidebar>();
        private int prevGuiLeft = -1;
        private int prevGuiTop = -1;

        public GuiButtonSidebarGroup() {
            super(495829, -1000, -1000, 0, 0, "");
        }

        public void updateButtonPositions() {
            boolean hasPotions;
            if (!(ClientUtils.MC.field_71462_r instanceof InventoryEffectRenderer)) {
                return;
            }
            InventoryEffectRenderer gui = (InventoryEffectRenderer)ClientUtils.MC.field_71462_r;
            int guiLeft = ClientATHelper.INSTANCE.getGuiX((GuiContainer)gui);
            int guiTop = ClientATHelper.INSTANCE.getGuiY((GuiContainer)gui);
            if (this.prevGuiLeft != guiLeft || this.prevGuiTop != guiTop) {
                this.prevGuiLeft = guiLeft;
                this.prevGuiTop = guiTop;
            }
            boolean bl = hasPotions = !gui.field_146297_k.field_71439_g.func_70651_bq().isEmpty() || gui instanceof GuiInventory && ClientATHelper.INSTANCE.getRecipeBook((GuiInventory)gui).func_191878_b();
            if (hasPotions || FTBLibClientConfig.general.action_buttons.top()) {
                for (GuiButtonSidebar button : this.buttons) {
                    button.field_146128_h = 2 + button.buttonX * 17;
                    button.field_146129_i = 2 + button.buttonY * 17;
                }
            } else {
                int buttonX = -17;
                int buttonY = 8;
                if (gui instanceof GuiContainerCreative) {
                    buttonY = 6;
                }
                for (int index = 0; index < this.buttons.size(); ++index) {
                    GuiButtonSidebar button = this.buttons.get(index);
                    button.field_146128_h = guiLeft + buttonX - index / 8 * 17;
                    button.field_146129_i = guiTop + buttonY + index % 8 * 17;
                }
            }
        }

        public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
            this.updateButtonPositions();
            this.field_73735_i = 0.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)310.0f);
            FontRenderer font = mc.field_71466_p;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (GuiButtonSidebar b : this.buttons) {
                b.button.getIcon().draw(b.field_146128_h, b.field_146129_i, b.field_146120_f, b.field_146121_g);
                if (mx < b.field_146128_h || my < b.field_146129_i || mx >= b.field_146128_h + b.field_146120_f || my >= b.field_146129_i + b.field_146121_g) continue;
                Color4I.WHITE_A[33].draw(b.field_146128_h, b.field_146129_i, b.field_146120_f, b.field_146121_g);
            }
            for (GuiButtonSidebar b : this.buttons) {
                if (b.button.hasCustomText()) {
                    CustomSidebarButtonTextEvent event = new CustomSidebarButtonTextEvent(b.button);
                    event.post();
                    if (!event.getText().isEmpty()) {
                        int nw = font.func_78256_a(event.getText());
                        int width = 16;
                        Color4I.LIGHT_RED.draw(b.field_146128_h + width - nw, b.field_146129_i - 4, nw + 1, 9);
                        font.func_78276_b(event.getText(), b.field_146128_h + width - nw + 1, b.field_146129_i - 3, -1);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                }
                if (mx < b.field_146128_h || my < b.field_146129_i || mx >= b.field_146128_h + b.field_146120_f || my >= b.field_146129_i + b.field_146121_g) continue;
                double mx1 = (double)mx - 4.0;
                double my1 = (double)my - 12.0;
                int tw = font.func_78256_a(b.title);
                if (!FTBLibClientConfig.general.action_buttons.top()) {
                    mx1 -= (double)(tw + 8);
                    my1 += 4.0;
                }
                if (mx1 < 4.0) {
                    mx1 = 4.0;
                }
                if (my1 < 4.0) {
                    my1 = 4.0;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)mx1, (double)my1, (double)600.0);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                Color4I.DARK_GRAY.draw(-3, -2, tw + 6, 12);
                font.func_78276_b(b.title, 0, 0, -1);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            this.field_73735_i = 0.0f;
        }
    }

    private static class GuiButtonSidebar
    extends GuiButton {
        public final int buttonX;
        public final int buttonY;
        public final ISidebarButton button;
        public final String title;

        public GuiButtonSidebar(int x, int y, ISidebarButton b) {
            super(495830 + x + y * 16, -16, -16, 16, 16, "");
            this.buttonX = x;
            this.buttonY = y;
            this.button = b;
            this.title = StringUtils.translate("sidebar_button." + b.func_176610_l());
        }

        public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
        }
    }

    private static class Temp {
        private static final LinkedHashMap<ResourceLocation, ITextComponent> MAP = new LinkedHashMap();
        private long tick;
        private long endTick;
        private NotificationWidget widget;

        private Temp(ITextComponent n) {
            this.widget = new NotificationWidget(n, ClientUtils.MC.field_71466_p);
            this.endTick = -1L;
            this.tick = -1L;
        }

        public void render(ScaledResolution screen, float partialTicks) {
            if (this.tick == -1L || this.tick >= this.endTick) {
                return;
            }
            int alpha = (int)Math.min(255.0f, ((float)(this.endTick - this.tick) - partialTicks) * 255.0f / 20.0f);
            if (alpha <= 2) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((int)((float)screen.func_78326_a() / 2.0f)), (float)((int)((float)screen.func_78328_b() - 68.0f)), (float)0.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int offy = -(this.widget.text.size() * 11) / 2;
            for (int i = 0; i < this.widget.text.size(); ++i) {
                String string = this.widget.text.get(i);
                this.widget.font.func_175063_a(string, (float)(-this.widget.font.func_78256_a(string) / 2), (float)(offy + i * 11), 0xFFFFFF | alpha << 24);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
        }

        private boolean tick() {
            this.tick = ClientUtils.MC.field_71441_e.func_82737_E();
            if (this.endTick == -1L) {
                this.endTick = this.tick + this.widget.timer;
            }
            return this.tick >= this.endTick || Math.min(255.0f, (float)(this.endTick - this.tick) * 255.0f / 20.0f) <= 2.0f;
        }

        private boolean isImportant() {
            return this.widget.notification instanceof INotification && ((INotification)this.widget.notification).isImportant();
        }
    }

    public static class NotificationWidget {
        public final ITextComponent notification;
        public final ResourceLocation id;
        public final List<String> text;
        public int width;
        public int height;
        public final FontRenderer font;
        public final long timer;

        public NotificationWidget(ITextComponent n, FontRenderer f) {
            this.notification = n;
            this.id = n instanceof INotification ? ((INotification)n).getId() : INotification.VANILLA_STATUS;
            this.width = 0;
            this.font = f;
            this.text = new ArrayList<String>();
            this.timer = n instanceof INotification ? (long)((INotification)n).getTimer() & 0xFFL : 60L;
            for (String s : this.font.func_78271_c(this.notification.func_150254_d(), new ScaledResolution(ClientUtils.MC).func_78326_a())) {
                for (String line : s.split("\n")) {
                    if (line.isEmpty()) continue;
                    line = StringUtils.trimAllWhitespace(line);
                    this.text.add(line);
                    this.width = Math.max(this.width, this.font.func_78256_a(line));
                }
            }
            this.width += 4;
            this.height = this.text.size() * 11;
            if (this.text.isEmpty()) {
                this.width = 20;
                this.height = 20;
            }
        }
    }
}

