/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client;

import com.feed_the_beast.ftbl.FTBLibConfig;
import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.ClientATHelper;
import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.ISidebarButton;
import com.feed_the_beast.ftbl.api.ISidebarButtonGroup;
import com.feed_the_beast.ftbl.api.player.IGuiProvider;
import com.feed_the_beast.ftbl.api.player.RegisterGuiProvidersEvent;
import com.feed_the_beast.ftbl.api_impl.ClientATHelperImpl;
import com.feed_the_beast.ftbl.client.BuiltinChunkMap;
import com.feed_the_beast.ftbl.client.ClientConfig;
import com.feed_the_beast.ftbl.client.FTBLibClientConfig;
import com.feed_the_beast.ftbl.client.SidebarButton;
import com.feed_the_beast.ftbl.client.SidebarButtonGroup;
import com.feed_the_beast.ftbl.cmd.CmdFTBC;
import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.misc.ChunkSelectorMap;
import com.feed_the_beast.ftbl.lib.icon.PlayerHeadIcon;
import com.feed_the_beast.ftbl.lib.net.MessageBase;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class FTBLibModClient
extends FTBLibModCommon
implements IResourceManagerReloadListener {
    public static final List<ISidebarButtonGroup> SIDEBAR_BUTTON_GROUPS = new ArrayList<ISidebarButtonGroup>();
    private static final Map<ResourceLocation, IGuiProvider> GUI_PROVIDERS = new HashMap<ResourceLocation, IGuiProvider>();
    public static final Map<String, ClientConfig> CLIENT_CONFIG_MAP = new HashMap<String, ClientConfig>();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ClientATHelper.INSTANCE = new ClientATHelperImpl();
        FTBLibClientConfig.sync();
        new RegisterGuiProvidersEvent(GUI_PROVIDERS::put).post();
        ClientUtils.localPlayerHead = new PlayerHeadIcon(ClientUtils.MC.func_110432_I().func_148256_e().getName());
        ((IReloadableResourceManager)ClientUtils.MC.func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
        ChunkSelectorMap.setMap(new BuiltinChunkMap());
    }

    public void func_110549_a(IResourceManager manager) {
        SIDEBAR_BUTTON_GROUPS.clear();
        CLIENT_CONFIG_MAP.clear();
        for (String domain : manager.func_135055_a()) {
            try {
                for (IResource resource : manager.func_135056_b(new ResourceLocation(domain, "client_config.json"))) {
                    for (Object e : JsonUtils.fromJson(resource).getAsJsonArray()) {
                        ClientConfig c = new ClientConfig(e.getAsJsonObject());
                        CLIENT_CONFIG_MAP.put(c.id, c);
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) continue;
                ex.printStackTrace();
            }
        }
        JsonElement element = JsonUtils.fromJson(new File(CommonUtils.folderLocal, "client/sidebar_buttons.json"));
        JsonObject sidebarButtonConfig = element.isJsonObject() ? element.getAsJsonObject() : new JsonObject();
        HashMap<ResourceLocation, SidebarButtonGroup> groupMap = new HashMap<ResourceLocation, SidebarButtonGroup>();
        for (String domain : manager.func_135055_a()) {
            JsonElement json;
            block16: {
                try {
                    for (IResource resource : manager.func_135056_b(new ResourceLocation(domain, "sidebar_button_groups.json"))) {
                        json = JsonUtils.fromJson(resource);
                        for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                            JsonObject groupJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                            int y = 0;
                            if (groupJson.has("y")) {
                                y = groupJson.get("y").getAsInt();
                            }
                            SidebarButtonGroup group = new SidebarButtonGroup(new ResourceLocation(domain, (String)entry.getKey()), y);
                            groupMap.put(group.getId(), group);
                        }
                    }
                }
                catch (Exception ex) {
                    if (ex instanceof FileNotFoundException) break block16;
                    ex.printStackTrace();
                }
            }
            try {
                for (IResource resource : manager.func_135056_b(new ResourceLocation(domain, "sidebar_buttons.json"))) {
                    json = JsonUtils.fromJson(resource);
                    if (!json.isJsonObject()) continue;
                    for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                        SidebarButtonGroup group;
                        JsonObject buttonJson;
                        if (!((JsonElement)entry.getValue()).isJsonObject() || !(buttonJson = ((JsonElement)entry.getValue()).getAsJsonObject()).has("group") || !CommonUtils.DEV_ENV && buttonJson.has("dev_only") && buttonJson.get("dev_only").getAsBoolean() || (group = (SidebarButtonGroup)groupMap.get(new ResourceLocation(buttonJson.get("group").getAsString()))) == null) continue;
                        SidebarButton button = new SidebarButton(new ResourceLocation(domain, (String)entry.getKey()), group, buttonJson);
                        group.getButtons().add(button);
                        if (button.getDefaultConfig() == null || !sidebarButtonConfig.has(button.func_176610_l())) continue;
                        button.setConfig(sidebarButtonConfig.get(button.func_176610_l()).getAsBoolean());
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) continue;
                ex.printStackTrace();
            }
        }
        for (ISidebarButtonGroup group : groupMap.values()) {
            if (group.getButtons().isEmpty()) continue;
            group.getButtons().sort(null);
            SIDEBAR_BUTTON_GROUPS.add(group);
        }
        SIDEBAR_BUTTON_GROUPS.sort(null);
        FTBLibModClient.saveSidebarButtonConfig();
    }

    @Override
    public void postInit() {
        super.postInit();
        CmdFTBC cmd = new CmdFTBC();
        ClientCommandHandler.instance.func_71560_a((ICommand)cmd);
        if (FTBLibClientConfig.general.mirror_commands) {
            cmd.getSubCommands().forEach(arg_0 -> ((ClientCommandHandler)ClientCommandHandler.instance).func_71560_a(arg_0));
        }
    }

    @Override
    public void handleClientMessage(MessageBase<?> message) {
        ClientUtils.MC.func_152343_a((Callable)new MessageTask(message));
    }

    @Nullable
    public static IGuiProvider getGui(ResourceLocation id) {
        return GUI_PROVIDERS.get(id);
    }

    public static void saveSidebarButtonConfig() {
        JsonObject o = new JsonObject();
        for (ISidebarButtonGroup group : FTBLibAPI.API.getSidebarButtonGroups()) {
            for (ISidebarButton button : group.getButtons()) {
                if (button.getDefaultConfig() == null) continue;
                o.addProperty(button.func_176610_l(), Boolean.valueOf(button.getConfig()));
            }
        }
        JsonUtils.toJson((JsonElement)o, new File(CommonUtils.folderLocal, "client/sidebar_buttons.json"));
    }

    private static class MessageTask
    implements Callable<Object> {
        private final MessageBase<?> message;

        private MessageTask(MessageBase<?> m) {
            this.message = m;
        }

        @Override
        @Nullable
        public Object call() throws Exception {
            this.message.onMessage((MessageBase)CommonUtils.cast(this.message), (EntityPlayer)ClientUtils.MC.field_71439_g);
            if (FTBLibConfig.general.log_net) {
                CommonUtils.DEV_LOGGER.info("Net RX: " + this.message.getClass().getName());
            }
            return null;
        }
    }
}

