/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.client.ClientConfig;
import com.feed_the_beast.ftbl.client.FTBLibModClient;
import com.feed_the_beast.ftbl.client.GuiSidebarButtonConfig;
import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiMessageDialog;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GuiClientConfig
extends GuiButtonListBase {
    public GuiClientConfig() {
        this.setTitle(StringUtils.translate("sidebar_button.ftbl.settings"));
    }

    @Override
    public void addButtons(Panel panel) {
        ArrayList<SimpleTextButton> buttons = new ArrayList<SimpleTextButton>();
        for (ClientConfig config : FTBLibModClient.CLIENT_CONFIG_MAP.values()) {
            buttons.add(new ButtonClientConfig(this.gui, config));
        }
        buttons.sort((o1, o2) -> o1.getTitle().compareToIgnoreCase(o2.getTitle()));
        buttons.add(0, new SimpleTextButton(this.gui, 0, 0, StringUtils.translate("sidebar_button"), Icon.getIcon("ftbl:textures/gui/teams.png")){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                new GuiSidebarButtonConfig().openGui();
            }
        });
        if (FTBLibAPI.API.getClientData().optionalServerMods().contains("ftbl")) {
            buttons.add(0, new SimpleTextButton(this.gui, 0, 0, StringUtils.translate("player_config"), GuiIcons.SETTINGS_RED){

                @Override
                public void onClicked(MouseButton button) {
                    GuiHelper.playClickSound();
                    new GuiLoading().openGui();
                    ClientUtils.execClientCommand("/ftb my_settings");
                }
            });
        }
        panel.addAll(buttons);
    }

    @Override
    public void onClosed() {
        FTBLibModClient.saveSidebarButtonConfig();
    }

    private class ButtonClientConfig
    extends SimpleTextButton {
        private final String modId;

        public ButtonClientConfig(GuiBase gui, ClientConfig config) {
            super(gui, 0, 0, config.name.func_150254_d(), config.icon);
            this.modId = config.id;
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            ClientUtils.MC.func_147108_a((GuiScreen)new GuiCustomConfig(this.modId, this.getTitle()));
        }
    }

    private class GuiCustomConfig
    extends GuiConfig {
        public GuiCustomConfig(String modid, String title) {
            super(ClientUtils.MC.field_71462_r, modid, title);
        }

        protected void func_146284_a(GuiButton button) {
            if (button.field_146127_k == 2000) {
                boolean flag = true;
                try {
                    if ((this.configID != null || this.parentScreen == null || !(this.parentScreen instanceof GuiConfig)) && this.entryList.hasChangedEntry(true)) {
                        boolean requiresMcRestart = this.entryList.saveConfigElements();
                        ConfigChangedEvent.OnConfigChangedEvent event = new ConfigChangedEvent.OnConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.getResult().equals((Object)Event.Result.DENY)) {
                            MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.PostConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart));
                        }
                        if (requiresMcRestart) {
                            flag = false;
                            this.field_146297_k.func_147108_a((GuiScreen)new GuiMessageDialog(this.parentScreen, "fml.configgui.gameRestartTitle", (ITextComponent)new TextComponentString(StringUtils.translate("fml.configgui.gameRestartRequired")), "fml.configgui.confirmRestartMessage"));
                        }
                        if (this.parentScreen instanceof GuiConfig) {
                            ((GuiConfig)this.parentScreen).needsRefresh = true;
                        }
                    }
                }
                catch (Throwable e) {
                    FMLLog.log.error("Error performing GuiConfig action:", e);
                }
                if (flag) {
                    this.field_146297_k.func_147108_a(this.parentScreen);
                }
            } else {
                super.func_146284_a(button);
            }
        }
    }
}

