/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client;

import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.config.ConfigGroup;
import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.config.ConfigValueInfo;
import com.feed_the_beast.ftbl.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftbl.lib.config.IConfigCallback;
import com.feed_the_beast.ftbl.lib.config.IGuiEditConfig;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.gui.SimpleButton;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.WidgetLayout;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.MutableColor4I;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiEditConfig
extends GuiBase
implements IGuiEditConfig {
    private static final Color4I COLOR_BACKGROUND = Color4I.rgba(-1724697805);
    private final ConfigGroup group;
    private final IConfigCallback callback;
    private final JsonObject modifiedConfig;
    private final String title;
    private final List<Widget> configEntryButtons;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final Button buttonCollapseAll;
    private final Button buttonExpandAll;
    private final PanelScrollBar scroll;
    private int shouldClose = 0;

    public GuiEditConfig(ConfigGroup g, IConfigCallback c) {
        super(0, 0);
        this.group = g;
        this.callback = c;
        ITextComponent title0 = g.getTitle().func_150259_f();
        title0.func_150256_b().func_150227_a(Boolean.valueOf(true));
        this.title = title0.func_150254_d();
        this.modifiedConfig = new JsonObject();
        this.configEntryButtons = new ArrayList<Widget>();
        ArrayList<ConfigValueInstance> list = new ArrayList<ConfigValueInstance>();
        for (ConfigValueInstance instance : this.group.getMap().values()) {
            if (instance.info.hidden) continue;
            list.add(instance);
        }
        if (!list.isEmpty()) {
            list.sort((o1, o2) -> {
                int i = o1.info.group.compareToIgnoreCase(o2.info.group);
                return i == 0 ? StringUtils.translate(this.group.getNameKey(o1.info)).compareToIgnoreCase(StringUtils.translate(this.group.getNameKey(o2.info))) : i;
            });
            ButtonConfigGroup group = null;
            for (ConfigValueInstance instance : list) {
                if (group == null || !group.groupId.equalsIgnoreCase(instance.info.group)) {
                    group = new ButtonConfigGroup(this, instance.info.group);
                    this.configEntryButtons.add(group);
                }
                this.configEntryButtons.add(new ButtonConfigEntry(this, group, instance.info, instance.value.copy()));
            }
        }
        this.configPanel = new Panel(this, 0, 20, 0, 20){

            @Override
            public void addWidgets() {
                for (Widget w : GuiEditConfig.this.configEntryButtons) {
                    if (w instanceof ButtonConfigEntry && ((ButtonConfigEntry)w).group.collapsed) continue;
                    this.add(w);
                }
            }

            @Override
            public void updateWidgetPositions() {
                GuiEditConfig.this.scroll.setElementSize(this.align(WidgetLayout.VERTICAL));
            }
        };
        this.configPanel.addFlags(3);
        this.scroll = new PanelScrollBar(this, -16, 20, 16, 0, 0, this.configPanel){

            @Override
            public boolean shouldRender() {
                return true;
            }
        };
        this.buttonAccept = new SimpleButton((GuiBase)this, 0, 2, GuiLang.ACCEPT, GuiIcons.ACCEPT, (gui, button) -> {
            this.shouldClose = 1;
            gui.closeGui();
        });
        this.buttonCancel = new SimpleButton((GuiBase)this, 0, 2, GuiLang.CANCEL, GuiIcons.CANCEL, (gui, button) -> {
            this.shouldClose = 2;
            gui.closeGui();
        });
        this.buttonCollapseAll = new SimpleButton((GuiBase)this, 0, 2, GuiLang.COLLAPSE_ALL, GuiIcons.REMOVE, (gui, button) -> {
            for (Widget w : this.configEntryButtons) {
                if (!(w instanceof ButtonConfigGroup)) continue;
                ((ButtonConfigGroup)w).setCollapsed(true);
            }
            this.scroll.setValue(0.0);
            gui.refreshWidgets();
        });
        this.buttonExpandAll = new SimpleButton((GuiBase)this, 0, 2, GuiLang.EXPAND_ALL, GuiIcons.ADD, (gui, button) -> {
            for (Widget w : this.configEntryButtons) {
                if (!(w instanceof ButtonConfigGroup)) continue;
                ((ButtonConfigGroup)w).setCollapsed(false);
            }
            this.scroll.setValue(0.0);
            gui.refreshWidgets();
        });
    }

    @Override
    public void onInit() {
        this.setWidth(this.getScreen().func_78326_a());
        this.setHeight(this.getScreen().func_78328_b());
    }

    @Override
    public void updateWidgetPositions() {
        this.buttonAccept.posX = this.width - 18;
        this.buttonCancel.posX = this.width - 38;
        this.buttonExpandAll.posX = this.width - 58;
        this.buttonCollapseAll.posX = this.width - 78;
        this.configPanel.setHeight(this.height - 20);
        this.configPanel.setWidth(this.width);
        this.scroll.posX = this.width - 16;
        this.scroll.setHeight(this.configPanel.height);
        for (Widget b : this.configEntryButtons) {
            b.setWidth(this.scroll.posX);
        }
    }

    @Override
    public void addWidgets() {
        this.addAll(this.buttonAccept, this.buttonCancel, this.buttonCollapseAll, this.buttonExpandAll);
        this.addAll(this.configPanel, this.scroll);
    }

    @Override
    public void onClosed() {
        if (this.shouldClose == 1 && !this.modifiedConfig.entrySet().isEmpty()) {
            this.callback.saveConfig(this.group, (ICommandSender)ClientUtils.MC.field_71439_g, this.modifiedConfig);
        }
    }

    @Override
    public boolean onClosedByKey() {
        this.buttonCancel.onClicked(MouseButton.LEFT);
        return false;
    }

    @Override
    public void onChanged(String key, JsonElement val) {
        this.modifiedConfig.add(key, val);
    }

    @Override
    public void drawBackground() {
        COLOR_BACKGROUND.draw(0, 0, this.width, 20);
        this.drawString(this.getTitle(), 6, 6, Color4I.DARK_GRAY, 0);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public class ButtonConfigEntry
    extends Button {
        public final ButtonConfigGroup group;
        public final ConfigValueInfo info;
        public final ConfigValue value;
        public String keyText;
        public List<String> infoText;

        public ButtonConfigEntry(GuiEditConfig gui, ButtonConfigGroup g, ConfigValueInfo i, ConfigValue e) {
            String infoText;
            super(gui, 0, 0, 0, 16);
            this.group = g;
            this.info = i;
            this.value = e;
            String keyLang = gui.group.getNameKey(this.info);
            this.keyText = StringUtils.translate(keyLang);
            String string = infoText = StringUtils.canTranslate(keyLang + ".tooltip") ? StringUtils.translate(keyLang + ".tooltip") : "";
            if (!infoText.isEmpty()) {
                this.infoText = new ArrayList<String>();
                for (String s : infoText.split("\\\\n")) {
                    this.infoText.addAll(gui.listFormattedStringToWidth(s, 230));
                }
            }
            if (this.infoText == null || this.infoText.isEmpty()) {
                this.infoText = Collections.emptyList();
            }
        }

        @Override
        public void renderWidget() {
            Color4I col;
            boolean mouseOver = this.gui.getMouseY() >= 20 && this.gui.isMouseOver(this);
            int ax = this.getAX();
            int ay = this.getAY();
            if (mouseOver) {
                Color4I.WHITE_A[33].draw(ax, ay, this.width, this.height);
            }
            this.gui.drawString(this.keyText, ax + 4, ay + 4, Bits.setFlag(0, 2, mouseOver));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String s = this.value.hasCustomName() ? this.value.getCustomDisplayName().func_150254_d() : this.value.getString();
            int slen = this.gui.getStringWidth(s);
            if (slen > 150) {
                s = this.gui.trimStringToWidth(s, 150, false) + "...";
                slen = 152;
            }
            if ((col = this.value.getCustomColor()).isEmpty()) {
                col = this.value.getColor();
            }
            MutableColor4I textCol = col.mutable();
            textCol.setAlpha(255);
            if (mouseOver) {
                textCol.addBrightness(60);
                if (this.gui.getMouseX() > ax + this.width - slen - 9) {
                    Color4I.WHITE_A[33].draw(ax + this.width - slen - 8, ay, slen + 8, this.height);
                }
            }
            this.gui.drawString(s, this.gui.width - (slen + 20), ay + 4, textCol, 0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            if (this.gui.getMouseY() >= 20 && !this.info.cantEdit) {
                GuiHelper.playClickSound();
                this.value.onClicked(GuiEditConfig.this, this.info, button);
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            if (this.gui.getMouseY() > 18) {
                if (!this.infoText.isEmpty() && this.gui.getMouseX() < this.getAX() + this.gui.getStringWidth(this.keyText) + 10) {
                    list.addAll(this.infoText);
                }
                if (this.gui.getMouseX() > this.gui.width - (Math.min(150, this.gui.getStringWidth(this.value.getString())) + 25)) {
                    this.value.addInfo(this.info, list);
                }
            }
        }
    }

    public class ButtonConfigGroup
    extends Button {
        public final String groupId;
        public String title;
        public String info;
        public boolean collapsed;

        public ButtonConfigGroup(GuiBase gui, String id) {
            super(gui, 0, 0, 0, 16);
            this.title = "-";
            this.info = "";
            this.collapsed = false;
            this.groupId = id;
            if (!this.groupId.isEmpty()) {
                StringBuilder current = new StringBuilder();
                StringBuilder text = new StringBuilder();
                String[] sa = this.groupId.split("\\.");
                for (int i = 0; i < sa.length; ++i) {
                    if (i != 0) {
                        current.append(".");
                    }
                    current.append(sa[i]);
                    String key = current.toString();
                    text.append(GuiEditConfig.this.group.getGroupName(key).func_150254_d());
                    if (i == sa.length - 1) continue;
                    text.append(" > ");
                }
                this.title = text.toString();
                text.setLength(0);
                text.append(this.groupId);
                text.append(".info");
                String infoKey = text.toString();
                if (StringUtils.canTranslate(infoKey)) {
                    this.info = StringUtils.translate(infoKey);
                }
            }
            this.setCollapsed(this.collapsed);
        }

        public void setCollapsed(boolean v) {
            this.collapsed = v;
            this.setTitle((this.collapsed ? TextFormatting.RED + "[-] " : TextFormatting.GREEN + "[v] ") + TextFormatting.RESET + this.title);
        }

        @Override
        public void renderWidget() {
            int ax = this.getAX();
            int ay = this.getAY();
            COLOR_BACKGROUND.draw(ax, ay, this.width, this.height);
            this.gui.drawString(this.getTitle(), ax + 3, ay + 4);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.gui.isMouseOver(this)) {
                Color4I.WHITE_A[33].draw(ax, ay, this.width, this.height);
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            if (!this.info.isEmpty()) {
                list.add(this.info);
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            this.setCollapsed(!this.collapsed);
            this.gui.refreshWidgets();
        }
    }
}

