/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.ISidebarButton;
import com.feed_the_beast.ftbl.api.ISidebarButtonGroup;
import com.feed_the_beast.ftbl.client.FTBLibModClient;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import java.util.List;

public class GuiSidebarButtonConfig
extends GuiButtonListBase {
    private static final Color4I COLOR_ENABLED = Color4I.rgba(1430765377);
    private static final Color4I COLOR_UNAVAILABLE = Color4I.rgba(1426101503);
    private static final Color4I COLOR_DISABLED = Color4I.rgba(1438401090);

    public GuiSidebarButtonConfig() {
        this.setTitle(StringUtils.translate("sidebar_button"));
    }

    @Override
    public void addButtons(Panel panel) {
        for (ISidebarButtonGroup group : FTBLibAPI.API.getSidebarButtonGroups()) {
            for (ISidebarButton button : group.getButtons()) {
                if (button.getDefaultConfig() == null) continue;
                panel.add(new ButtonConfigSidebarButton(this.gui, button));
            }
        }
    }

    @Override
    public void onClosed() {
        FTBLibModClient.saveSidebarButtonConfig();
    }

    private class ButtonConfigSidebarButton
    extends SimpleTextButton {
        private final ISidebarButton sidebarButton;
        private String tooltip;

        public ButtonConfigSidebarButton(GuiBase gui, ISidebarButton s) {
            super(gui, 0, 0, StringUtils.translate("sidebar_button." + s.func_176610_l()), s.getIcon());
            this.tooltip = "";
            this.sidebarButton = s;
            if (StringUtils.canTranslate("sidebar_button." + s.func_176610_l() + ".tooltip")) {
                this.tooltip = StringUtils.translate("sidebar_button." + s.func_176610_l() + ".tooltip");
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            list.add((this.sidebarButton.getConfig() ? GuiLang.ENABLED : GuiLang.DISABLED).translate());
            if (!this.tooltip.isEmpty()) {
                list.add(this.tooltip);
            }
        }

        @Override
        public Icon getButtonBackground() {
            return super.getButtonBackground().combineWith((Icon)(this.sidebarButton.getConfig() ? (this.sidebarButton.isAvailable() ? COLOR_ENABLED : COLOR_UNAVAILABLE) : COLOR_DISABLED));
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            this.sidebarButton.setConfig(!this.sidebarButton.getConfig());
        }
    }
}

