/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.ISidebarButton;
import com.feed_the_beast.ftbl.api.ISidebarButtonGroup;
import com.feed_the_beast.ftbl.client.EnumSidebarButtonPlacement;
import com.feed_the_beast.ftbl.client.FTBLibClientConfig;
import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.FinalIDObject;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.event.ClickEvent;

public class SidebarButton
extends FinalIDObject
implements ISidebarButton {
    private final ISidebarButtonGroup group;
    private Icon icon = Icon.EMPTY;
    private int x = 0;
    private Boolean defaultConfig = null;
    private boolean configValue = true;
    private final List<String> requiredServerMods = new ArrayList<String>();
    private final List<ClickEvent> clickEvents = new ArrayList<ClickEvent>();
    private final List<ClickEvent> shiftClickEvents = new ArrayList<ClickEvent>();
    private boolean requiresOp;
    private boolean hideWithNEI;
    private boolean loadingScreen;
    private boolean customText;

    public SidebarButton(ResourceLocation id, ISidebarButtonGroup g, JsonObject json) {
        super(id.toString().replace(':', '.'));
        this.group = g;
        if (json.has("icon")) {
            this.icon = Icon.getIcon(json.get("icon"));
        }
        if (this.icon.isEmpty()) {
            this.icon = GuiIcons.ACCEPT_GRAY;
        }
        if (json.has("click")) {
            for (JsonElement e : JsonUtils.toArray(json.get("click"))) {
                this.clickEvents.add(JsonUtils.deserializeClickEvent(e));
            }
        }
        if (json.has("shift_click")) {
            for (JsonElement e : JsonUtils.toArray(json.get("shift_click"))) {
                this.shiftClickEvents.add(JsonUtils.deserializeClickEvent(e));
            }
        }
        if (json.has("config")) {
            this.configValue = json.get("config").getAsBoolean();
            this.defaultConfig = this.configValue;
        }
        if (json.has("required_server_mods")) {
            for (JsonElement e : JsonUtils.toArray(json.get("required_server_mods"))) {
                this.requiredServerMods.add(e.getAsString());
            }
        }
        if (json.has("x")) {
            this.x = json.get("x").getAsInt();
        }
        this.requiresOp = json.has("requires_op") && json.get("requires_op").getAsBoolean();
        this.hideWithNEI = json.has("hide_with_nei") && json.get("hide_with_nei").getAsBoolean();
        this.loadingScreen = json.has("loading_screen") && json.get("loading_screen").getAsBoolean();
        this.customText = json.has("custom_text") && json.get("custom_text").getAsBoolean();
    }

    @Override
    public ISidebarButtonGroup getGroup() {
        return this.group;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    @Nullable
    public Boolean getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public void onClicked(boolean shift) {
        if (this.loadingScreen) {
            new GuiLoading().openGui();
        }
        for (ClickEvent event : shift ? this.shiftClickEvents : this.clickEvents) {
            GuiHelper.onClickEvent(event);
        }
    }

    @Override
    public boolean isVisible() {
        return this.configValue && FTBLibClientConfig.general.action_buttons != EnumSidebarButtonPlacement.DISABLED && this.isAvailable();
    }

    @Override
    public boolean isAvailable() {
        return !(this.hideWithNEI && CommonUtils.isNEILoaded() || this.requiresOp && !ClientUtils.isClientOP() || !this.requiredServerMods.isEmpty() && !FTBLibAPI.API.getClientData().optionalServerMods().containsAll(this.requiredServerMods));
    }

    @Override
    public boolean hasCustomText() {
        return this.customText;
    }

    @Override
    public boolean getConfig() {
        return this.configValue;
    }

    @Override
    public void setConfig(boolean value) {
        this.configValue = value;
    }
}

