/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client;

import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.client.PixelBuffer;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbl.lib.util.ColorUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;

public class ThreadReloadChunkSelector
extends Thread {
    private static ByteBuffer pixelBuffer = null;
    private static final int PIXEL_SIZE = 256;
    private static final PixelBuffer PIXELS = new PixelBuffer(256, 256);
    private static final Map<IBlockState, Integer> COLOR_CACHE = new HashMap<IBlockState, Integer>();
    private static final BlockPos.MutableBlockPos CURRENT_BLOCK_POS = new BlockPos.MutableBlockPos(0, 0, 0);
    private static World world = null;
    private static final Function<IBlockState, Integer> COLOR_GETTER = state1 -> 0xFF000000 | ThreadReloadChunkSelector.getBlockColor0(state1, (IBlockAccess)world, (BlockPos)CURRENT_BLOCK_POS);
    private static ThreadReloadChunkSelector instance;
    private static int textureID;
    private static final int[] HEIGHT_MAP;
    private final int startX;
    private final int startZ;
    private boolean cancelled = false;

    static int getTextureId() {
        if (textureID == -1) {
            textureID = TextureUtil.func_110996_a();
        }
        return textureID;
    }

    static void updateTexture() {
        if (pixelBuffer != null) {
            GlStateManager.func_179144_i((int)ThreadReloadChunkSelector.getTextureId());
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)256, (int)256, (int)0, (int)6408, (int)5121, (ByteBuffer)pixelBuffer);
            pixelBuffer = null;
        }
    }

    static void reloadArea(World w, int sx, int sz) {
        if (instance != null) {
            ThreadReloadChunkSelector.instance.cancelled = true;
            instance = null;
        }
        instance = new ThreadReloadChunkSelector(w, sx, sz);
        ThreadReloadChunkSelector.instance.cancelled = false;
        instance.start();
        COLOR_CACHE.clear();
    }

    private ThreadReloadChunkSelector(World w, int sx, int sz) {
        super("ChunkSelectorAreaReloader");
        this.setDaemon(true);
        world = w;
        this.startX = sx;
        this.startZ = sz;
    }

    private static int getBlockColor0(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block b = state.func_177230_c();
        if (b == Blocks.field_150322_A) {
            return MapColor.field_151658_d.field_76291_p;
        }
        if (b == Blocks.field_150480_ab) {
            return MapColor.field_151645_D.field_76291_p;
        }
        if (b == Blocks.field_150327_N) {
            return MapColor.field_151673_t.field_76291_p;
        }
        if (b == Blocks.field_150353_l) {
            return MapColor.field_151676_q.field_76291_p;
        }
        if (b == Blocks.field_150377_bs) {
            return MapColor.field_151658_d.field_76291_p;
        }
        if (b == Blocks.field_150343_Z) {
            return 1376327;
        }
        if (b == Blocks.field_150351_n) {
            return 9279387;
        }
        if (b == Blocks.field_150349_c) {
            return 0x549954;
        }
        if (b == Blocks.field_150478_aa) {
            return 16753968;
        }
        if (b == Blocks.field_150424_aL || b == Blocks.field_150449_bY) {
            return 8327969;
        }
        if (b == Blocks.field_150328_O) {
            switch ((BlockFlower.EnumFlowerType)state.func_177229_b(Blocks.field_150328_O.func_176494_l())) {
                case DANDELION: {
                    return MapColor.field_151673_t.field_76291_p;
                }
                case POPPY: {
                    return MapColor.field_151645_D.field_76291_p;
                }
                case BLUE_ORCHID: {
                    return MapColor.field_151674_s.field_76291_p;
                }
                case ALLIUM: {
                    return MapColor.field_151675_r.field_76291_p;
                }
                case HOUSTONIA: {
                    return MapColor.field_151680_x.field_76291_p;
                }
                case RED_TULIP: {
                    return MapColor.field_151645_D.field_76291_p;
                }
                case ORANGE_TULIP: {
                    return MapColor.field_151676_q.field_76291_p;
                }
                case WHITE_TULIP: {
                    return MapColor.field_151666_j.field_76291_p;
                }
                case PINK_TULIP: {
                    return MapColor.field_151671_v.field_76291_p;
                }
                case OXEYE_DAISY: {
                    return MapColor.field_151680_x.field_76291_p;
                }
            }
        } else if (b == Blocks.field_150344_f) {
            switch ((BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockPlanks.field_176383_a)) {
                case OAK: {
                    return 13015113;
                }
                case SPRUCE: {
                    return 8150574;
                }
                case BIRCH: {
                    return 15917203;
                }
                case JUNGLE: {
                    return 13006419;
                }
                case ACACIA: {
                    return 14712638;
                }
                case DARK_OAK: {
                    return 5319956;
                }
            }
        }
        return state.func_185909_g((IBlockAccess)world, (BlockPos)pos).field_76291_p;
    }

    private static int getHeight(int x, int z) {
        int index = x + z * 256;
        return index < 0 || index >= HEIGHT_MAP.length ? -1 : HEIGHT_MAP[index];
    }

    @Override
    public void run() {
        Arrays.fill(PIXELS.getPixels(), 0);
        Arrays.fill(HEIGHT_MAP, -1);
        pixelBuffer = ColorUtils.toByteBuffer(PIXELS.getPixels(), false);
        int startY = ClientUtils.MC.field_71439_g.func_180425_c().func_177956_o();
        try {
            IBlockState state;
            int by;
            int wz;
            int wx;
            int wi;
            int z;
            int x;
            Chunk chunk;
            int cx;
            int cz;
            for (cz = 0; cz < 15; ++cz) {
                for (cx = 0; cx < 15; ++cx) {
                    chunk = world.func_72863_F().func_186026_b(this.startX + cx, this.startZ + cz);
                    if (chunk == null) continue;
                    x = this.startX + cx << 4;
                    z = this.startZ + cz << 4;
                    int topY = ThreadReloadChunkSelector.world.field_73011_w.getDimension() == -1 ? startY + 5 : Math.max(world.func_72940_L(), chunk.func_76625_h() + 15);
                    block4: for (wi = 0; wi < 256; ++wi) {
                        wx = wi % 16;
                        wz = wi / 16;
                        for (by = topY; by > 0; --by) {
                            if (this.cancelled) {
                                return;
                            }
                            CURRENT_BLOCK_POS.func_181079_c(x + wx, by, z + wz);
                            state = chunk.func_186032_a(wx, by, wz);
                            if (state.func_177230_c() == Blocks.field_150329_H || state.func_177230_c().isAir(state, (IBlockAccess)world, (BlockPos)CURRENT_BLOCK_POS)) continue;
                            ThreadReloadChunkSelector.HEIGHT_MAP[cx * 16 + wx + (cz * 16 + wz) * 256] = by;
                            continue block4;
                        }
                    }
                }
            }
            for (cz = 0; cz < 15; ++cz) {
                for (cx = 0; cx < 15; ++cx) {
                    chunk = world.func_72863_F().func_186026_b(this.startX + cx, this.startZ + cz);
                    if (chunk != null) {
                        x = this.startX + cx << 4;
                        z = this.startZ + cz << 4;
                        for (wi = 0; wi < 256; ++wi) {
                            wx = wi % 16;
                            wz = wi / 16;
                            by = ThreadReloadChunkSelector.getHeight(cx * 16 + wx, cz * 16 + wz);
                            if (by < 0) continue;
                            CURRENT_BLOCK_POS.func_181079_c(x + wx, by, z + wz);
                            state = chunk.func_186032_a(wx, by, wz);
                            int color = ColorUtils.addBrightness(COLOR_CACHE.computeIfAbsent(state, COLOR_GETTER), MathUtils.RAND.nextFloat() * 0.04f);
                            int bn = ThreadReloadChunkSelector.getHeight(cx * 16 + wx, cz * 16 + wz - 1);
                            int bw = ThreadReloadChunkSelector.getHeight(cx * 16 + wx - 1, cz * 16 + wz);
                            if (by > bn && bn != -1 || by > bw && bw != -1) {
                                color = ColorUtils.addBrightness(color, 0.1f);
                            }
                            if (by < bn && bn != -1 || by < bw && bw != -1) {
                                color = ColorUtils.addBrightness(color, -0.1f);
                            }
                            PIXELS.setRGB(cx * 16 + wx, cz * 16 + wz, color);
                        }
                    }
                    pixelBuffer = ColorUtils.toByteBuffer(PIXELS.getPixels(), false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pixelBuffer = ColorUtils.toByteBuffer(PIXELS.getPixels(), false);
        world = null;
        instance = null;
    }

    static {
        textureID = -1;
        HEIGHT_MAP = new int[65536];
    }
}

