/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client.teamsgui;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftbl.lib.gui.TextBox;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class GuiCreateTeam
extends GuiBase {
    private EnumTeamColor color = EnumTeamColor.NAME_MAP.getRandom(MathUtils.RAND);
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final List<Button> colorButtons;
    private final TextBox textBoxId;

    public GuiCreateTeam() {
        super(162, 118);
        int bwidth = this.width / 2 - 10;
        this.buttonAccept = new SimpleTextButton(this, this.width - bwidth - 9, this.height - 24, GuiLang.ACCEPT.translate(), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                if (!GuiCreateTeam.this.textBoxId.getText().isEmpty()) {
                    this.gui.closeGui(false);
                    ClientUtils.execClientCommand("/ftb team create " + GuiCreateTeam.this.textBoxId.getText() + " " + GuiCreateTeam.this.color.func_176610_l());
                }
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setWidth(bwidth);
        this.buttonAccept.setHeight(16);
        this.buttonCancel = new SimpleTextButton(this, 8, this.height - 24, GuiLang.CANCEL.translate(), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                this.gui.closeGui();
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setWidth(bwidth);
        this.buttonCancel.setHeight(16);
        this.textBoxId = new TextBox(this, 8, 8, this.width - 16, 16){

            @Override
            public void onTextChanged() {
                this.setText(StringUtils.getId(this.getText(), 14), false);
            }
        };
        this.textBoxId.writeText(ClientUtils.MC.field_71439_g.func_146103_bH().getName().toLowerCase());
        this.textBoxId.ghostText = TextFormatting.ITALIC.toString() + TextFormatting.DARK_GRAY + "Enter ID";
        this.textBoxId.textColor = this.color.getColor();
        this.textBoxId.setFocused(true);
        this.textBoxId.charLimit = 35;
        this.colorButtons = new ArrayList<Button>();
        int i = 0;
        for (final EnumTeamColor col : EnumTeamColor.NAME_MAP) {
            Button b = new Button(this, 8 + i % 5 * 30, 32 + i / 5 * 30, 25, 25){

                @Override
                public void onClicked(MouseButton button) {
                    GuiCreateTeam.this.color = col;
                    ((GuiCreateTeam)GuiCreateTeam.this).textBoxId.textColor = GuiCreateTeam.this.color.getColor();
                }

                @Override
                public Icon getIcon() {
                    return GuiCreateTeam.this.getTheme().getGui(false).withTint(col.getColor().mutable().setAlpha(GuiCreateTeam.this.color == col || this.gui.isMouseOver(this) ? 200 : 100));
                }
            };
            b.setTitle(col.getTextFormatting() + col.getLangKey().translate());
            this.colorButtons.add(b);
            ++i;
        }
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.addAll(this.colorButtons);
        this.add(this.textBoxId);
    }
}

