/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client.teamsgui;

import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api_impl.FTBLibTeamGuiActions;
import com.feed_the_beast.ftbl.client.teamsgui.GuiManagePlayersBase;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.util.ColorUtils;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbl.net.MessageMyTeamAction;
import com.feed_the_beast.ftbl.net.MessageMyTeamPlayerList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class GuiManageMembers
extends GuiManagePlayersBase {
    public GuiManageMembers(Collection<MessageMyTeamPlayerList.Entry> m) {
        super(FTBLibLang.TEAM_GUI_MEMBERS.translate(), m, (x$0, x$1) -> new ButtonPlayer((GuiBase)x$0, (MessageMyTeamPlayerList.Entry)x$1));
    }

    private static class ButtonPlayer
    extends GuiManagePlayersBase.ButtonPlayerBase {
        private ButtonPlayer(GuiBase gui, MessageMyTeamPlayerList.Entry m) {
            super(gui, m);
        }

        @Override
        Color4I getPlayerColor() {
            if (this.entry.requestingInvite) {
                return ColorUtils.getChatFormattingColor(TextFormatting.GOLD.ordinal());
            }
            switch (this.entry.status) {
                case NONE: {
                    return this.getDefaultPlayerColor();
                }
                case MEMBER: 
                case MOD: {
                    return ColorUtils.getChatFormattingColor(TextFormatting.DARK_GREEN.ordinal());
                }
                case INVITED: {
                    return ColorUtils.getChatFormattingColor(TextFormatting.BLUE.ordinal());
                }
                case ALLY: {
                    return ColorUtils.getChatFormattingColor(TextFormatting.DARK_AQUA.ordinal());
                }
            }
            return this.getDefaultPlayerColor();
        }

        @Override
        public void addMouseOverText(List<String> list) {
            if (!this.entry.status.isNone()) {
                list.add(this.entry.status.getLangKey().translate());
            } else if (this.entry.requestingInvite) {
                list.add(FTBLibLang.TEAM_GUI_REQUESTING_INVITE.translate());
            }
            if (this.entry.requestingInvite) {
                list.add(FTBLibLang.TEAM_GUI_MEMBERS_REQUESTING_INVITE.translate());
            } else if (this.entry.status.isEqualOrGreaterThan(EnumTeamStatus.MEMBER)) {
                list.add(FTBLibLang.TEAM_GUI_MEMBERS_KICK.translate());
            } else if (this.entry.status == EnumTeamStatus.INVITED) {
                list.add(FTBLibLang.TEAM_GUI_MEMBERS_CANCEL_INVITE.translate());
            }
            if (this.entry.status == EnumTeamStatus.NONE || this.entry.requestingInvite) {
                list.add(FTBLibLang.TEAM_GUI_MEMBERS_INVITE.translate());
            }
            if (this.entry.requestingInvite) {
                list.add(FTBLibLang.TEAM_GUI_MEMBERS_DENY_REQUEST.translate());
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("player", this.entry.name);
            if (this.entry.requestingInvite) {
                if (button.isLeft()) {
                    data.func_74778_a("action", "invite");
                    this.entry.status = EnumTeamStatus.MEMBER;
                } else {
                    data.func_74778_a("action", "deny_request");
                    this.entry.status = EnumTeamStatus.NONE;
                }
                this.entry.requestingInvite = false;
            } else if (this.entry.status == EnumTeamStatus.NONE) {
                data.func_74778_a("action", "invite");
                this.entry.status = EnumTeamStatus.INVITED;
            } else if (this.entry.status.isEqualOrGreaterThan(EnumTeamStatus.MEMBER)) {
                if (!button.isLeft()) {
                    data.func_74778_a("action", "kick");
                    this.entry.requestingInvite = true;
                    this.entry.status = EnumTeamStatus.NONE;
                }
            } else if (this.entry.status == EnumTeamStatus.INVITED && !button.isLeft()) {
                data.func_74778_a("action", "cancel_invite");
                this.entry.status = EnumTeamStatus.NONE;
            }
            if (data.func_74764_b("action")) {
                new MessageMyTeamAction(FTBLibTeamGuiActions.MEMBERS.getId(), data).sendToServer();
            }
            this.updateIcon();
        }
    }
}

