/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client.teamsgui;

import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.icon.PlayerHeadIcon;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbl.net.MessageMyTeamPlayerList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;

public class GuiManagePlayersBase
extends GuiButtonListBase {
    static final Comparator<MessageMyTeamPlayerList.Entry> COMPARATOR = (o1, o2) -> {
        int o2s;
        int o1s = o1.getSortIndex();
        return o1s == (o2s = o2.getSortIndex()) ? o1.name.compareToIgnoreCase(o2.name) : o2s - o1s;
    };
    private final List<MessageMyTeamPlayerList.Entry> entries;
    private final BiFunction<GuiBase, MessageMyTeamPlayerList.Entry, ButtonPlayerBase> buttonFunction;

    public GuiManagePlayersBase(String title, Collection<MessageMyTeamPlayerList.Entry> m, BiFunction<GuiBase, MessageMyTeamPlayerList.Entry, ButtonPlayerBase> b) {
        this.setTitle(title);
        this.entries = new ArrayList<MessageMyTeamPlayerList.Entry>(m);
        this.buttonFunction = b;
    }

    @Override
    public void addButtons(Panel panel) {
        this.entries.sort(COMPARATOR);
        for (MessageMyTeamPlayerList.Entry m : this.entries) {
            panel.add(this.buttonFunction.apply(this, m));
        }
    }

    static class ButtonPlayerBase
    extends SimpleTextButton {
        final MessageMyTeamPlayerList.Entry entry;

        ButtonPlayerBase(GuiBase gui, MessageMyTeamPlayerList.Entry m) {
            super(gui, 0, 0, "", Icon.EMPTY);
            this.entry = m;
            this.updateIcon();
            this.setTitle(this.entry.name);
        }

        Color4I getPlayerColor() {
            return this.getDefaultPlayerColor();
        }

        Color4I getDefaultPlayerColor() {
            return Color4I.GRAY;
        }

        final void updateIcon() {
            this.setIcon(new PlayerHeadIcon(this.entry.name).withOutline(this.getPlayerColor(), false).withOutline(Color4I.DARK_GRAY, true).withBorder(2));
        }

        @Override
        public void addMouseOverText(List<String> list) {
        }

        @Override
        public void onClicked(MouseButton button) {
        }
    }
}

