/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client.teamsgui;

import com.feed_the_beast.ftbl.client.teamsgui.GuiCreateTeam;
import com.feed_the_beast.ftbl.client.teamsgui.PublicTeamData;
import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.icon.PlayerHeadIcon;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GuiSelectTeam
extends GuiBase {
    private final Panel panelTeams;
    private final PanelScrollBar scrollTeams;

    public GuiSelectTeam(Collection<PublicTeamData> teams0) {
        super(192, 170);
        final ArrayList<PublicTeamData> teams = new ArrayList<PublicTeamData>(teams0);
        teams.sort(null);
        this.panelTeams = new Panel(this, 0, 1, 168, 168){

            @Override
            public void addWidgets() {
                this.add(new ButtonCreateTeam(this.gui));
                for (PublicTeamData t : teams) {
                    this.add(new ButtonTeam(this.gui, t));
                }
            }

            @Override
            public void updateWidgetPositions() {
                int size = 8;
                int x = 0;
                for (Widget widget : this.widgets) {
                    widget.setX(8 + x * 40);
                    widget.setY(size);
                    if (++x != 4) continue;
                    x = 0;
                    size += 40;
                }
                GuiSelectTeam.this.scrollTeams.setElementSize(size);
            }
        };
        this.panelTeams.addFlags(3);
        this.scrollTeams = new PanelScrollBar(this, 168, 8, 16, 152, 0, this.panelTeams){

            @Override
            public boolean shouldRender() {
                return true;
            }
        };
    }

    @Override
    public void addWidgets() {
        this.add(this.panelTeams);
        this.add(this.scrollTeams);
    }

    private static class ButtonTeam
    extends Button {
        private final PublicTeamData team;
        private final Icon background;
        private static final Color4I INVITED_COLOR = Color4I.rgba(1713414955);

        private ButtonTeam(GuiBase gui, PublicTeamData t) {
            super(gui, 0, 0, 32, 32);
            this.team = t;
            this.setTitle(this.team.color.getTextFormatting() + this.team.displayName);
            this.setIcon(new PlayerHeadIcon(t.ownerName));
            this.background = this.team.isInvited ? INVITED_COLOR : Icon.EMPTY.withOutline(this.team.color.getColor(), true);
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            if (this.team.isInvited) {
                ClientUtils.execClientCommand("/ftb team join " + this.team.func_176610_l());
            } else {
                ClientUtils.execClientCommand("/ftb team request_invite " + this.team.func_176610_l());
            }
            this.gui.closeGui();
        }

        @Override
        public void addMouseOverText(List<String> list) {
            list.add(this.getTitle());
            list.add("ID: " + this.team.func_176610_l());
            if (!this.team.description.isEmpty()) {
                list.add("");
                list.add(this.team.description);
            }
            list.add("");
            list.add("Click to " + (this.team.isInvited ? "join the team" : "request invite to this team"));
        }

        @Override
        public void renderWidget() {
            int ax = this.getAX();
            int ay = this.getAY();
            this.getButtonBackground().draw(ax, ay, this.width, this.height);
            this.background.draw(ax + 6, ay + 6, 20, 20);
            this.getIcon().draw(ax + 8, ay + 8, 16, 16);
        }
    }

    private static class ButtonCreateTeam
    extends Button {
        private ButtonCreateTeam(GuiBase gui) {
            super(gui, 0, 0, 32, 32);
            this.setTitle("Create a New Team");
            this.setIcon(GuiIcons.ADD);
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new GuiCreateTeam().openGui();
        }

        @Override
        public void renderWidget() {
            int ax = this.getAX();
            int ay = this.getAY();
            this.getButtonBackground().draw(ax, ay, 32, 32);
            this.getIcon().draw(ax + 8, ay + 8, 16, 16);
        }
    }
}

