/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client.teamsgui;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.util.FinalIDObject;
import java.util.UUID;

public class PublicTeamData
extends FinalIDObject
implements Comparable<PublicTeamData> {
    public static final DataOut.Serializer<PublicTeamData> SERIALIZER = (data, d) -> {
        data.writeString(d.func_176610_l());
        data.writeString(d.displayName);
        data.writeString(d.description);
        data.write(EnumTeamColor.NAME_MAP, d.color);
        data.writeUUID(d.ownerId);
        data.writeString(d.ownerName);
        data.writeBoolean(d.isInvited);
    };
    public static final DataIn.Deserializer<PublicTeamData> DESERIALIZER = PublicTeamData::new;
    public final String displayName;
    public final String description;
    public final EnumTeamColor color;
    public final UUID ownerId;
    public final String ownerName;
    public final boolean isInvited;

    public PublicTeamData(DataIn data) {
        super(data.readString());
        this.displayName = data.readString();
        this.description = data.readString();
        this.color = data.read(EnumTeamColor.NAME_MAP);
        this.ownerId = data.readUUID();
        this.ownerName = data.readString();
        this.isInvited = data.readBoolean();
    }

    public PublicTeamData(IForgeTeam team, boolean c) {
        super(team.func_176610_l());
        this.displayName = team.getTitle();
        this.description = team.getDesc();
        this.color = team.getColor();
        this.ownerId = team.getOwner().getId();
        this.ownerName = team.getOwner().func_176610_l();
        this.isInvited = c;
    }

    @Override
    public int compareTo(PublicTeamData o) {
        int i = Boolean.compare(o.isInvited, this.isInvited);
        if (i == 0) {
            i = this.displayName.compareToIgnoreCase(o.displayName);
        }
        return i;
    }
}

