/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.cmd.team;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.team.ForgeTeamCreatedEvent;
import com.feed_the_beast.ftbl.api.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftbl.api_impl.ForgeTeam;
import com.feed_the_beast.ftbl.api_impl.Universe;
import com.feed_the_beast.ftbl.lib.cmd.CmdBase;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.net.MessageMyTeamGui;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class CmdCreate
extends CmdBase {
    public CmdCreate() {
        super("create", CmdBase.Level.ALL);
    }

    private static boolean isValidTeamID(String s) {
        if (!s.isEmpty()) {
            for (int i = 0; i < s.length(); ++i) {
                if (CmdCreate.isValidChar(s.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isValidChar(char c) {
        return c == '_' || c == '|' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = CmdCreate.func_71521_c((ICommandSender)sender);
        IForgePlayer p = CmdCreate.getForgePlayer((ICommandSender)player);
        if (p.getTeam() != null) {
            throw FTBLibLang.TEAM_MUST_LEAVE.commandError(new Object[0]);
        }
        this.checkArgs(sender, args, 1);
        if (!CmdCreate.isValidTeamID(args[0])) {
            throw FTBLibLang.TEAM_ID_INVALID.commandError(new Object[0]);
        }
        if (FTBLibAPI.API.getUniverse().getTeam(args[0]) != null) {
            throw FTBLibLang.TEAM_ID_ALREADY_EXISTS.commandError(new Object[0]);
        }
        ForgeTeam team = new ForgeTeam(args[0]);
        if (args.length > 1) {
            team.setColor(EnumTeamColor.NAME_MAP.get(args[1]));
        }
        Universe.INSTANCE.teams.put(team.func_176610_l(), team);
        p.setTeamId(team.func_176610_l());
        team.setStatus(p, EnumTeamStatus.OWNER);
        new ForgeTeamCreatedEvent(team).post();
        new ForgeTeamPlayerJoinedEvent(team, p).post();
        FTBLibLang.TEAM_CREATED.sendMessage(sender, team.func_176610_l());
        new MessageMyTeamGui(team, p).sendTo((EntityPlayer)player);
    }
}

