/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.client;

import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.PlayerHeadIcon;
import com.feed_the_beast.ftbl.lib.util.misc.NameMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ModelLoader;

public class ClientUtils {
    public static final Minecraft MC = Minecraft.func_71410_x();
    public static final Frustum FRUSTUM = new Frustum();
    public static final Map<String, ResourceLocation> CACHED_SKINS = new HashMap<String, ResourceLocation>();
    public static final Function<ResourceLocation, TextureAtlasSprite> DEFAULT_TEXTURE_GETTER = location -> MC.func_147117_R().func_174942_a(location);
    public static final NameMap<EnumBlockRenderType> BLOCK_RENDER_TYPE_NAME_MAP = NameMap.create(EnumBlockRenderType.MODEL, EnumBlockRenderType.values());
    public static final NameMap<BlockRenderLayer> BLOCK_RENDER_LAYER_NAME_MAP = NameMap.create(BlockRenderLayer.SOLID, BlockRenderLayer.values());
    public static final Map<ResourceLocation, TextureAtlasSprite> SPRITE_MAP = new HashMap<ResourceLocation, TextureAtlasSprite>();
    public static boolean isFirstPerson;
    public static int currentDim;
    public static int playerPosHash;
    public static double playerX;
    public static double playerY;
    public static double playerZ;
    public static double renderX;
    public static double renderY;
    public static double renderZ;
    private static float lastBrightnessX;
    private static float lastBrightnessY;
    private static EntityItem entityItem;
    public static PlayerHeadIcon localPlayerHead;

    public static void registerModel(Object _item, int meta, String variant) {
        Item item = _item instanceof Item ? (Item)_item : Item.func_150898_a((Block)((Block)_item));
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)(variant.indexOf(35) != -1 ? new ModelResourceLocation(variant) : new ModelResourceLocation(item.getRegistryName(), variant)));
    }

    public static void registerModel(Object _item) {
        ClientUtils.registerModel(_item, 0, "inventory");
    }

    public static int getDim() {
        return ClientUtils.MC.field_71441_e != null ? ClientUtils.MC.field_71441_e.field_73011_w.getDimension() : 0;
    }

    public static void spawnParticle(Particle e) {
        ClientUtils.MC.field_71452_i.func_78873_a(e);
    }

    public static void pushBrightness(int u, int t) {
        lastBrightnessX = OpenGlHelper.lastBrightnessX;
        lastBrightnessY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)u, (float)t);
    }

    public static void pushMaxBrightness() {
        ClientUtils.pushBrightness(240, 240);
    }

    public static void popBrightness() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static ITextureObject bindTexture(ResourceLocation texture) {
        TextureManager t = MC.func_110434_K();
        ITextureObject textureObject = t.func_110581_b(texture);
        if (textureObject == null) {
            textureObject = new SimpleTexture(texture);
            t.func_110579_a(texture, textureObject);
        }
        GlStateManager.func_179144_i((int)textureObject.func_110552_b());
        return textureObject;
    }

    public static ITextureObject getDownloadImage(ResourceLocation out, String url, ResourceLocation def, @Nullable IImageBuffer buffer) {
        TextureManager t = MC.func_110434_K();
        ITextureObject img = t.func_110581_b(out);
        if (img == null) {
            img = new ThreadDownloadImageData(null, url, def, buffer);
            t.func_110579_a(out, img);
        }
        return img;
    }

    public static void execClientCommand(String s, boolean printChat) {
        Minecraft mc = MC;
        if (printChat) {
            mc.field_71456_v.func_146158_b().func_146239_a(s);
        }
        if (ClientCommandHandler.instance.func_71556_a((ICommandSender)mc.field_71439_g, s) == 0) {
            mc.field_71439_g.func_71165_d(s);
        }
    }

    public static void execClientCommand(String s) {
        ClientUtils.execClientCommand(s, false);
    }

    public static ResourceLocation getSkinTexture(String username) {
        ResourceLocation r = CACHED_SKINS.get(username);
        if (r == null) {
            r = AbstractClientPlayer.func_110311_f((String)username);
            try {
                AbstractClientPlayer.func_110304_a((ResourceLocation)r, (String)username);
                CACHED_SKINS.put(username, r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return r;
    }

    public static void renderItem(World w, ItemStack is) {
        if (entityItem == null) {
            entityItem = new EntityItem(w);
        }
        entityItem.func_70029_a(w);
        ClientUtils.entityItem.field_70290_d = 0.0f;
        entityItem.func_92058_a(is);
        MC.func_175598_ae().func_188391_a((Entity)entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f, true);
    }

    public static void drawOutlinedBoundingBox(AxisAlignedBB bb, Color4I color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        buffer.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void updateRenderInfo() {
        Minecraft mc = MC;
        isFirstPerson = mc.field_71474_y.field_74320_O == 0;
        currentDim = ClientUtils.getDim();
        playerX = mc.func_175598_ae().field_78730_l;
        playerY = mc.func_175598_ae().field_78731_m;
        playerZ = mc.func_175598_ae().field_78728_n;
        renderX = TileEntityRendererDispatcher.field_147554_b;
        renderY = TileEntityRendererDispatcher.field_147555_c;
        renderZ = TileEntityRendererDispatcher.field_147552_d;
        playerPosHash = Objects.hash(currentDim, playerX, playerY, playerZ);
        FRUSTUM.func_78547_a(playerX, playerY, playerZ);
    }

    public static BlockRenderLayer getStrongest(BlockRenderLayer layer1, BlockRenderLayer layer2) {
        return BLOCK_RENDER_LAYER_NAME_MAP.get(Math.max(layer1.ordinal(), layer2.ordinal()));
    }

    public static void runLater(Runnable runnable) {
        new Thread(() -> MC.func_152344_a(runnable)).start();
    }

    public static TextureAtlasSprite getAtlasSprite(ResourceLocation name) {
        return SPRITE_MAP.computeIfAbsent(name, DEFAULT_TEXTURE_GETTER);
    }

    public static boolean isClientOP() {
        return ClientUtils.MC.field_71439_g != null && ClientUtils.MC.field_71439_g.func_184840_I() > 0;
    }
}

