/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.cmd;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.ICustomPermission;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.server.permission.PermissionAPI;

public abstract class CmdBase
extends CommandBase
implements ICustomPermission {
    protected static final List<String> LIST_TRUE_FALSE = Collections.unmodifiableList(Arrays.asList("true", "false"));
    private final String name;
    public final Level level;
    private String customPermission;
    private String usage;

    public void checkArgs(ICommandSender sender, String[] args, int i) throws CommandException {
        if (args.length < i) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
    }

    public CmdBase(String n, Level l) {
        this.name = n;
        this.level = l;
        this.setCustomPermissionPrefix("");
    }

    public final String func_71517_b() {
        return this.name;
    }

    @Override
    public final String getCustomPermission() {
        return this.customPermission;
    }

    public final int func_82362_a() {
        return this.level.level;
    }

    public final String func_71518_a(ICommandSender ics) {
        return this.usage;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return this.level.checkPermission(sender, (ICommand)this);
    }

    @Override
    public void setCustomPermissionPrefix(String prefix) {
        String s = prefix.isEmpty() ? this.name : prefix + "." + this.name;
        this.customPermission = "command." + s;
        this.usage = "commands." + s + ".usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        if (this.func_82358_a(args, args.length - 1)) {
            return CmdBase.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public boolean func_82358_a(String[] args, int i) {
        return false;
    }

    public static IForgePlayer getForgePlayer(ICommandSender sender) throws CommandException {
        IForgePlayer p = FTBLibAPI.API.getUniverse().getPlayer(sender);
        if (p.isFake()) {
            throw FTBLibLang.PLAYER_NOT_FOUND.commandError(sender.func_145748_c_());
        }
        return p;
    }

    public static IForgePlayer getForgePlayer(String name) throws CommandException {
        IForgePlayer p = FTBLibAPI.API.getUniverse().getPlayer(name);
        if (p == null || p.isFake()) {
            throw FTBLibLang.PLAYER_NOT_FOUND.commandError(name);
        }
        return p;
    }

    public static IForgeTeam getTeam(String s) throws CommandException {
        IForgeTeam team = FTBLibAPI.API.getUniverse().getTeam(s);
        if (team != null) {
            return team;
        }
        throw FTBLibLang.TEAM_NOT_FOUND.commandError(new Object[0]);
    }

    public static EntityPlayerMP getSelfOrOther(ICommandSender sender, String[] args, int index) throws CommandException {
        return CmdBase.getSelfOrOther(sender, args, index, "");
    }

    public static EntityPlayerMP getSelfOrOther(ICommandSender sender, String[] args, int index, String specialPerm) throws CommandException {
        if (args.length <= index) {
            return CmdBase.func_71521_c((ICommandSender)sender);
        }
        if (!specialPerm.isEmpty() && sender instanceof EntityPlayerMP && !PermissionAPI.hasPermission((EntityPlayer)((EntityPlayerMP)sender), (String)specialPerm)) {
            throw FTBLibLang.COMMAND_PERMISSION.commandError(new Object[0]);
        }
        return CmdBase.getForgePlayer(args[index]).getCommandPlayer();
    }

    public static enum Level {
        ALL(0),
        OP(2);

        public final int level;

        private Level(int l) {
            this.level = l;
        }

        public boolean checkPermission(ICommandSender sender, ICommand command) {
            return this.level <= 0 || sender.func_70003_b(this.level, command.func_71517_b());
        }
    }
}

