/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.cmd;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.lib.cmd.CmdBase;
import com.feed_the_beast.ftbl.lib.config.ConfigGroup;
import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftbl.lib.config.IConfigCallback;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class CmdEditConfigBase
extends CmdBase {
    public CmdEditConfigBase(String n, CmdBase.Level l) {
        super(n, l);
    }

    public abstract ConfigGroup getGroup(ICommandSender var1) throws CommandException;

    public IConfigCallback getCallback(ICommandSender sender) throws CommandException {
        return IConfigCallback.DEFAULT;
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        try {
            List<String> variants;
            ConfigValue entry;
            ConfigGroup group = this.getGroup(sender);
            if (args.length == 1) {
                List keys = CmdEditConfigBase.func_175762_a((String[])args, group.getMap().keySet());
                if (keys.size() > 1) {
                    keys.sort(StringUtils.ID_COMPARATOR);
                }
                return keys;
            }
            if (args.length == 2 && !(entry = group.get(args[0])).isNull() && !(variants = entry.getVariants()).isEmpty()) {
                return CmdEditConfigBase.func_175762_a((String[])args, variants);
            }
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0 && sender instanceof EntityPlayerMP) {
            FTBLibAPI.API.editServerConfig(CmdEditConfigBase.func_71521_c((ICommandSender)sender), this.getGroup(sender), this.getCallback(sender));
            return;
        }
        this.checkArgs(sender, args, 1);
        ConfigGroup group = this.getGroup(sender);
        ConfigValue entry = group.get(args[0]);
        if (entry.isNull()) {
            throw FTBLibLang.CONFIG_COMMAND_INVALID_KEY.commandError(args[0]);
        }
        if (args.length >= 2) {
            String json = String.valueOf(StringUtils.joinSpaceUntilEnd(1, args));
            FTBLibFinals.LOGGER.info(FTBLibLang.CONFIG_COMMAND_SETTING.translate(args[0], json));
            try {
                JsonElement value = JsonUtils.fromJson(JsonUtils.fixJsonString(json));
                JsonObject json1 = new JsonObject();
                json1.add(args[0], value);
                this.getCallback(sender).saveConfig(group, sender, json1);
                ConfigValueInstance instance = group.getMap().get(args[0]);
                FTBLibLang.CONFIG_COMMAND_SET.sendMessage(sender, new TextComponentTranslation(group.getNameKey(instance.info), new Object[0]), group.get(args[0]).toString());
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw FTBLibLang.ERROR.commandError(ex.toString());
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(String.valueOf(entry.func_151003_a())));
    }
}

