/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.lib.config.ConfigInt;
import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.config.ConfigValueInfo;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public class ConfigDouble
extends ConfigValue
implements DoubleSupplier {
    public static final String ID = "double";
    private double value;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;

    public ConfigDouble() {
    }

    public ConfigDouble(double v) {
        this.value = v;
    }

    public ConfigDouble(double v, double mn, double mx) {
        this.value = v;
        this.min = mn;
        this.max = mx;
    }

    public String func_176610_l() {
        return ID;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    public void setDouble(double v) {
        this.value = v;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.getDouble();
    }

    public ConfigDouble setMin(double v) {
        this.min = v;
        return this;
    }

    public ConfigDouble setMax(double v) {
        this.max = v;
        return this;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public String getString() {
        return Double.toString(this.getDouble());
    }

    @Override
    public boolean getBoolean() {
        return this.getDouble() != 0.0;
    }

    @Override
    public int getInt() {
        return (int)this.getDouble();
    }

    @Override
    public ConfigDouble copy() {
        return new ConfigDouble(this.getDouble());
    }

    @Override
    public boolean equalsValue(ConfigValue value) {
        return this.getDouble() == value.getDouble();
    }

    @Override
    public Color4I getColor() {
        return ConfigInt.COLOR;
    }

    @Override
    public void addInfo(ConfigValueInfo info, List<String> list) {
        super.addInfo(info, list);
        double m = this.getMin();
        if (m != Double.NEGATIVE_INFINITY) {
            list.add(TextFormatting.AQUA + "Min: " + StringUtils.formatDouble(m));
        }
        if ((m = this.getMax()) != Double.POSITIVE_INFINITY) {
            list.add(TextFormatting.AQUA + "Max: " + StringUtils.formatDouble(m));
        }
    }

    @Override
    public boolean setValueFromString(String text, boolean simulate) {
        if (MathUtils.canParseDouble(text)) {
            if (!simulate) {
                this.setDouble(Double.parseDouble(text));
            }
            return true;
        }
        return false;
    }

    public void func_152753_a(JsonElement json) {
        this.setDouble(json.getAsDouble());
    }

    public JsonElement func_151003_a() {
        return new JsonPrimitive((Number)this.getDouble());
    }

    @Override
    public void writeData(DataOut data) {
        data.writeDouble(this.getDouble());
        data.writeDouble(this.getMin());
        data.writeDouble(this.getMax());
    }

    @Override
    public void readData(DataIn data) {
        this.setDouble(data.readDouble());
        this.setMin(data.readDouble());
        this.setMax(data.readDouble());
    }

    @Override
    public double getAsDouble() {
        return this.getDouble();
    }
}

