/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.lib.config.ConfigNull;
import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.config.ConfigValueInfo;
import com.feed_the_beast.ftbl.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public final class ConfigGroup
implements IJsonSerializable {
    private ITextComponent title;
    private String supergroup = "";
    private final Map<String, ConfigValueInstance> map;
    private final Map<String, ITextComponent> groupNames;

    public ConfigGroup(@Nullable ITextComponent t, boolean linked) {
        this.title = t;
        this.map = linked ? new LinkedHashMap() : new HashMap();
        this.groupNames = new HashMap<String, ITextComponent>();
    }

    public ConfigGroup(@Nullable ITextComponent t) {
        this(t, false);
    }

    public ConfigGroup setTitle(ITextComponent t) {
        this.title = t;
        return this;
    }

    public ITextComponent getTitle() {
        return this.title;
    }

    public ConfigGroup setSupergroup(String s) {
        this.supergroup = s;
        return this;
    }

    public ConfigGroup setGroupName(String group, ITextComponent name) {
        this.groupNames.put(group, name);
        return this;
    }

    public ITextComponent getGroupName(String key) {
        ITextComponent name = this.groupNames.get(key);
        return name == null ? new TextComponentTranslation(this.supergroup.isEmpty() ? key : this.supergroup + "." + key, new Object[0]) : name;
    }

    public String getNameKey(ConfigValueInfo info) {
        return info.displayName.isEmpty() ? (this.supergroup.isEmpty() ? info.id : this.supergroup + "." + info.id) : info.displayName;
    }

    public ConfigValueInfo add(ConfigValueInfo info, ConfigValue value) {
        this.map.put(info.id, new ConfigValueInstance(info, value));
        return info;
    }

    public ConfigValueInfo add(String group, String id, ConfigValue value) {
        return this.add(new ConfigValueInfo(group, id, value), value);
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public ConfigValue get(String key) {
        ConfigValueInstance v = this.map.get(key);
        return v == null ? ConfigNull.INSTANCE : v.value;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public final Map<String, ConfigValueInstance> getMap() {
        return this.map;
    }

    public ConfigGroup copy() {
        ConfigGroup g = new ConfigGroup(this.title.func_150259_f());
        for (ConfigValueInstance instance : this.map.values()) {
            g.add(instance.info.copy(), instance.value.copy());
        }
        return g;
    }

    public void writeData(DataOut net) {
        net.writeTextComponent(this.title);
        net.writeString(this.supergroup);
        net.writeShort(this.map.size());
        for (ConfigValueInstance configValueInstance : this.map.values()) {
            net.writeString(configValueInstance.info.id);
            configValueInstance.info.writeData(net);
            net.writeString(configValueInstance.value.func_176610_l());
            configValueInstance.value.writeData(net);
        }
        net.writeShort(this.groupNames.size());
        for (Map.Entry entry : this.groupNames.entrySet()) {
            net.writeString((String)entry.getKey());
            net.writeTextComponent((ITextComponent)entry.getValue());
        }
    }

    public void readData(DataIn net) {
        this.title = net.readTextComponent();
        this.supergroup = net.readString();
        int s = net.readUnsignedShort();
        this.map.clear();
        while (--s >= 0) {
            ConfigValueInfo info = new ConfigValueInfo(net.readString());
            info.readData(net);
            ConfigValue value = FTBLibAPI.API.getConfigValueFromId(net.readString());
            value.readData(net);
            this.map.put(info.id, new ConfigValueInstance(info, value));
        }
        s = net.readUnsignedShort();
        this.groupNames.clear();
        while (--s >= 0) {
            String group = net.readString();
            this.groupNames.put(group, net.readTextComponent());
        }
    }

    public void func_152753_a(JsonElement json) {
        JsonObject o = json.getAsJsonObject();
        for (ConfigValueInstance instance : this.map.values()) {
            JsonElement e;
            if (instance.info.excluded || (e = o.get(instance.info.id)) == null) continue;
            instance.value.func_152753_a(e);
        }
    }

    public JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        for (ConfigValueInstance instance : this.map.values()) {
            if (instance.info.excluded) continue;
            o.add(instance.info.id, instance.value.func_151003_a());
        }
        return o;
    }
}

