/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.item.ItemStackSerializer;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ConfigItemStack
extends ConfigValue {
    public static final String ID = "item_stack";
    private ItemStack value;

    public ConfigItemStack() {
    }

    public ConfigItemStack(@Nullable ItemStack is) {
        this.value = is;
    }

    public String func_176610_l() {
        return ID;
    }

    public ItemStack getItem() {
        return this.value;
    }

    public boolean matchesItem(ItemStack itemStack, int sizeMode) {
        ItemStack is = this.getItem();
        boolean isempty = is.func_190926_b();
        boolean stackempty = itemStack.func_190926_b();
        if (isempty || stackempty) {
            return isempty == stackempty;
        }
        int issize = is.func_190916_E();
        int stackSize = itemStack.func_190916_E();
        Item item0 = itemStack.func_77973_b();
        int meta = itemStack.func_77960_j();
        if (is.func_77973_b() == item0 && is.func_77960_j() == meta) {
            switch (sizeMode) {
                case 1: {
                    if (issize != stackSize) break;
                    return true;
                }
                case 2: {
                    if (issize > stackSize) break;
                    return true;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    public void setItem(@Nullable ItemStack is) {
        this.value = is;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.getItem();
    }

    @Override
    public String getString() {
        ItemStack is = this.getItem();
        return is.func_190916_E() + "x " + (is.func_190926_b() ? "Air" : is.func_82833_r());
    }

    @Override
    public boolean getBoolean() {
        return this.getInt() > 0;
    }

    @Override
    public int getInt() {
        return this.getItem().func_190916_E();
    }

    @Override
    public ConfigItemStack copy() {
        return new ConfigItemStack(this.getItem());
    }

    public void func_152753_a(JsonElement o) {
        this.setItem(ItemStackSerializer.deserialize(o));
    }

    public JsonElement func_151003_a() {
        return ItemStackSerializer.serialize(this.getItem());
    }

    @Override
    public void writeData(DataOut data) {
        data.writeItemStack(this.getItem());
    }

    @Override
    public void readData(DataIn data) {
        this.setItem(data.readItemStack());
    }
}

