/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public final class ConfigList
extends ConfigValue
implements Iterable<ConfigValue> {
    public static final String ID = "list";
    public static final Color4I COLOR = Color4I.rgb(16755273);
    private final List<ConfigValue> list = new ArrayList<ConfigValue>();
    private String valueId;

    public ConfigList(String id) {
        this.valueId = id;
    }

    public ConfigList(Collection<ConfigValue> v) {
        this("null");
        this.addAll(v);
    }

    public ConfigList(ConfigValue v0, ConfigValue ... v) {
        this("null");
        this.add(v0);
        this.addAll(v);
    }

    public String func_176610_l() {
        return ID;
    }

    @Override
    public Object getValue() {
        return this.getList();
    }

    public void clear() {
        this.list.clear();
        this.valueId = "null";
    }

    private boolean hasValidId() {
        return !this.valueId.equals("null");
    }

    public void add(ConfigValue v) {
        if (v.isNull()) {
            return;
        }
        if (this.valueId.equals("null")) {
            this.valueId = v.func_176610_l();
            this.list.add(v);
        } else if (v.func_176610_l().equals(this.valueId)) {
            this.list.add(v);
        }
    }

    public void addAll(Collection<ConfigValue> v) {
        for (ConfigValue v1 : v) {
            this.add(v1);
        }
    }

    public void addAll(ConfigValue ... v) {
        for (ConfigValue v1 : v) {
            this.add(v1);
        }
    }

    public Collection<ConfigValue> getList() {
        return this.list;
    }

    public boolean containsValue(@Nullable Object val) {
        if (this.list.isEmpty()) {
            return false;
        }
        for (ConfigValue value : this.list) {
            if (value.getValue() != val) continue;
            return true;
        }
        if (val == null) {
            return false;
        }
        for (ConfigValue value : this.list) {
            Object o = value.getValue();
            if (o == null || !val.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeString(this.valueId);
        if (this.valueId.equals("null")) {
            return;
        }
        Collection<ConfigValue> list = this.getList();
        data.writeShort(list.size());
        for (ConfigValue s : list) {
            s.writeData(data);
        }
    }

    @Override
    public void readData(DataIn data) {
        this.clear();
        this.valueId = data.readString();
        if (this.valueId.equals("null")) {
            return;
        }
        int s = data.readUnsignedShort();
        ConfigValue blank = FTBLibAPI.API.getConfigValueFromId(this.valueId);
        while (--s >= 0) {
            ConfigValue v = blank.copy();
            v.readData(data);
            this.add(v);
        }
    }

    @Override
    public String getString() {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < this.list.size(); ++i) {
            builder.append(this.list.get(i).getString());
            if (i == this.list.size() - 1) continue;
            builder.append(',');
            builder.append(' ');
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public boolean getBoolean() {
        return !this.list.isEmpty();
    }

    @Override
    public int getInt() {
        return this.list.size();
    }

    @Override
    public ConfigValue copy() {
        return new ConfigList(this.list);
    }

    @Override
    public Color4I getColor() {
        return COLOR;
    }

    public void func_152753_a(JsonElement json) {
        if (!this.hasValidId()) {
            return;
        }
        this.list.clear();
        JsonArray a = json.getAsJsonArray();
        if (a.size() == 0) {
            return;
        }
        ConfigValue blank = FTBLibAPI.API.getConfigValueFromId(this.valueId);
        for (JsonElement e : a) {
            ConfigValue v = blank.copy();
            v.func_152753_a(e);
            this.add(v);
        }
    }

    public JsonElement func_151003_a() {
        JsonArray a = new JsonArray();
        if (this.hasValidId()) {
            this.list.forEach(v -> a.add(v.func_151003_a()));
        }
        return a;
    }

    @Override
    public Iterator<ConfigValue> iterator() {
        return this.list.iterator();
    }
}

