/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.lib.config.ConfigEnum;
import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.config.ConfigValueInfo;
import com.feed_the_beast.ftbl.lib.config.IGuiEditConfig;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class ConfigStringEnum
extends ConfigValue {
    private final List<String> keys;
    private String value;
    private final Map<String, ITextComponent> customNames;
    private final Map<String, Color4I> customColors;

    public ConfigStringEnum() {
        this(Collections.emptyList(), "");
    }

    public ConfigStringEnum(Collection<String> k, String v) {
        this.keys = new ArrayList<String>(k);
        this.value = v;
        this.customNames = new HashMap<String, ITextComponent>();
        this.customColors = new HashMap<String, Color4I>();
    }

    public String func_176610_l() {
        return "enum";
    }

    @Override
    public final Object getValue() {
        return this.getString();
    }

    public void setString(String v) {
        this.value = v;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public boolean hasCustomName() {
        return this.customNames.containsKey(this.getString());
    }

    @Override
    public ITextComponent getCustomDisplayName() {
        return this.customNames.get(this.getString());
    }

    @Override
    public Color4I getCustomColor() {
        Color4I col = this.customColors.get(this.getString());
        return col == null ? Icon.EMPTY : col;
    }

    public void setCustomName(String key, @Nullable ITextComponent component) {
        if (component == null) {
            this.customNames.remove(key);
        } else {
            this.customNames.put(key, component);
        }
    }

    public void setCustomColor(String key, Color4I col) {
        if (col.isEmpty()) {
            this.customColors.remove(key);
        } else {
            this.customColors.put(key, col);
        }
    }

    @Override
    public boolean getBoolean() {
        return !this.getString().equals("-");
    }

    @Override
    public int getInt() {
        return this.keys.indexOf(this.getString());
    }

    @Override
    public ConfigStringEnum copy() {
        ConfigStringEnum config = new ConfigStringEnum(this.keys, this.getString());
        for (Map.Entry<String, ITextComponent> entry : this.customNames.entrySet()) {
            config.customNames.put(entry.getKey(), entry.getValue().func_150259_f());
        }
        for (Map.Entry<String, Object> entry : this.customColors.entrySet()) {
            config.customColors.put(entry.getKey(), ((Color4I)entry.getValue()).copy());
        }
        return config;
    }

    @Override
    public Color4I getColor() {
        return ConfigEnum.COLOR;
    }

    @Override
    public void addInfo(ConfigValueInfo info, List<String> list) {
        ITextComponent component = this.customNames.get(info.defaultValue.getString());
        list.add(TextFormatting.AQUA + "Def: " + (component == null ? info.defaultValue.getString() : component.func_150254_d()));
    }

    @Override
    public List<String> getVariants() {
        return Collections.unmodifiableList(this.keys);
    }

    @Override
    public void onClicked(IGuiEditConfig gui, ConfigValueInfo info, MouseButton button) {
        this.setString(this.keys.get(MathUtils.wrap(this.getInt() + (button.isLeft() ? 1 : -1), this.keys.size())));
        gui.onChanged(info.id, this.func_151003_a());
    }

    public void func_152753_a(JsonElement json) {
        this.setString(json.getAsString());
    }

    public JsonElement func_151003_a() {
        return new JsonPrimitive(this.getString());
    }

    @Override
    public void writeData(DataOut data) {
        data.writeShort(this.keys.size());
        for (String s : this.keys) {
            data.writeString(s);
            data.writeTextComponent(this.customNames.get(s));
            data.writeIcon(this.customColors.get(s));
        }
        data.writeShort(this.getInt());
    }

    @Override
    public void readData(DataIn data) {
        this.keys.clear();
        this.customNames.clear();
        this.customColors.clear();
        int s = data.readUnsignedShort();
        while (--s >= 0) {
            String key = data.readString();
            this.keys.add(key);
            this.setCustomName(key, data.readTextComponent());
            Icon i = data.readIcon();
            if (!(i instanceof Color4I)) continue;
            this.setCustomColor(key, (Color4I)i);
        }
        this.setString(this.keys.get(data.readUnsignedShort()));
    }
}

