/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.ICustomColor;
import com.feed_the_beast.ftbl.api.ICustomName;
import com.feed_the_beast.ftbl.lib.config.ConfigValueInfo;
import com.feed_the_beast.ftbl.lib.config.IGuiEditConfig;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiSelectors;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class ConfigValue
implements IStringSerializable,
IJsonSerializable,
ICustomName,
ICustomColor {
    public abstract Object getValue();

    public abstract String getString();

    public abstract boolean getBoolean();

    public abstract int getInt();

    public double getDouble() {
        return this.getInt();
    }

    public abstract ConfigValue copy();

    public boolean equalsValue(ConfigValue value) {
        return Objects.equals(this.getValue(), value.getValue());
    }

    public Color4I getColor() {
        return Color4I.GRAY;
    }

    public void addInfo(ConfigValueInfo info, List<String> list) {
        list.add(TextFormatting.AQUA + "Def: " + info.defaultValue.getString());
    }

    public List<String> getVariants() {
        return Collections.emptyList();
    }

    public boolean isNull() {
        return false;
    }

    public void onClicked(IGuiEditConfig gui, ConfigValueInfo info, MouseButton button) {
        GuiSelectors.selectJson(this, (value, set) -> {
            if (set) {
                this.func_152753_a(value.func_151003_a());
                gui.onChanged(info.id, this.func_151003_a());
            }
            gui.openGui();
        });
    }

    public boolean setValueFromString(String text, boolean simulate) {
        try {
            JsonElement json = JsonUtils.fromJson(text);
            if (!json.isJsonNull()) {
                if (!simulate) {
                    this.func_152753_a(json);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object o) {
        return o instanceof ConfigValue && this.equalsValue((ConfigValue)o);
    }

    public String toString() {
        return this.getString();
    }

    public abstract void writeData(DataOut var1);

    public abstract void readData(DataIn var1);

    @Override
    public boolean hasCustomName() {
        return this.getValue() instanceof ICustomName && ((ICustomName)this.getValue()).hasCustomName();
    }

    @Override
    public ITextComponent getCustomDisplayName() {
        return ((ICustomName)this.getValue()).getCustomDisplayName();
    }

    @Override
    public Color4I getCustomColor() {
        return this.getValue() instanceof ICustomColor ? ((ICustomColor)this.getValue()).getCustomColor() : Icon.EMPTY;
    }
}

