/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.lib.config.ConfigNull;
import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;

public class ConfigValueInfo {
    public static final int DISPLAY_NAME = 1;
    public static final int GROUP = 2;
    public static final int EXCLUDED = 4;
    public static final int HIDDEN = 8;
    public static final int CANT_EDIT = 16;
    public static final int USE_SCROLL_BAR = 32;
    public final String id;
    public String group;
    public ConfigValue defaultValue;
    public String displayName;
    public boolean excluded;
    public boolean hidden;
    public boolean cantEdit;
    public boolean useScrollBar;

    public ConfigValueInfo(String _id) {
        this.id = _id;
        this.setDefaults();
    }

    public ConfigValueInfo(String _group, String _id, ConfigValue _defaultValue) {
        this.id = _group.isEmpty() ? _id : _group + "." + _id;
        this.setDefaults();
        this.group = _group;
        this.defaultValue = _defaultValue.copy();
    }

    public void setDefaults() {
        this.group = "";
        this.displayName = "";
        this.defaultValue = ConfigNull.INSTANCE;
        this.excluded = false;
        this.hidden = false;
        this.cantEdit = false;
        this.useScrollBar = false;
    }

    public void writeData(DataOut net) {
        int flags = 0;
        flags = Bits.setFlag(flags, 1, !this.displayName.isEmpty());
        flags = Bits.setFlag(flags, 2, !this.group.isEmpty());
        flags = Bits.setFlag(flags, 4, this.excluded);
        flags = Bits.setFlag(flags, 8, this.hidden);
        flags = Bits.setFlag(flags, 16, this.cantEdit);
        flags = Bits.setFlag(flags, 32, this.useScrollBar);
        net.writeByte(flags);
        if (!this.displayName.isEmpty()) {
            net.writeString(this.displayName);
        }
        if (!this.group.isEmpty()) {
            net.writeString(this.group);
        }
        net.writeString(this.defaultValue.func_176610_l());
        this.defaultValue.writeData(net);
    }

    public void readData(DataIn net) {
        this.setDefaults();
        short flags = net.readUnsignedByte();
        this.excluded = Bits.getFlag(flags, 4);
        this.hidden = Bits.getFlag(flags, 8);
        this.cantEdit = Bits.getFlag(flags, 16);
        this.useScrollBar = Bits.getFlag(flags, 32);
        if (Bits.getFlag(flags, 1)) {
            this.displayName = net.readString();
        }
        if (Bits.getFlag(flags, 2)) {
            this.group = net.readString();
        }
        this.defaultValue = FTBLibAPI.API.getConfigValueFromId(net.readString());
        this.defaultValue.readData(net);
    }

    public ConfigValueInfo copy() {
        ConfigValueInfo info = new ConfigValueInfo(this.id);
        info.defaultValue = this.defaultValue.copy();
        info.group = this.group;
        info.displayName = this.displayName;
        info.excluded = this.excluded;
        info.hidden = this.hidden;
        info.cantEdit = this.cantEdit;
        info.useScrollBar = this.useScrollBar;
        return info;
    }

    public ConfigValueInfo setNameLangKey(String key) {
        this.displayName = key;
        return this;
    }
}

