/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class CheckBoxList
extends Button {
    public final boolean radioButtons;
    private final List<CheckBoxEntry> entries;

    public CheckBoxList(GuiBase gui, int x, int y, boolean radiobutton) {
        super(gui, x, y, 10, 2);
        this.radioButtons = radiobutton;
        this.entries = new ArrayList<CheckBoxEntry>();
    }

    public int getValueCount() {
        return 2;
    }

    public Icon getCheckboxBackground() {
        return this.gui.getTheme().getCheckboxBackground(this.radioButtons);
    }

    public Icon getCheckboxIcon(int index, int value) {
        return this.gui.getTheme().getCheckbox(this.gui.isMouseOver(this), value != 0, this.radioButtons);
    }

    public void addBox(CheckBoxEntry checkBox) {
        checkBox.checkBoxList = this;
        this.entries.add(checkBox);
        this.setWidth(Math.max(this.width, this.gui.getStringWidth(checkBox.name)));
        this.setHeight(this.height + 11);
    }

    public CheckBoxEntry addBox(String name) {
        CheckBoxEntry entry = new CheckBoxEntry(name);
        this.addBox(entry);
        return entry;
    }

    @Override
    public void onClicked(MouseButton button) {
        int y = this.gui.getMouseY() - this.getAY();
        if (y % 11 == 10) {
            return;
        }
        int i = y / 11;
        if (i >= 0 && i < this.entries.size()) {
            this.entries.get(i).onClicked(button, i);
        }
    }

    @Override
    public void addMouseOverText(List<String> list) {
    }

    @Override
    public Icon getIcon() {
        return Icon.EMPTY;
    }

    @Override
    public void renderWidget() {
        int ax = this.getAX();
        int ay = this.getAY();
        this.getIcon().draw(ax, ay, this.width, this.height);
        Icon bg = this.getCheckboxBackground();
        for (int i = 0; i < this.entries.size(); ++i) {
            CheckBoxEntry entry = this.entries.get(i);
            int y = ay + i * 11 + 1;
            bg.draw(ax, y, 10, 10);
            this.getCheckboxIcon(i, entry.value).draw(ax + 1, y + 1, 8, 8);
            this.gui.drawString(entry.name, ax + 12, y + 1);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static class CheckBoxEntry {
        public String name;
        public int value = 0;
        private CheckBoxList checkBoxList;

        public CheckBoxEntry(String n) {
            this.name = n;
        }

        public void onClicked(MouseButton button, int index) {
            this.select((this.value + 1) % this.checkBoxList.getValueCount());
            GuiHelper.playClickSound();
        }

        public void addMouseOverText(List<String> list) {
        }

        public CheckBoxEntry select(int v) {
            if (this.checkBoxList.radioButtons) {
                if (v > 0) {
                    for (CheckBoxEntry entry : this.checkBoxList.entries) {
                        boolean old1 = entry.value > 0;
                        entry.value = 0;
                        if (!old1) continue;
                        entry.onValueChanged();
                    }
                } else {
                    return this;
                }
            }
            int old = this.value;
            this.value = v;
            if (old != this.value) {
                this.onValueChanged();
            }
            return this;
        }

        public void onValueChanged() {
        }
    }
}

