/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.TextField;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbl.lib.util.text_components.TextComponentCountdown;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;

public class ExtendedTextField
extends TextField {
    public ITextComponent textComponent;
    private List<GuiHelper.PositionedTextData> textData;
    private long lastUpdate = -1L;

    public ExtendedTextField(GuiBase gui, int x, int y, int w, int h, ITextComponent t, int flags) {
        super(gui, x, y, w, h, "", flags);
        this.textComponent = t;
        this.setTitle("");
    }

    public ExtendedTextField(GuiBase gui, int x, int y, int w, int h, ITextComponent t) {
        this(gui, x, y, w, h, t, 0);
    }

    @Override
    public ExtendedTextField setTitle(String txt) {
        this.lastUpdate = -1L;
        if (this.textComponent != null) {
            for (ITextComponent component : this.textComponent) {
                if (!(component instanceof TextComponentCountdown)) continue;
                this.lastUpdate = 0L;
            }
            super.setTitle(this.textComponent.func_150254_d());
            this.textData = GuiHelper.createDataFrom(this.textComponent, ClientUtils.MC.field_71466_p, this.width);
        }
        return this;
    }

    @Nullable
    private GuiHelper.PositionedTextData getDataAtMouse() {
        int ax = this.getAX();
        int ay = this.getAY();
        for (GuiHelper.PositionedTextData data : this.textData) {
            if (!this.gui.isMouseOver(data.posX + ax, data.posY + ay, data.width, data.height)) continue;
            return data;
        }
        return null;
    }

    @Override
    public void addMouseOverText(List<String> list) {
        GuiHelper.PositionedTextData data = this.getDataAtMouse();
        if (data != null && data.hoverEvent != null) {
            Collections.addAll(list, data.hoverEvent.func_150702_b().func_150254_d().split("\n"));
        }
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        GuiHelper.PositionedTextData data;
        if (this.gui.isMouseOver(this) && (data = this.getDataAtMouse()) != null && data.clickEvent != null && GuiHelper.onClickEvent(data.clickEvent)) {
            GuiHelper.playClickSound();
            return true;
        }
        return false;
    }

    @Override
    public void renderWidget() {
        long ms;
        if (this.lastUpdate != -1L && this.lastUpdate <= (ms = System.currentTimeMillis())) {
            this.lastUpdate = ms + 500L;
            this.setTitle("");
            this.getParentPanel().refreshWidgets();
        }
        super.renderWidget();
    }
}

