/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.GuiWrapper;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Theme;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftbl.lib.gui.misc.ThemeVanilla;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.io.Bits;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class GuiBase
extends Panel {
    public static final List<String> TEMP_TEXT_LIST = new ArrayList<String>();
    private final FontRenderer font;
    private int mouseX;
    private int mouseY;
    private int mouseWheel;
    private float partialTicks;
    private boolean refreshWidgets;
    private ScaledResolution screen;
    public boolean fixUnicode;
    private GuiScreen prevScreen;
    private final BooleanStack fontUnicode;

    public GuiBase(int w, int h) {
        super(null, 0, 0, w, h);
        this.gui = this;
        this.setParentPanel(this);
        this.font = this.createFont();
        this.prevScreen = ClientUtils.MC.field_71462_r;
        this.fontUnicode = new BooleanArrayList();
    }

    public static void setupDrawing() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public final void initGui() {
        this.screen = new ScaledResolution(ClientUtils.MC);
        this.onInit();
        this.refreshWidgets();
        this.updateWidgetPositions();
        this.fixUnicode = this.screen.func_78325_e() % 2 == 1;
    }

    public Theme getTheme() {
        return ThemeVanilla.INSTANCE;
    }

    @Override
    public Panel getParentPanel() {
        return this;
    }

    @Override
    public void setParentPanel(Panel p) {
    }

    @Override
    public int getAX() {
        return (this.screen.func_78326_a() - this.width) / 2;
    }

    @Override
    public int getAY() {
        return (this.screen.func_78328_b() - this.height) / 2;
    }

    @Override
    public void setScrollX(int scroll) {
    }

    @Override
    public void setScrollY(int scroll) {
    }

    @Override
    public boolean hasFlag(int flag) {
        return false;
    }

    public void onInit() {
    }

    @Nullable
    public GuiScreen getPrevScreen() {
        if (this.prevScreen instanceof GuiWrapper && ((GuiWrapper)this.prevScreen).getWrappedGui() instanceof GuiLoading) {
            return ((GuiWrapper)this.prevScreen).getWrappedGui().getPrevScreen();
        }
        if (this.prevScreen instanceof GuiChat) {
            return null;
        }
        return this.prevScreen;
    }

    public final void closeGui() {
        this.closeGui(true);
    }

    public final void closeGui(boolean openPrevScreen) {
        int mx = Mouse.getX();
        int my = Mouse.getY();
        if (ClientUtils.MC.field_71439_g != null) {
            ClientUtils.MC.field_71439_g.func_71053_j();
        }
        if (openPrevScreen) {
            ClientUtils.MC.func_147108_a(this.getPrevScreen());
            Mouse.setCursorPosition((int)mx, (int)my);
        }
        this.onClosed();
    }

    public boolean onClosedByKey() {
        return true;
    }

    public void onClosed() {
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    protected FontRenderer createFont() {
        return ClientUtils.MC.field_71466_p;
    }

    @Override
    public final void refreshWidgets() {
        this.refreshWidgets = true;
    }

    public final void updateGui(int mx, int my, float pt) {
        this.partialTicks = pt;
        this.mouseX = mx;
        this.mouseY = my;
        this.mouseWheel = Mouse.getDWheel();
        if (this.refreshWidgets) {
            super.refreshWidgets();
            this.refreshWidgets = false;
        }
        this.posX = this.getAX();
        this.posY = this.getAY();
    }

    @Override
    public final void renderWidget() {
        GuiBase.setupDrawing();
        this.drawBackground();
        super.renderWidget();
    }

    @Override
    protected final void renderPanelBackground(int ax, int ay) {
    }

    public boolean drawDefaultBackground() {
        return true;
    }

    public void drawBackground() {
    }

    public void drawForeground() {
        this.addMouseOverText(TEMP_TEXT_LIST);
        GuiUtils.drawHoveringText(TEMP_TEXT_LIST, (int)this.mouseX, (int)Math.max(this.mouseY, 18), (int)this.screen.func_78326_a(), (int)this.screen.func_78328_b(), (int)0, (FontRenderer)this.font);
        TEMP_TEXT_LIST.clear();
    }

    @Override
    public boolean shouldAddMouseOverText() {
        return true;
    }

    public GuiScreen getWrapper() {
        return new GuiWrapper(this);
    }

    public final void openGui() {
        ClientUtils.MC.func_147108_a(this.getWrapper());
    }

    public final void openGuiLater() {
        ClientUtils.runLater(this::openGui);
    }

    public final ScaledResolution getScreen() {
        return this.screen;
    }

    public final int getMouseX() {
        return this.mouseX;
    }

    public final int getMouseY() {
        return this.mouseY;
    }

    public final int getMouseWheel() {
        return this.mouseWheel;
    }

    public final float getPartialTicks() {
        return this.partialTicks;
    }

    public final boolean isMouseButtonDown(int button) {
        return Mouse.isButtonDown((int)button);
    }

    public final boolean isKeyDown(int key) {
        return Keyboard.isKeyDown((int)key);
    }

    public boolean isMouseOver(int x, int y, int w, int h) {
        return this.getMouseX() >= x && this.getMouseY() >= y && this.getMouseX() < x + w && this.getMouseY() < y + h;
    }

    public boolean isMouseOver(Widget w) {
        if (w == this) {
            return true;
        }
        if (this.isMouseOver(w.getAX(), w.getAY(), w.width, w.height)) {
            Panel p = w.getParentPanel();
            boolean offset = p.isOffset();
            p.setOffset(false);
            boolean b = this.isMouseOver(p);
            p.setOffset(offset);
            return b;
        }
        return false;
    }

    public void pushFontUnicode(boolean flag) {
        this.fontUnicode.push(this.font.func_82883_a());
        this.font.func_78264_a(flag);
    }

    public void popFontUnicode() {
        this.font.func_78264_a(((Boolean)this.fontUnicode.pop()).booleanValue());
    }

    public int getStringWidth(String text) {
        return this.font.func_78256_a(text);
    }

    public int getFontHeight() {
        return this.font.field_78288_b;
    }

    public String trimStringToWidth(String text, int width, boolean reverse) {
        return this.font.func_78262_a(text, width, reverse);
    }

    public List<String> listFormattedStringToWidth(String text, int width) {
        if (width <= 0) {
            return Collections.emptyList();
        }
        return this.font.func_78271_c(text, width);
    }

    public int drawString(String text, int x, int y, Color4I color, boolean shadow, boolean centered) {
        if (text.isEmpty() || color.isEmpty()) {
            return 0;
        }
        if (centered) {
            x -= this.font.func_78256_a(text) / 2;
            y -= this.font.field_78288_b / 2;
        }
        int i = this.font.func_175065_a(text, (float)x, (float)y, color.rgba(), shadow);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return i;
    }

    public int drawString(String text, int x, int y, Color4I color, int flags) {
        return this.drawString(text, x, y, color, Bits.getFlag(flags, 2), Bits.getFlag(flags, 4));
    }

    public final int drawString(String text, int x, int y, int flags) {
        return this.drawString(text, x, y, this.getTheme().getContentColor(), flags);
    }

    public final int drawString(String text, int x, int y) {
        return this.drawString(text, x, y, this.getTheme().getContentColor(), false, false);
    }

    public boolean isShiftDown() {
        return GuiScreen.func_146272_n();
    }

    public boolean isCtrlDown() {
        return GuiScreen.func_146271_m();
    }

    public boolean changePage(String value) {
        return false;
    }

    @Override
    public Icon getIcon() {
        return this.getTheme().getGui(false);
    }
}

