/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.api.ClientATHelper;
import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.IGuiWrapper;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.util.NetUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    private static final Stack<Scissor> SCISSOR = new Stack();

    public static void playSound(SoundEvent event, float pitch) {
        ClientUtils.MC.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)event, (float)pitch));
    }

    public static void playClickSound() {
        GuiHelper.playSound(SoundEvents.field_187909_gi, 1.0f);
    }

    public static void drawTexturedRect(int x, int y, int w, int h, Color4I col, double u0, double v0, double u1, double v1) {
        if (col.isEmpty()) {
            col = Color4I.WHITE;
        }
        if (u0 == u1 || v0 == v1) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            GuiHelper.addRectToBuffer(buffer, x, y, w, h, col);
            tessellator.func_78381_a();
        } else {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            GuiHelper.addRectToBufferWithUV(buffer, x, y, w, h, col, u0, v0, u1, v1);
            tessellator.func_78381_a();
        }
    }

    public static void addRectToBuffer(BufferBuilder buffer, int x, int y, int w, int h, Color4I col) {
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.func_181662_b((double)x, (double)(y + h), 0.0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
    }

    public static void addRectToBufferWithUV(BufferBuilder buffer, int x, int y, int w, int h, Color4I col, double u0, double v0, double u1, double v1) {
        int r = col.redi();
        int g = col.greeni();
        int b = col.bluei();
        int a = col.alphai();
        buffer.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a(u0, v1).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(u1, v1).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, 0.0).func_187315_a(u1, v0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(u0, v0).func_181669_b(r, g, b, a).func_181675_d();
    }

    public static void drawHollowRect(int x, int y, int w, int h, Color4I col, boolean roundEdges) {
        if (w <= 1 || h <= 1 || col.isEmpty()) {
            col.draw(x, y, w, h);
            return;
        }
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiHelper.addRectToBuffer(buffer, x, y + 1, 1, h - 2, col);
        GuiHelper.addRectToBuffer(buffer, x + w - 1, y + 1, 1, h - 2, col);
        if (roundEdges) {
            GuiHelper.addRectToBuffer(buffer, x + 1, y, w - 2, 1, col);
            GuiHelper.addRectToBuffer(buffer, x + 1, y + h - 1, w - 2, 1, col);
        } else {
            GuiHelper.addRectToBuffer(buffer, x, y, w, 1, col);
            GuiHelper.addRectToBuffer(buffer, x, y + h - 1, w, 1, col);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static boolean drawItem(ItemStack stack, double x, double y, double scaleX, double scaleY, boolean renderOverlay, Color4I color) {
        if (stack.func_190926_b() || !color.isEmpty() && color.alphai() < 100) {
            return false;
        }
        boolean result = true;
        RenderItem renderItem = ClientUtils.MC.func_175599_af();
        renderItem.field_77023_b = 180.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)32.0);
        if (scaleX != 1.0 || scaleY != 1.0) {
            GlStateManager.func_179139_a((double)scaleX, (double)scaleY, (double)1.0);
        }
        GlStateManager.func_179145_e();
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        try {
            renderItem.func_180450_b(stack, 0, 0);
            if (renderOverlay) {
                FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
                if (font == null) {
                    font = ClientUtils.MC.field_71466_p;
                }
                renderItem.func_180453_a(font, stack, 0, 0, null);
            }
        }
        catch (Exception ex) {
            result = false;
        }
        GlStateManager.func_179121_F();
        renderItem.field_77023_b = 0.0f;
        return result;
    }

    public static boolean drawItem(ItemStack stack, double x, double y, boolean renderOverlay, Color4I color) {
        return GuiHelper.drawItem(stack, x, y, 1.0, 1.0, renderOverlay, color);
    }

    public static void pushScissor(ScaledResolution screen, int x, int y, int w, int h) {
        if (SCISSOR.isEmpty()) {
            GL11.glEnable((int)3089);
        }
        Scissor scissor = SCISSOR.isEmpty() ? new Scissor(x, y, w, h) : ((Scissor)SCISSOR.lastElement()).crop(x, y, w, h);
        SCISSOR.push(scissor);
        scissor.scissor(screen);
    }

    public static void popScissor(ScaledResolution screen) {
        SCISSOR.pop().scissor(screen);
        if (SCISSOR.isEmpty()) {
            GL11.glDisable((int)3089);
        }
    }

    public static void setFixUnicode(boolean enabled) {
        TextureManager textureManager = ClientUtils.MC.func_110434_K();
        int mode = enabled ? 9729 : 9728;
        for (int i = 0; i < 256; ++i) {
            ResourceLocation loc = ClientATHelper.INSTANCE.getFontUnicodePage(i);
            if (loc == null) continue;
            textureManager.func_110577_a(loc);
            GL11.glTexParameteri((int)3553, (int)10240, (int)mode);
            GL11.glTexParameteri((int)3553, (int)10240, (int)mode);
        }
    }

    public static boolean onClickEvent(@Nullable ClickEvent clickEvent) {
        if (clickEvent == null) {
            return false;
        }
        switch (clickEvent.func_150669_a()) {
            case OPEN_URL: {
                try {
                    URI uri = new URI(clickEvent.func_150668_b());
                    String s = uri.getScheme();
                    if (s == null) {
                        throw new URISyntaxException(clickEvent.func_150668_b(), "Missing protocol");
                    }
                    if (!s.toLowerCase().contains("http") && !s.toLowerCase().contains("https")) {
                        throw new URISyntaxException(clickEvent.func_150668_b(), "Unsupported protocol: " + s.toLowerCase());
                    }
                    if (ClientUtils.MC.field_71474_y.field_74358_q) {
                        GuiScreen currentScreen = ClientUtils.MC.field_71462_r;
                        ClientUtils.MC.func_147108_a((GuiScreen)new GuiConfirmOpenLink((result, id) -> {
                            if (result) {
                                try {
                                    NetUtils.openURI(uri);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            ClientUtils.MC.func_147108_a(currentScreen);
                        }, clickEvent.func_150668_b(), 0, false));
                    } else {
                        NetUtils.openURI(uri);
                    }
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case OPEN_FILE: {
                try {
                    NetUtils.openURI(new File(clickEvent.func_150668_b()).toURI());
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case SUGGEST_COMMAND: {
                return true;
            }
            case RUN_COMMAND: {
                ClientUtils.execClientCommand(clickEvent.func_150668_b(), false);
                return true;
            }
            case CHANGE_PAGE: {
                if (!(ClientUtils.MC.field_71462_r instanceof IGuiWrapper) || !((IGuiWrapper)ClientUtils.MC.field_71462_r).getWrappedGui().changePage(clickEvent.func_150668_b())) break;
                return true;
            }
        }
        return false;
    }

    public static List<PositionedTextData> createDataFrom(ITextComponent component, FontRenderer font, int width) {
        if (width <= 0 || component.func_150260_c().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PositionedTextData> list = new ArrayList<PositionedTextData>();
        int line = 0;
        int currentWidth = 0;
        for (ITextComponent t : component.func_150259_f()) {
            String text = t.func_150261_e();
            int textWidth = font.func_78256_a(text);
            while (textWidth > 0) {
                int w = textWidth;
                if (w > width - currentWidth) {
                    w = width - currentWidth;
                }
                list.add(new PositionedTextData(currentWidth, line * 10, w, 10, t.func_150256_b()));
                textWidth -= w;
                if ((currentWidth += w) < width) continue;
                currentWidth = 0;
                ++line;
            }
        }
        return list;
    }

    public static class PositionedTextData {
        public final int posX;
        public final int posY;
        public final int width;
        public final int height;
        public final ClickEvent clickEvent;
        public final HoverEvent hoverEvent;
        public final String insertion;

        public PositionedTextData(int x, int y, int w, int h, Style s) {
            this.posX = x;
            this.posY = y;
            this.width = w;
            this.height = h;
            this.clickEvent = s.func_150235_h();
            this.hoverEvent = s.func_150210_i();
            this.insertion = s.func_179986_j();
        }
    }

    private static class Scissor {
        private final int x;
        private final int y;
        private final int w;
        private final int h;

        private Scissor(int _x, int _y, int _w, int _h) {
            this.x = _x;
            this.y = _y;
            this.w = Math.max(0, _w);
            this.h = Math.max(0, _h);
        }

        public Scissor crop(int sx, int sy, int sw, int sh) {
            int x0 = Math.max(this.x, sx);
            int y0 = Math.max(this.y, sy);
            int x1 = Math.min(this.x + this.w, sx + sw);
            int y1 = Math.min(this.y + this.h, sy + sh);
            return new Scissor(x0, y0, x1 - x0, y1 - y0);
        }

        public void scissor(ScaledResolution screen) {
            int scale = screen.func_78325_e();
            int sx = this.x * scale;
            int sy = (screen.func_78328_b() - (this.y + this.h)) * scale;
            int sw = this.w * scale;
            int sh = this.h * scale;
            GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
        }
    }
}

