/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui;

import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.icon.IconAnimation;
import com.feed_the_beast.ftbl.lib.icon.ItemIcon;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class IconAnimationButton
extends Button {
    private final IconAnimation list;
    private final int cols;

    public IconAnimationButton(GuiBase gui, int x, int y, IconAnimation i, int c) {
        super(gui, x, y, 16, 16);
        this.list = i;
        this.cols = c;
        this.setWidth(this.cols == 0 ? 16 : 4 + Math.min(this.cols, i.getItemCount()) * 16);
        this.setHeight(this.cols == 0 ? 16 : 4 + (i.getItemCount() / this.cols + 1) * 16);
    }

    @Override
    public void renderWidget() {
        int ax = this.getAX();
        int ay = this.getAY();
        if (this.cols == 0) {
            this.list.draw(ax, ay, 16, 16);
        } else {
            for (int i = this.list.getItemCount() - 1; i >= 0; --i) {
                this.list.setIndex(i);
                this.list.draw(ax + 2 + i % this.cols * 16, ay + 2 + i / this.cols * 16, 16, 16);
            }
        }
    }

    @Override
    public void addMouseOverText(List<String> l) {
        Icon object;
        int index = -1;
        if (this.cols > 0) {
            int mx = this.gui.getMouseX() - this.getAX() - 2;
            int my = this.gui.getMouseY() - this.getAY() - 2;
            if (mx < 0 || my < 0 || mx >= this.width - 4 || my >= this.height - 4) {
                return;
            }
            index = mx / 16 % this.cols + my / 16 * this.cols;
        }
        if ((object = this.list.getObject(index)) instanceof ItemIcon) {
            ItemStack stack = ((ItemIcon)object).getStack();
            l.add(stack.func_82833_r());
            stack.func_77973_b().func_77624_a(stack, (World)ClientUtils.MC.field_71441_e, l, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
        }
    }

    @Override
    public void onClicked(MouseButton button) {
    }
}

